/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.kafka;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.RemovalListener;
import com.github.benmanes.caffeine.cache.Ticker;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import com.vividsolutions.jts.geom.Envelope;
import java.util.concurrent.TimeUnit;
import org.geotools.data.FeatureReader;
import org.geotools.data.collection.DelegateFeatureReader;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.collection.DelegateFeatureIterator;
import org.locationtech.geomesa.kafka.CreateOrUpdate;
import org.locationtech.geomesa.kafka.Delete;
import org.locationtech.geomesa.kafka.FeatureHolder;
import org.locationtech.geomesa.kafka.LiveFeatureCache;
import org.locationtech.geomesa.kafka.LiveFeatureCacheCQEngine$;
import org.locationtech.geomesa.memory.cqengine.GeoCQEngine;
import org.locationtech.geomesa.memory.cqengine.GeoCQEngine$;
import org.locationtech.geomesa.utils.collection.SelfClosingIterator$;
import org.locationtech.geomesa.utils.geotools.Conversions;
import org.locationtech.geomesa.utils.geotools.Conversions$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.Id;
import org.opengis.filter.IncludeFilter;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.GenSetLike;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005me\u0001B\u0001\u0003\u0001-\u0011\u0001\u0004T5wK\u001a+\u0017\r^;sK\u000e\u000b7\r[3D#\u0016sw-\u001b8f\u0015\t\u0019A!A\u0003lC\u001a\\\u0017M\u0003\u0002\u0006\r\u00059q-Z8nKN\f'BA\u0004\t\u00031awnY1uS>tG/Z2i\u0015\u0005I\u0011aA8sO\u000e\u00011\u0003\u0002\u0001\r)a\u0001\"!\u0004\n\u000e\u00039Q!a\u0004\t\u0002\t1\fgn\u001a\u0006\u0002#\u0005!!.\u0019<b\u0013\t\u0019bB\u0001\u0004PE*,7\r\u001e\t\u0003+Yi\u0011AA\u0005\u0003/\t\u0011\u0001\u0003T5wK\u001a+\u0017\r^;sK\u000e\u000b7\r[3\u0011\u0005e\u0001S\"\u0001\u000e\u000b\u0005ma\u0012\u0001D:dC2\fGn\\4hS:<'BA\u000f\u001f\u0003!!\u0018\u0010]3tC\u001a,'\"A\u0010\u0002\u0007\r|W.\u0003\u0002\"5\tYA*\u0019>z\u0019><w-\u001b8h\u0011!\u0019\u0003A!A!\u0002\u0013!\u0013aA:giB\u0011Q\u0005L\u0007\u0002M)\u0011q\u0005K\u0001\u0007g&l\u0007\u000f\\3\u000b\u0005%R\u0013a\u00024fCR,(/\u001a\u0006\u0003W!\tqa\u001c9f]\u001eL7/\u0003\u0002.M\t\t2+[7qY\u00164U-\u0019;ve\u0016$\u0016\u0010]3\t\u0011=\u0002!\u0011!Q\u0001\nA\n\u0001#\u001a=qSJ\fG/[8o!\u0016\u0014\u0018n\u001c3\u0011\u0007E\"d'D\u00013\u0015\u0005\u0019\u0014!B:dC2\f\u0017BA\u001b3\u0005\u0019y\u0005\u000f^5p]B\u0011\u0011gN\u0005\u0003qI\u0012A\u0001T8oO\"A!\b\u0001B\u0001B\u0003-1(\u0001\u0004uS\u000e\\WM\u001d\t\u0003y\u0015k\u0011!\u0010\u0006\u0003}}\nQaY1dQ\u0016T!\u0001Q!\u0002\u0011\r\fgMZ3j]\u0016T!AQ\"\u0002\u0011\t,g.\\1oKNT!\u0001\u0012\u0010\u0002\r\u001dLG\u000f[;c\u0013\t1UH\u0001\u0004US\u000e\\WM\u001d\u0005\u0006\u0011\u0002!\t!S\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007)ke\n\u0006\u0002L\u0019B\u0011Q\u0003\u0001\u0005\u0006u\u001d\u0003\u001da\u000f\u0005\u0006G\u001d\u0003\r\u0001\n\u0005\u0006_\u001d\u0003\r\u0001\r\u0005\b!\u0002\u0011\r\u0011\"\u0001R\u0003\u00159Wm\\2r+\u0005\u0011\u0006CA*Y\u001b\u0005!&BA+W\u0003!\u0019\u0017/\u001a8hS:,'BA,\u0005\u0003\u0019iW-\\8ss&\u0011\u0011\f\u0016\u0002\f\u000f\u0016|7)U#oO&tW\r\u0003\u0004\\\u0001\u0001\u0006IAU\u0001\u0007O\u0016|7-\u001d\u0011\t\u000fy\u0002!\u0019!C\u0005;V\ta\f\u0005\u0003=?\u0006D\u0017B\u00011>\u0005\u0015\u0019\u0015m\u00195f!\t\u0011WM\u0004\u00022G&\u0011AMM\u0001\u0007!J,G-\u001a4\n\u0005\u0019<'AB*ue&twM\u0003\u0002eeA\u0011Q#[\u0005\u0003U\n\u0011QBR3biV\u0014X\rS8mI\u0016\u0014\bB\u00027\u0001A\u0003%a,\u0001\u0004dC\u000eDW\r\t\u0005\b]\u0002\u0011\r\u0011\"\u0001p\u0003!1W-\u0019;ve\u0016\u001cX#\u00019\u0011\tE4\u0018\r[\u0007\u0002e*\u00111\u000f^\u0001\b[V$\u0018M\u00197f\u0015\t)('\u0001\u0006d_2dWm\u0019;j_:L!a\u001e:\u0003\u00075\u000b\u0007\u000f\u0003\u0004z\u0001\u0001\u0006I\u0001]\u0001\nM\u0016\fG/\u001e:fg\u0002BQa\u001f\u0001\u0005\u0002q\fAa]5{KR\tQ\u0010\u0005\u00022}&\u0011qP\r\u0002\u0004\u0013:$\bBB>\u0001\t\u0003\t\u0019\u0001F\u0002~\u0003\u000bA\u0001\"a\u0002\u0002\u0002\u0001\u0007\u0011\u0011B\u0001\u0002MB!\u00111BA\t\u001b\t\tiAC\u0002\u0002\u0010)\naAZ5mi\u0016\u0014\u0018\u0002BA\n\u0003\u001b\u0011aAR5mi\u0016\u0014\bbBA\f\u0001\u0011\u0005\u0013\u0011D\u0001\bG2,\u0017M\\+q)\t\tY\u0002E\u00022\u0003;I1!a\b3\u0005\u0011)f.\u001b;\t\u000f\u0005\r\u0002\u0001\"\u0011\u0002&\u0005)2M]3bi\u0016|%/\u00169eCR,g)Z1ukJ,G\u0003BA\u000e\u0003OA\u0001\"!\u000b\u0002\"\u0001\u0007\u00111F\u0001\u0007kB$\u0017\r^3\u0011\u0007U\ti#C\u0002\u00020\t\u0011ab\u0011:fCR,wJ]+qI\u0006$X\rC\u0004\u00024\u0001!\t%!\u000e\u0002\u001d\u001d,GOR3biV\u0014XMQ=JIR\u0019\u0001.a\u000e\t\u000f\u0005e\u0012\u0011\u0007a\u0001C\u0006\u0011\u0011\u000e\u001a\u0005\b\u0003{\u0001A\u0011IA \u00035\u0011X-\\8wK\u001a+\u0017\r^;sKR!\u00111DA!\u0011!\t\u0019%a\u000fA\u0002\u0005\u0015\u0013\u0001\u0003;p\t\u0016dW\r^3\u0011\u0007U\t9%C\u0002\u0002J\t\u0011a\u0001R3mKR,\u0007bBA'\u0001\u0011\u0005\u0013\u0011D\u0001\u0006G2,\u0017M\u001d\u0005\b\u0003#\u0002A\u0011AA*\u0003I9W\r\u001e*fC\u0012,'OR8s\r&dG/\u001a:\u0015\t\u0005U\u0013Q\u0011\t\u0005\u0003/\nyH\u0004\u0003\u0002Z\u0005ed\u0002BA.\u0003grA!!\u0018\u0002p9!\u0011qLA7\u001d\u0011\t\t'a\u001b\u000f\t\u0005\r\u0014\u0011N\u0007\u0003\u0003KR1!a\u001a\u000b\u0003\u0019a$o\\8u}%\t\u0011\"\u0003\u0002\b\u0011%\u0011QAB\u0005\u0004\u0003c\"\u0011!B;uS2\u001c\u0018\u0002BA;\u0003o\n\u0001bZ3pi>|Gn\u001d\u0006\u0004\u0003c\"\u0011\u0002BA>\u0003{\nq\u0001]1dW\u0006<WM\u0003\u0003\u0002v\u0005]\u0014\u0002BAA\u0003\u0007\u0013!A\u0012*\u000b\t\u0005m\u0014Q\u0010\u0005\t\u0003\u001f\ty\u00051\u0001\u0002\n!9\u0011\u0011\u0012\u0001\u0005\u0002\u0005-\u0015a\u00014jIR!\u0011QKAG\u0011!\ty)a\"A\u0002\u0005E\u0015aA5egB!\u00111BAJ\u0013\u0011\t)*!\u0004\u0003\u0005%#\u0007bBAM\u0001\u0011\u0005\u0013\u0011D\u0001\u0006G2|7/\u001a")
public class LiveFeatureCacheCQEngine
implements LiveFeatureCache,
LazyLogging {
    private final SimpleFeatureType sft;
    private final GeoCQEngine geocq;
    private final Cache<String, FeatureHolder> cache;
    private final Map<String, FeatureHolder> features;
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        LiveFeatureCacheCQEngine liveFeatureCacheCQEngine = this;
        synchronized (liveFeatureCacheCQEngine) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public GeoCQEngine geocq() {
        return this.geocq;
    }

    private Cache<String, FeatureHolder> cache() {
        return this.cache;
    }

    public Map<String, FeatureHolder> features() {
        return this.features;
    }

    @Override
    public int size() {
        return this.features().size();
    }

    @Override
    public int size(Filter f) {
        Filter filter = f;
        IncludeFilter includeFilter = Filter.INCLUDE;
        return !(filter != null ? !filter.equals(includeFilter) : includeFilter != null) ? this.features().size() : SelfClosingIterator$.MODULE$.apply(this.getReaderForFilter(f)).length();
    }

    @Override
    public void cleanUp() {
        this.cache().cleanUp();
    }

    @Override
    public void createOrUpdateFeature(CreateOrUpdate update) {
        SimpleFeature sf = update.feature();
        String id = sf.getID();
        FeatureHolder old = (FeatureHolder)this.cache().getIfPresent((Object)id);
        Object object = old == null ? BoxedUnit.UNIT : BoxesRunTime.boxToBoolean((boolean)this.geocq().remove(old.sf()));
        Envelope env = Conversions.RichSimpleFeature$.MODULE$.geometry$extension(Conversions$.MODULE$.RichSimpleFeature(sf)).getEnvelopeInternal();
        this.geocq().add(sf);
        this.cache().put((Object)id, (Object)new FeatureHolder(sf, env));
    }

    @Override
    public FeatureHolder getFeatureById(String id) {
        return (FeatureHolder)this.cache().getIfPresent((Object)id);
    }

    @Override
    public void removeFeature(Delete toDelete) {
        String id = toDelete.id();
        FeatureHolder old = (FeatureHolder)this.cache().getIfPresent((Object)id);
        if (old != null) {
            this.geocq().remove(old.sf());
            this.cache().invalidate((Object)id);
        }
    }

    @Override
    public void clear() {
        this.cache().invalidateAll();
        this.geocq().clear();
    }

    @Override
    public FeatureReader<SimpleFeatureType, SimpleFeature> getReaderForFilter(Filter filter) {
        FeatureReader<SimpleFeatureType, SimpleFeature> featureReader;
        Filter filter2 = filter;
        if (filter2 instanceof Id) {
            Id id = (Id)filter2;
            featureReader = this.fid(id);
        } else {
            featureReader = this.geocq().getReaderForFilter(filter2);
        }
        return featureReader;
    }

    public FeatureReader<SimpleFeatureType, SimpleFeature> fid(Id ids) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Queried for IDs; using Guava ID index");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Iterator iter = ((GenSetLike)JavaConversions$.MODULE$.asScalaSet(ids.getIDs()).flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LiveFeatureCacheCQEngine $outer;

            public final Iterable<SimpleFeature> apply(Object id) {
                return Option$.MODULE$.option2Iterable(this.$outer.features().get((Object)id.toString()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final SimpleFeature apply(FeatureHolder x$1) {
                        return x$1.sf();
                    }
                }));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Set$.MODULE$.canBuildFrom())).iterator();
        return new DelegateFeatureReader((FeatureType)this.sft, (FeatureIterator)new DelegateFeatureIterator(JavaConversions$.MODULE$.asJavaIterator(iter)));
    }

    @Override
    public void close() {
    }

    public LiveFeatureCacheCQEngine(SimpleFeatureType sft, Option<Object> expirationPeriod, Ticker ticker) {
        this.sft = sft;
        LazyLogging.class.$init$((LazyLogging)this);
        this.geocq = new GeoCQEngine(sft, GeoCQEngine$.MODULE$.$lessinit$greater$default$2(), GeoCQEngine$.MODULE$.$lessinit$greater$default$3());
        Caffeine cb = Caffeine.newBuilder().ticker(ticker);
        expirationPeriod.foreach((Function1)new Serializable(this, cb){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LiveFeatureCacheCQEngine $outer;
            private final Caffeine cb$1;

            public final Caffeine<String, FeatureHolder> apply(long ep) {
                return this.cb$1.expireAfterWrite(ep, TimeUnit.MILLISECONDS).removalListener((RemovalListener)new RemovalListener<String, FeatureHolder>(this, ep){
                    private final /* synthetic */ $anonfun$1 $outer;
                    private final long ep$1;

                    public void onRemoval(String key, FeatureHolder value, RemovalCause cause) {
                        RemovalCause removalCause = cause;
                        RemovalCause removalCause2 = RemovalCause.EXPIRED;
                        if (!(removalCause != null ? !removalCause.equals(removalCause2) : removalCause2 != null)) {
                            BoxedUnit boxedUnit;
                            if (this.$outer.org$locationtech$geomesa$kafka$LiveFeatureCacheCQEngine$$anonfun$$$outer().logger().underlying().isDebugEnabled()) {
                                this.$outer.org$locationtech$geomesa$kafka$LiveFeatureCacheCQEngine$$anonfun$$$outer().logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Removing feature ", " due to expiration after ", "ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key, BoxesRunTime.boxToLong((long)this.ep$1)})));
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            this.$outer.org$locationtech$geomesa$kafka$LiveFeatureCacheCQEngine$$anonfun$$$outer().geocq().remove(value.sf());
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.ep$1 = ep$1;
                    }
                });
            }

            public /* synthetic */ LiveFeatureCacheCQEngine org$locationtech$geomesa$kafka$LiveFeatureCacheCQEngine$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.cb$1 = cb$1;
            }
        });
        this.cache = cb.build();
        this.features = (Map)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.cache().asMap()).asScala();
    }
}

