/*
 * Decompiled with CFR 0.152.
 */
package org.geomesa.gs.monitor.elastic;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.http.HttpHost;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.xcontent.XContentType;
import org.geomesa.gs.monitor.elastic.ElasticRequestDataListener$;
import org.geoserver.monitor.RequestData;
import org.geoserver.monitor.RequestDataListener;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0001\tEd\u0001B\u0001\u0003\u00015\u0011!$\u00127bgRL7MU3rk\u0016\u001cH\u000fR1uC2K7\u000f^3oKJT!a\u0001\u0003\u0002\u000f\u0015d\u0017m\u001d;jG*\u0011QAB\u0001\b[>t\u0017\u000e^8s\u0015\t9\u0001\"\u0001\u0002hg*\u0011\u0011BC\u0001\bO\u0016|W.Z:b\u0015\u0005Y\u0011aA8sO\u000e\u00011\u0003\u0002\u0001\u000f-u\u0001\"a\u0004\u000b\u000e\u0003AQ!!\u0005\n\u0002\t1\fgn\u001a\u0006\u0002'\u0005!!.\u0019<b\u0013\t)\u0002C\u0001\u0004PE*,7\r\u001e\t\u0003/mi\u0011\u0001\u0007\u0006\u0003\u000beQ!A\u0007\u0006\u0002\u0013\u001d,wn]3sm\u0016\u0014\u0018B\u0001\u000f\u0019\u0005M\u0011V-];fgR$\u0015\r^1MSN$XM\\3s!\tqR%D\u0001 \u0015\t\u0001\u0013%\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0002#G\u0005AA/\u001f9fg\u00064WMC\u0001%\u0003\r\u0019w.\\\u0005\u0003M}\u00111\u0002T1{s2{wmZ5oO\")\u0001\u0006\u0001C\u0001S\u00051A(\u001b8jiz\"\u0012A\u000b\t\u0003W\u0001i\u0011A\u0001\u0005\b[\u0001\u0011\r\u0011\"\u0001/\u0003\u001d)gN\u001e,beN,\u0012a\f\t\u0004aM*T\"A\u0019\u000b\u0003I\nQa]2bY\u0006L!\u0001N\u0019\u0003\u000b\u0005\u0013(/Y=\u0011\u0005YJdB\u0001\u00198\u0013\tA\u0014'\u0001\u0004Qe\u0016$WMZ\u0005\u0003um\u0012aa\u0015;sS:<'B\u0001\u001d2\u0011\u0019i\u0004\u0001)A\u0005_\u0005AQM\u001c<WCJ\u001c\b\u0005C\u0004@\u0001\u0001\u0007I\u0011\u0001!\u0002\t!|7\u000f^\u000b\u0002\u0003B\u0011qBQ\u0005\u0003uAAq\u0001\u0012\u0001A\u0002\u0013\u0005Q)\u0001\u0005i_N$x\fJ3r)\t1\u0015\n\u0005\u00021\u000f&\u0011\u0001*\r\u0002\u0005+:LG\u000fC\u0004K\u0007\u0006\u0005\t\u0019A!\u0002\u0007a$\u0013\u0007\u0003\u0004M\u0001\u0001\u0006K!Q\u0001\u0006Q>\u001cH\u000f\t\u0005\b\u001d\u0002\u0001\r\u0011\"\u0001P\u0003\u0011\u0001xN\u001d;\u0016\u0003A\u0003\"\u0001M)\n\u0005I\u000b$aA%oi\"9A\u000b\u0001a\u0001\n\u0003)\u0016\u0001\u00039peR|F%Z9\u0015\u0005\u00193\u0006b\u0002&T\u0003\u0003\u0005\r\u0001\u0015\u0005\u00071\u0002\u0001\u000b\u0015\u0002)\u0002\u000bA|'\u000f\u001e\u0011\t\u000fi\u0003\u0001\u0019!C\u0001\u0001\u0006A\u0001O]8u_\u000e|G\u000eC\u0004]\u0001\u0001\u0007I\u0011A/\u0002\u0019A\u0014x\u000e^8d_2|F%Z9\u0015\u0005\u0019s\u0006b\u0002&\\\u0003\u0003\u0005\r!\u0011\u0005\u0007A\u0002\u0001\u000b\u0015B!\u0002\u0013A\u0014x\u000e^8d_2\u0004\u0003b\u00022\u0001\u0005\u0004%\taY\u0001\tQ>\u001cH\u000fT5tiV\tA\rE\u0002fU2l\u0011A\u001a\u0006\u0003O\"\fq!\\;uC\ndWM\u0003\u0002jc\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005-4'aC!se\u0006L()\u001e4gKJ\u0004\"!\u001c:\u000e\u00039T!a\u001c9\u0002\t!$H\u000f\u001d\u0006\u0003c*\ta!\u00199bG\",\u0017BA:o\u0005!AE\u000f\u001e9I_N$\bBB;\u0001A\u0003%A-A\u0005i_N$H*[:uA!9q\u000f\u0001b\u0001\n\u0003A\u0018!\u00025pgR\u001cX#A=\u0011\u0007A\u001aD\u000e\u0003\u0004|\u0001\u0001\u0006I!_\u0001\u0007Q>\u001cHo\u001d\u0011\t\u000fu\u0004!\u0019!C\u0001}\u000611\r\\5f]R,\u0012a \t\u0005\u0003\u0003\tI!\u0004\u0002\u0002\u0004)\u0019Q0!\u0002\u000b\u0007\u0005\u001d!\"A\u0007fY\u0006\u001cH/[2tK\u0006\u00148\r[\u0005\u0005\u0003\u0017\t\u0019AA\nSKN$\b*[4i\u0019\u00164X\r\\\"mS\u0016tG\u000fC\u0004\u0002\u0010\u0001\u0001\u000b\u0011B@\u0002\u000f\rd\u0017.\u001a8uA!I\u00111\u0003\u0001A\u0002\u0013\u0005\u0011QC\u0001\u0006S:$W\r_\u000b\u0002k!I\u0011\u0011\u0004\u0001A\u0002\u0013\u0005\u00111D\u0001\nS:$W\r_0%KF$2ARA\u000f\u0011!Q\u0015qCA\u0001\u0002\u0004)\u0004bBA\u0011\u0001\u0001\u0006K!N\u0001\u0007S:$W\r\u001f\u0011\t\u000f\u0005\u0015\u0002\u0001\"\u0011\u0002(\u0005q!/Z9vKN$8\u000b^1si\u0016$Gc\u0001$\u0002*!A\u00111FA\u0012\u0001\u0004\ti#A\u0006sKF,Xm\u001d;ECR\f\u0007cA\f\u00020%\u0019\u0011\u0011\u0007\r\u0003\u0017I+\u0017/^3ti\u0012\u000bG/\u0019\u0005\b\u0003k\u0001A\u0011IA\u001c\u00039\u0011X-];fgR,\u0006\u000fZ1uK\u0012$2ARA\u001d\u0011!\tY#a\rA\u0002\u00055\u0002bBA\u001f\u0001\u0011\u0005\u0013qH\u0001\u0011e\u0016\fX/Z:u\u0007>l\u0007\u000f\\3uK\u0012$2ARA!\u0011!\tY#a\u000fA\u0002\u00055\u0002bBA#\u0001\u0011%\u0011qI\u0001\u0015oJLG/\u001a+p\u000b2\f7\u000f^5dg\u0016\f'o\u00195\u0015\t\u0005%\u0013q\n\t\u0004a\u0005-\u0013bAA'c\t\u0019\u0011I\\=\t\u0011\u0005-\u00121\ta\u0001\u0003[1a!a\u0015\u0001\u0001\u0005U#a\u0004'pO\u001eLgnZ\"bY2\u0014\u0017mY6\u0014\r\u0005Ec\"a\u0016\u001e!\u0019\tI&a\u0018\u0002d5\u0011\u00111\f\u0006\u0005\u0003;\n)!\u0001\u0004bGRLwN\\\u0005\u0005\u0003C\nYF\u0001\bBGRLwN\u001c'jgR,g.\u001a:\u0011\t\u0005\u0015\u0014\u0011N\u0007\u0003\u0003ORA!a\u0005\u0002\\%!\u00111NA4\u00055Ie\u000eZ3y%\u0016\u001c\bo\u001c8tK\"9\u0001&!\u0015\u0005\u0002\u0005=DCAA9!\u0011\t\u0019(!\u0015\u000e\u0003\u0001A\u0001\"a\u001e\u0002R\u0011\u0005\u0013\u0011P\u0001\u000b_:\u0014Vm\u001d9p]N,Gc\u0001$\u0002|!A\u0011QPA;\u0001\u0004\t\u0019'\u0001\bj]\u0012,\u0007p\u0018:fgB|gn]3\t\u0011\u0005\u0005\u0015\u0011\u000bC!\u0003\u0007\u000b\u0011b\u001c8GC&dWO]3\u0015\u0007\u0019\u000b)\t\u0003\u0005\u0002\b\u0006}\u0004\u0019AAE\u0003\t)\u0007\u0010\u0005\u0003\u0002\f\u0006me\u0002BAG\u0003/sA!a$\u0002\u00166\u0011\u0011\u0011\u0013\u0006\u0004\u0003'c\u0011A\u0002\u001fs_>$h(C\u00013\u0013\r\tI*M\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ti*a(\u0003\u0013\u0015C8-\u001a9uS>t'bAAMc!9\u00111\u0015\u0001\u0005B\u0005\u0015\u0016\u0001\u0006:fcV,7\u000f\u001e)pgR\u0004&o\\2fgN,G\rF\u0002G\u0003OC\u0001\"a\u000b\u0002\"\u0002\u0007\u0011QF\u0004\b\u0003W\u0013\u0001\u0012AAW\u0003i)E.Y:uS\u000e\u0014V-];fgR$\u0015\r^1MSN$XM\\3s!\rY\u0013q\u0016\u0004\u0007\u0003\tA\t!!-\u0014\t\u0005=\u00161\u0017\t\u0004a\u0005U\u0016bAA\\c\t1\u0011I\\=SK\u001aDq\u0001KAX\t\u0003\tY\f\u0006\u0002\u0002.\"Q\u0011qXAX\u0005\u0004%I!!1\u0002\t\u001d\u001cxN\\\u000b\u0003\u0003\u0007\u0004B!!2\u0002N6\u0011\u0011q\u0019\u0006\u0005\u0003\u007f\u000bIMC\u0002\u0002L\u000e\naaZ8pO2,\u0017\u0002BAh\u0003\u000f\u0014AaR:p]\"I\u00111[AXA\u0003%\u00111Y\u0001\u0006ON|g\u000eI\u0004\t\u0003/\fy\u000b#\u0001\u0002Z\u0006qA)\u0019;f'\u0016\u0014\u0018.\u00197ju\u0016\u0014\b\u0003BAn\u0003;l!!a,\u0007\u0011\u0005}\u0017q\u0016E\u0001\u0003C\u0014a\u0002R1uKN+'/[1mSj,'oE\u0003\u0002^:\t\u0019\u000f\u0005\u0004\u0002F\u0006\u0015\u0018\u0011^\u0005\u0005\u0003O\f9M\u0001\bKg>t7+\u001a:jC2L'0\u001a:\u0011\t\u0005-\u0018\u0011_\u0007\u0003\u0003[T1!a<\u0013\u0003\u0011)H/\u001b7\n\t\u0005M\u0018Q\u001e\u0002\u0005\t\u0006$X\rC\u0004)\u0003;$\t!a>\u0015\u0005\u0005e\u0007\u0002CA~\u0003;$\t%!@\u0002\u0013M,'/[1mSj,G\u0003CA\u0000\u0005\u000b\u0011IA!\u0007\u0011\t\u0005\u0015'\u0011A\u0005\u0005\u0005\u0007\t9MA\u0006Kg>tW\t\\3nK:$\b\u0002\u0003B\u0004\u0003s\u0004\r!!;\u0002\u0007M\u00148\r\u0003\u0005\u0003\f\u0005e\b\u0019\u0001B\u0007\u0003%!\u0018\u0010]3PMN\u00138\r\u0005\u0003\u0003\u0010\tUQB\u0001B\t\u0015\r\u0011\u0019\u0002E\u0001\be\u00164G.Z2u\u0013\u0011\u00119B!\u0005\u0003\tQK\b/\u001a\u0005\t\u00057\tI\u00101\u0001\u0003\u001e\u000591m\u001c8uKb$\b\u0003BAc\u0005?IAA!\t\u0002H\nA\"j]8o'\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8D_:$X\r\u001f;\b\u0011\t\u0015\u0012q\u0016E\u0001\u0005O\tQCQ8v]\u0012Lgn\u001a\"pqN+'/[1mSj,'\u000f\u0005\u0003\u0002\\\n%b\u0001\u0003B\u0016\u0003_C\tA!\f\u0003+\t{WO\u001c3j]\u001e\u0014u\u000e_*fe&\fG.\u001b>feN)!\u0011\u0006\b\u00030A1\u0011QYAs\u0005c\u0001BAa\r\u0003>5\u0011!Q\u0007\u0006\u0005\u0005o\u0011I$\u0001\u0005hK>lW\r\u001e:z\u0015\r\u0011YDC\u0001\b_B,gnZ5t\u0013\u0011\u0011yD!\u000e\u0003\u0017\t{WO\u001c3j]\u001e\u0014u\u000e\u001f\u0005\bQ\t%B\u0011\u0001B\")\t\u00119\u0003\u0003\u0005\u0002|\n%B\u0011\tB$)!\tyP!\u0013\u0003L\t5\u0003\u0002\u0003B\u0004\u0005\u000b\u0002\rA!\r\t\u0011\t-!Q\ta\u0001\u0005\u001bA\u0001Ba\u0007\u0003F\u0001\u0007!QD\u0004\t\u0005#\ny\u000b#\u0001\u0003T\u0005\u0019B\u000b\u001b:po\u0006\u0014G.Z*fe&\fG.\u001b>feB!\u00111\u001cB+\r!\u00119&a,\t\u0002\te#a\u0005+ie><\u0018M\u00197f'\u0016\u0014\u0018.\u00197ju\u0016\u00148#\u0002B+\u001d\tm\u0003CBAc\u0003K\u0014i\u0006\u0005\u0003\u0002\f\n}\u0013\u0002\u0002B1\u0003?\u0013\u0011\u0002\u00165s_^\f'\r\\3\t\u000f!\u0012)\u0006\"\u0001\u0003fQ\u0011!1\u000b\u0005\t\u0003w\u0014)\u0006\"\u0011\u0003jQA\u0011q B6\u0005[\u0012y\u0007\u0003\u0005\u0003\b\t\u001d\u0004\u0019\u0001B/\u0011!\u0011YAa\u001aA\u0002\t5\u0001\u0002\u0003B\u000e\u0005O\u0002\rA!\b")
public class ElasticRequestDataListener
implements RequestDataListener,
LazyLogging {
    private final String[] envVars;
    private String host;
    private int port;
    private String protocol;
    private final ArrayBuffer<HttpHost> hostList;
    private final HttpHost[] hosts;
    private final RestHighLevelClient client;
    private String index;
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        ElasticRequestDataListener elasticRequestDataListener = this;
        synchronized (elasticRequestDataListener) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String[] envVars() {
        return this.envVars;
    }

    public String host() {
        return this.host;
    }

    public void host_$eq(String x$1) {
        this.host = x$1;
    }

    public int port() {
        return this.port;
    }

    public void port_$eq(int x$1) {
        this.port = x$1;
    }

    public String protocol() {
        return this.protocol;
    }

    public void protocol_$eq(String x$1) {
        this.protocol = x$1;
    }

    public ArrayBuffer<HttpHost> hostList() {
        return this.hostList;
    }

    public HttpHost[] hosts() {
        return this.hosts;
    }

    public RestHighLevelClient client() {
        return this.client;
    }

    public String index() {
        return this.index;
    }

    public void index_$eq(String x$1) {
        this.index = x$1;
    }

    public void requestStarted(RequestData requestData) {
    }

    public void requestUpdated(RequestData requestData) {
        this.writeToElasticsearch(requestData);
    }

    public void requestCompleted(RequestData requestData) {
    }

    /*
     * Enabled aggressive block sorting
     */
    private Object writeToElasticsearch(RequestData requestData) {
        BoxedUnit boxedUnit;
        block3: {
            block2: {
                if (requestData.getResources().isEmpty()) break block2;
                RequestData.Status status = requestData.getStatus();
                RequestData.Status status2 = RequestData.Status.FAILED;
                if ((status != null ? !status.equals(status2) : status2 != null) || requestData.getEndTime() != null) break block3;
            }
            boxedUnit = BoxedUnit.UNIT;
            return boxedUnit;
        }
        String json = ElasticRequestDataListener$.MODULE$.org$geomesa$gs$monitor$elastic$ElasticRequestDataListener$$gson().toJson((Object)requestData);
        IndexRequest request = new IndexRequest(this.index());
        request.source(json, XContentType.JSON);
        boxedUnit = this.client().indexAsync(request, RequestOptions.DEFAULT, (ActionListener)new LoggingCallback());
        return boxedUnit;
    }

    public void requestPostProcessed(RequestData requestData) {
    }

    public ElasticRequestDataListener() {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        LazyLogging.class.$init$((LazyLogging)this);
        this.envVars = new StringOps(Predef$.MODULE$.augmentString((String)package$.MODULE$.env().getOrElse((Object)"ELASTICSEARCH_HOST", (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "unset";
            }
        }))).split(',');
        String string = this.envVars()[0];
        String string2 = "unset";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            BoxedUnit boxedUnit3;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Environment variable ELASTICSEARCH_HOST is not set");
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            throw new Exception("Environment variable ELASTICSEARCH_HOST is not set. Stopping build.");
        }
        this.host = "";
        this.port = 0;
        this.protocol = "";
        this.hostList = new ArrayBuffer();
        Predef$.MODULE$.refArrayOps((Object[])this.envVars()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ElasticRequestDataListener $outer;

            public final void apply(String u) {
                try {
                    URL url = new URL(u.trim());
                    this.$outer.host_$eq(url.getHost());
                    this.$outer.port_$eq(url.getPort());
                    this.$outer.protocol_$eq(url.getProtocol());
                    this.$outer.hostList().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new HttpHost[]{new HttpHost(this.$outer.host(), this.$outer.port(), this.$outer.protocol())}));
                }
                catch (MalformedURLException malformedURLException) {
                    BoxedUnit boxedUnit;
                    if (this.$outer.logger().underlying().isErrorEnabled()) {
                        this.$outer.logger().underlying().error(new StringBuilder().append((Object)"Invalid URL ").append((Object)u).append((Object)". Could not convert from string to URL. Trying any additional URLs").toString());
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        if (this.hostList().length() == 0) {
            BoxedUnit boxedUnit4;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(new StringBuilder().append((Object)"No URL given. Could not resolve ").append((Object)Predef$.MODULE$.refArrayOps((Object[])this.envVars()).mkString(",")).toString());
                boxedUnit4 = BoxedUnit.UNIT;
            } else {
                boxedUnit4 = BoxedUnit.UNIT;
            }
            throw new Exception(new StringBuilder().append((Object)"Given URL(s) ").append((Object)Predef$.MODULE$.refArrayOps((Object[])this.envVars()).mkString(",")).append((Object)" cannot be read by Java URL").toString());
        }
        this.hosts = (HttpHost[])this.hostList().toArray(ClassTag$.MODULE$.apply(HttpHost.class));
        this.client = new RestHighLevelClient(RestClient.builder((HttpHost[])this.hosts()));
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder().append((Object)"Sending requests to ").append((Object)this.hosts()).toString());
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        this.index = (String)package$.MODULE$.env().getOrElse((Object)"GEOSERVER_ES_INDEX", (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Null$ apply() {
                return null;
            }
        });
        if (this.index() == null) {
            this.index_$eq("geoserver");
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("No index name provided. Index will be set to default name 'geoserver'");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public class LoggingCallback
    implements ActionListener<IndexResponse>,
    LazyLogging {
        private final Logger logger;
        private volatile boolean bitmap$0;

        private Logger logger$lzycompute() {
            LoggingCallback loggingCallback = this;
            synchronized (loggingCallback) {
                if (!this.bitmap$0) {
                    this.logger = LazyLogging.class.logger((LazyLogging)this);
                    this.bitmap$0 = true;
                }
                return this.logger;
            }
        }

        public Logger logger() {
            return this.bitmap$0 ? this.logger : this.logger$lzycompute();
        }

        public void onResponse(IndexResponse index_response) {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            String index = index_response.getIndex();
            String id = index_response.getId();
            if (index_response.getResult() == DocWriteResponse.Result.CREATED) {
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(new StringBuilder().append((Object)"Request indexed in ").append((Object)index).append((Object)" with Id ").append((Object)id).toString());
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            ReplicationResponse.ShardInfo shardInfo = index_response.getShardInfo();
            if (shardInfo.getTotal() != shardInfo.getSuccessful()) {
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(new StringBuilder().append((Object)"Total shards do not match successful shards. Total: ").append((Object)BoxesRunTime.boxToInteger((int)shardInfo.getTotal())).append((Object)" Successful: ").append((Object)BoxesRunTime.boxToInteger((int)shardInfo.getSuccessful())).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            if (shardInfo.getFailed() > 0) {
                Predef$.MODULE$.refArrayOps((Object[])shardInfo.getFailures()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ LoggingCallback $outer;

                    public final void apply(ReplicationResponse.ShardInfo.Failure failure) {
                        BoxedUnit boxedUnit;
                        String reason = failure.reason();
                        if (this.$outer.logger().underlying().isWarnEnabled()) {
                            this.$outer.logger().underlying().warn(new StringBuilder().append((Object)"Shard Failure: ").append((Object)reason).toString());
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
        }

        public void onFailure(Exception ex) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(new StringBuilder().append((Object)"Index request failed, caused by: ").append((Object)ex).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        }

        public /* synthetic */ ElasticRequestDataListener org$geomesa$gs$monitor$elastic$ElasticRequestDataListener$LoggingCallback$$$outer() {
            return ElasticRequestDataListener.this;
        }

        public LoggingCallback() {
            if (ElasticRequestDataListener.this == null) {
                throw null;
            }
            LazyLogging.class.$init$((LazyLogging)this);
        }
    }
}

