/*
 * Decompiled with CFR 0.152.
 */
package org.geomesa.gs.monitor.elastic;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.List;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.geomesa.gs.monitor.elastic.ExtendedRequestData;
import org.geomesa.gs.monitor.elastic.ExtendedRequestData$$anonfun$org$geomesa$gs$monitor$elastic$ExtendedRequestData$;
import org.geomesa.gs.monitor.elastic.RequestData;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geotools.filter.text.ecql.ECQL;
import org.locationtech.geomesa.filter.FilterHelper$;
import org.locationtech.geomesa.utils.text.WKTUtils$;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.opengis.filter.Filter;
import org.opengis.geometry.BoundingBox;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.util.Try;
import scala.util.Try$;

public final class ExtendedRequestData$
implements LazyLogging,
Serializable {
    public static final ExtendedRequestData$ MODULE$;
    private final String CQL_FILTER_START_KEY;
    private final String CQL_FILTER_END_KEY;
    private final String TIMEOUT_KEY;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new ExtendedRequestData$();
    }

    private Logger logger$lzycompute() {
        ExtendedRequestData$ extendedRequestData$ = this;
        synchronized (extendedRequestData$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String CQL_FILTER_START_KEY() {
        return this.CQL_FILTER_START_KEY;
    }

    public String CQL_FILTER_END_KEY() {
        return this.CQL_FILTER_END_KEY;
    }

    public String TIMEOUT_KEY() {
        return this.TIMEOUT_KEY;
    }

    public Gson getGson(Set<String> excludedFields) {
        return new GsonBuilder().registerTypeAdapter(Point.class, (Object)new JsonSerializer<Point>(){

            public JsonElement serialize(Point point, Type type, JsonSerializationContext context) {
                return new JsonPrimitive(WKTUtils$.MODULE$.write((Geometry)point));
            }
        }).registerTypeAdapter(Date.class, (Object)new JsonSerializer<Date>(){

            public JsonElement serialize(Date date, Type type, JsonSerializationContext context) {
                return new JsonPrimitive((Number)Predef$.MODULE$.long2Long(date.getTime()));
            }
        }).registerTypeAdapter(BoundingBox.class, (Object)new JsonSerializer<BoundingBox>(){

            public JsonElement serialize(BoundingBox bbox, Type type, JsonSerializationContext context) {
                return new JsonPrimitive(bbox.toString());
            }
        }).registerTypeAdapter(Throwable.class, (Object)new JsonSerializer<Throwable>(){

            public JsonElement serialize(Throwable ex, Type type, JsonSerializationContext context) {
                return new JsonPrimitive(ex.getMessage());
            }
        }).registerTypeAdapter(byte[].class, (Object)new JsonSerializer<byte[]>(){

            public JsonElement serialize(byte[] array, Type type, JsonSerializationContext context) {
                return new JsonPrimitive(Base64.encodeBase64String((byte[])array));
            }
        }).addSerializationExclusionStrategy(new ExclusionStrategy(excludedFields){
            private final Set excludedFields$1;

            public boolean shouldSkipClass(Class<?> clazz) {
                return false;
            }

            public boolean shouldSkipField(FieldAttributes fieldAttributes) {
                return this.excludedFields$1.contains((Object)fieldAttributes.getName());
            }
            {
                this.excludedFields$1 = excludedFields$1;
            }
        }).setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).disableHtmlEscaping().create();
    }

    public Seq<Point> org$geomesa$gs$monitor$elastic$ExtendedRequestData$$extractFilterCentroids(Filter filter) {
        return (Seq)FilterHelper$.MODULE$.propertyNames(filter).flatMap((Function1)new Serializable(filter){
            public static final long serialVersionUID = 0L;
            private final Filter filter$1;

            public final Seq<Point> apply(String x$6) {
                return (Seq)FilterHelper$.MODULE$.extractGeometries(this.filter$1, x$6, FilterHelper$.MODULE$.extractGeometries$default$3()).values().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Point apply(Geometry x$7) {
                        return x$7.getCentroid();
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
            {
                this.filter$1 = filter$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public Option<Filter> org$geomesa$gs$monitor$elastic$ExtendedRequestData$$extractCqlFilter(String queryString) {
        int filterStartKeyIdx = StringUtils.indexOfIgnoreCase((CharSequence)queryString, (CharSequence)this.CQL_FILTER_START_KEY());
        if (filterStartKeyIdx < 0) {
            return None$.MODULE$;
        }
        int filterStartIdx = filterStartKeyIdx + StringUtils.length((CharSequence)this.CQL_FILTER_START_KEY());
        String filterStart = queryString.substring(filterStartIdx);
        int filterEndKeyIdx = StringUtils.indexOfIgnoreCase((CharSequence)filterStart, (CharSequence)this.CQL_FILTER_END_KEY());
        String filterString = filterEndKeyIdx < 0 ? filterStart : filterStart.substring(0, filterEndKeyIdx);
        return this.TryExtensions(Try$.MODULE$.apply((Function0)new Serializable(filterString){
            public static final long serialVersionUID = 0L;
            private final String filterString$1;

            public final Filter apply() {
                return ECQL.toFilter((String)this.filterString$1);
            }
            {
                this.filterString$1 = filterString$1;
            }
        })).orLog((Function0<Function1<Throwable, String>>)new Serializable(queryString){
            public static final long serialVersionUID = 0L;
            public final String queryString$1;

            public final Function1<Throwable, String> apply() {
                return new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun$org$geomesa$gs$monitor$elastic$ExtendedRequestData$$extractCqlFilter$2 $outer;

                    public final String apply(Throwable ex) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to parse filter from '", "': ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.queryString$1, ex.getMessage()}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                };
            }
            {
                this.queryString$1 = queryString$1;
            }
        });
    }

    public Option<LdapName> org$geomesa$gs$monitor$elastic$ExtendedRequestData$$extractDistinguishedName(String dnString) {
        return this.TryExtensions(Try$.MODULE$.apply((Function0)new Serializable(dnString){
            public static final long serialVersionUID = 0L;
            private final String dnString$1;

            public final LdapName apply() {
                return new LdapName(this.dnString$1);
            }
            {
                this.dnString$1 = dnString$1;
            }
        })).orLog((Function0<Function1<Throwable, String>>)new Serializable(dnString){
            public static final long serialVersionUID = 0L;
            public final String dnString$1;

            public final Function1<Throwable, String> apply() {
                return new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun$org$geomesa$gs$monitor$elastic$ExtendedRequestData$$extractDistinguishedName$2 $outer;

                    public final String apply(Throwable ex) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to parse distinguished name from '", "': ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.dnString$1, ex.getMessage()}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                };
            }
            {
                this.dnString$1 = dnString$1;
            }
        });
    }

    public Seq<String> org$geomesa$gs$monitor$elastic$ExtendedRequestData$$extractRdnValues(LdapName dn, String key) {
        return (Seq)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(dn.getRdns()).asScala()).filter((Function1)new Serializable(key){
            public static final long serialVersionUID = 0L;
            private final String key$1;

            public final boolean apply(Rdn x$8) {
                return x$8.getType().equalsIgnoreCase(this.key$1);
            }
            {
                this.key$1 = key$1;
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Rdn x$9) {
                return x$9.getValue().toString();
            }
        }, Buffer$.MODULE$.canBuildFrom());
    }

    private ResourceInfo extractResourceInfo(String resource, Catalog catalog) {
        return catalog.getLayerByName(resource).getResource();
    }

    public String org$geomesa$gs$monitor$elastic$ExtendedRequestData$$extractResourceName(String resource, Catalog catalog) {
        return this.extractResourceInfo(resource, catalog).getName();
    }

    private StoreInfo extractResourceStore(String resource, Catalog catalog) {
        return this.extractResourceInfo(resource, catalog).getStore();
    }

    public String org$geomesa$gs$monitor$elastic$ExtendedRequestData$$extractResourceTitle(String resource, Catalog catalog) {
        return this.extractResourceInfo(resource, catalog).getTitle();
    }

    public String org$geomesa$gs$monitor$elastic$ExtendedRequestData$$extractStoreName(String resource, Catalog catalog) {
        return this.extractResourceStore(resource, catalog).getName();
    }

    public String org$geomesa$gs$monitor$elastic$ExtendedRequestData$$extractStoreWorkspace(String resource, Catalog catalog) {
        return this.extractResourceStore(resource, catalog).getWorkspace().getName();
    }

    public String org$geomesa$gs$monitor$elastic$ExtendedRequestData$$extractResourceStoreType(String resource, Catalog catalog) {
        return this.extractResourceStore(resource, catalog).getType();
    }

    public List<String> org$geomesa$gs$monitor$elastic$ExtendedRequestData$$handleExtractResource(RequestData requestData, Catalog catalog, Function2<String, Catalog, String> extractor) {
        return (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(requestData.getResources()).asScala()).map((Function1)new Serializable(catalog, extractor){
            public static final long serialVersionUID = 0L;
            private final Catalog catalog$1;
            private final Function2 extractor$1;

            public final String apply(String x$10) {
                return (String)this.extractor$1.apply((Object)x$10, (Object)this.catalog$1);
            }
            {
                this.catalog$1 = catalog$1;
                this.extractor$1 = extractor$1;
            }
        }, Buffer$.MODULE$.canBuildFrom())).asJava();
    }

    private <T> ExtendedRequestData.TryExtensions<T> TryExtensions(Try<T> result) {
        return new ExtendedRequestData.TryExtensions<T>(result);
    }

    public <T> ExtendedRequestData.OptionSeqExtensions<T> org$geomesa$gs$monitor$elastic$ExtendedRequestData$$OptionSeqExtensions(Option<Seq<T>> optSeq) {
        return new ExtendedRequestData.OptionSeqExtensions<T>(optSeq);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private ExtendedRequestData$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
        this.CQL_FILTER_START_KEY = "CQL_FILTER=";
        this.CQL_FILTER_END_KEY = "&";
        this.TIMEOUT_KEY = "TIMEOUT";
    }
}

