/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.javarosa.core.model.FormDef;
import org.javarosa.core.model.FormIndex;
import org.javarosa.core.model.QuickTriggerable;
import org.javarosa.core.model.ValidateOutcome;
import org.javarosa.core.model.condition.Condition;
import org.javarosa.core.model.condition.EvaluationContext;
import org.javarosa.core.model.condition.IConditionExpr;
import org.javarosa.core.model.condition.Recalculate;
import org.javarosa.core.model.condition.Triggerable;
import org.javarosa.core.model.instance.FormInstance;
import org.javarosa.core.model.instance.TreeElement;
import org.javarosa.core.model.instance.TreeReference;
import org.javarosa.debug.Event;
import org.javarosa.debug.EventNotifier;
import org.javarosa.form.api.FormEntryController;
import org.javarosa.model.xform.XPathReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IDag {
    private static final Logger logger = LoggerFactory.getLogger(IDag.class);
    protected final EventNotifierAccessor accessor;
    protected final ArrayList<QuickTriggerable> triggerablesDAG = new ArrayList();
    protected final HashMap<TreeReference, QuickTriggerable> conditionRepeatTargetIndex = new HashMap();
    protected final HashMap<TreeReference, ArrayList<QuickTriggerable>> triggerIndex = new HashMap();
    protected final ArrayList<QuickTriggerable> unorderedTriggerables = new ArrayList();

    protected IDag(EventNotifierAccessor accessor) {
        this.accessor = accessor;
    }

    public abstract FormDef.EvalBehavior getEvalBehavior();

    public abstract QuickTriggerable getTriggerableForRepeatGroup(TreeReference var1);

    public abstract Collection<QuickTriggerable> triggerTriggerables(FormInstance var1, EvaluationContext var2, TreeReference var3, boolean var4);

    public abstract void deleteRepeatGroup(FormInstance var1, EvaluationContext var2, TreeReference var3, TreeElement var4, TreeElement var5);

    public abstract void createRepeatGroup(FormInstance var1, EvaluationContext var2, TreeReference var3, TreeElement var4, TreeElement var5);

    public abstract void copyItemsetAnswer(FormInstance var1, EvaluationContext var2, TreeReference var3, TreeElement var4, boolean var5);

    private final QuickTriggerable findTriggerable(Triggerable t) {
        for (QuickTriggerable qt : this.unorderedTriggerables) {
            if (!t.equals(qt.t)) continue;
            return qt;
        }
        return null;
    }

    public final Triggerable addTriggerable(Triggerable t) {
        QuickTriggerable qt = this.findTriggerable(t);
        if (qt != null) {
            Triggerable existingTriggerable = qt.t;
            existingTriggerable.changeContextRefToIntersectWithTriggerable(t);
            return existingTriggerable;
        }
        qt = new QuickTriggerable(t);
        this.unorderedTriggerables.add(qt);
        Set<TreeReference> triggers = t.getTriggers();
        for (TreeReference trigger : triggers) {
            ArrayList<QuickTriggerable> triggered = this.triggerIndex.get(trigger);
            if (triggered == null) {
                triggered = new ArrayList();
                this.triggerIndex.put(trigger.clone(), triggered);
            }
            if (triggered.contains(qt)) continue;
            triggered.add(qt);
        }
        return t;
    }

    public abstract void finalizeTriggerables(FormInstance var1, EvaluationContext var2) throws IllegalStateException;

    public abstract Collection<QuickTriggerable> initializeTriggerables(FormInstance var1, EvaluationContext var2, TreeReference var3, boolean var4);

    public ValidateOutcome validate(FormEntryController formEntryControllerToBeValidated, boolean markCompleted) {
        int event;
        formEntryControllerToBeValidated.jumpToIndex(FormIndex.createBeginningOfFormIndex());
        while ((event = formEntryControllerToBeValidated.stepToNextEvent()) != 1) {
            if (event != 4) continue;
            FormIndex formControllerToBeValidatedFormIndex = formEntryControllerToBeValidated.getModel().getFormIndex();
            int saveStatus = formEntryControllerToBeValidated.answerQuestion(formControllerToBeValidatedFormIndex, formEntryControllerToBeValidated.getModel().getQuestionPrompt().getAnswerValue(), false);
            if (!markCompleted || saveStatus == 0) continue;
            ValidateOutcome vo = new ValidateOutcome(formControllerToBeValidatedFormIndex, saveStatus);
            return vo;
        }
        return null;
    }

    public abstract boolean shouldTrustPreviouslyCommittedAnswer();

    protected void publishSummary(String lead, Collection<QuickTriggerable> quickTriggerables) {
        this.publishSummary(lead, null, quickTriggerables);
    }

    protected final void publishSummary(String lead, TreeReference ref, Collection<QuickTriggerable> quickTriggerables) {
        this.accessor.getEventNotifier().publishEvent(new Event(lead + ": " + (ref != null ? ref.toShortString() + ": " : "") + quickTriggerables.size() + " triggerables were fired."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void printTriggerables(String path) {
        OutputStreamWriter w = null;
        try {
            w = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(path)), "UTF-8");
            for (int i = 0; i < this.triggerablesDAG.size(); ++i) {
                QuickTriggerable qt = this.triggerablesDAG.get(i);
                w.write(Integer.toString(i) + ": ");
                qt.t.print(w);
            }
        }
        catch (UnsupportedEncodingException e) {
            logger.error("Error", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            logger.error("Error", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("Error", (Throwable)e);
        }
        finally {
            if (w != null) {
                try {
                    w.flush();
                    w.close();
                }
                catch (IOException e) {
                    logger.error("Error", (Throwable)e);
                }
            }
        }
    }

    public final IConditionExpr getConditionExpressionForTrueAction(FormInstance mainInstance, TreeElement instanceNode, int action) {
        IConditionExpr expr = null;
        for (int i = 0; i < this.triggerablesDAG.size() && expr == null; ++i) {
            QuickTriggerable qt = this.triggerablesDAG.get(i);
            if (!(qt.t instanceof Condition)) continue;
            Condition c = (Condition)qt.t;
            if (c.trueAction != action) continue;
            List<TreeReference> targets = c.getTargets();
            for (int j = 0; j < targets.size() && expr == null; ++j) {
                TreeReference target = targets.get(j);
                TreeReference tr = (TreeReference)new XPathReference(target).getReference();
                TreeElement element = (TreeElement)mainInstance.getTemplatePath(tr);
                if (instanceNode != element) continue;
                expr = c.getExpr();
            }
        }
        return expr;
    }

    public final ArrayList<Condition> getConditions() {
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        for (QuickTriggerable qt : this.unorderedTriggerables) {
            if (!(qt.t instanceof Condition)) continue;
            conditions.add((Condition)qt.t);
        }
        return conditions;
    }

    public final ArrayList<Recalculate> getRecalculates() {
        ArrayList<Recalculate> recalculates = new ArrayList<Recalculate>();
        for (QuickTriggerable qt : this.unorderedTriggerables) {
            if (!(qt.t instanceof Recalculate)) continue;
            recalculates.add((Recalculate)qt.t);
        }
        return recalculates;
    }

    public final void reportDependencyCycles() {
        HashSet<TreeReference> vertices = new HashSet<TreeReference>();
        ArrayList<TreeReference[]> edges = new ArrayList<TreeReference[]>();
        ArrayList<TreeReference> targets = new ArrayList<TreeReference>();
        for (TreeReference trigger : this.triggerIndex.keySet()) {
            if (!vertices.contains(trigger)) {
                vertices.add(trigger);
            }
            ArrayList<QuickTriggerable> triggered = this.triggerIndex.get(trigger);
            targets.clear();
            for (QuickTriggerable qt : triggered) {
                Triggerable t = qt.t;
                for (int j = 0; j < t.getTargets().size(); ++j) {
                    TreeReference target = t.getTargets().get(j);
                    if (targets.contains(target)) continue;
                    targets.add(target);
                }
            }
            for (int i = 0; i < targets.size(); ++i) {
                TreeReference target = (TreeReference)targets.get(i);
                if (!vertices.contains(target)) {
                    vertices.add(target);
                }
                TreeReference[] edge = new TreeReference[]{trigger, target};
                edges.add(edge);
            }
        }
        boolean acyclic = true;
        HashSet<TreeReference> leaves = new HashSet<TreeReference>(vertices.size());
        while (vertices.size() > 0) {
            leaves.clear();
            leaves.addAll(vertices);
            for (int i = 0; i < edges.size(); ++i) {
                TreeReference[] edge = (TreeReference[])edges.get(i);
                leaves.remove(edge[0]);
            }
            if (leaves.size() == 0) {
                acyclic = false;
                break;
            }
            for (TreeReference leaf : leaves) {
                vertices.remove(leaf);
            }
            for (int i = edges.size() - 1; i >= 0; --i) {
                TreeReference[] edge = (TreeReference[])edges.get(i);
                if (!leaves.contains(edge[1])) continue;
                edges.remove(i);
            }
        }
        if (!acyclic) {
            StringBuilder b = new StringBuilder();
            b.append("XPath Dependency Cycle:\n");
            for (int i = 0; i < edges.size(); ++i) {
                TreeReference[] edge = (TreeReference[])edges.get(i);
                b.append(edge[0].toString()).append(" => ").append(edge[1].toString()).append("\n");
            }
            logger.error("XForm Parse Error: {}", (Object)b.toString());
            throw new RuntimeException("Dependency cycles amongst the xpath expressions in relevant/calculate");
        }
    }

    public static interface EventNotifierAccessor {
        public EventNotifier getEventNotifier();
    }
}

