/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model.actions.setgeopoint;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.javarosa.core.model.FormDef;
import org.javarosa.core.model.actions.Action;
import org.javarosa.core.model.condition.EvaluationContext;
import org.javarosa.core.model.condition.Recalculate;
import org.javarosa.core.model.data.AnswerDataFactory;
import org.javarosa.core.model.data.IAnswerData;
import org.javarosa.core.model.instance.AbstractTreeElement;
import org.javarosa.core.model.instance.TreeReference;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.ExtWrapNullable;
import org.javarosa.core.util.externalizable.PrototypeFactory;

public abstract class SetGeopointAction
extends Action {
    private TreeReference targetReference;
    private TreeReference contextualizedTargetReference;
    private FormDef formDef;

    public SetGeopointAction() {
    }

    public SetGeopointAction(TreeReference targetReference) {
        super("setgeopoint");
        this.setTargetReference(targetReference);
    }

    public TreeReference getTargetReference() {
        return this.targetReference;
    }

    public TreeReference getContextualizedTargetReference() {
        return this.contextualizedTargetReference;
    }

    public void setTargetReference(TreeReference targetReference) {
        this.targetReference = targetReference;
    }

    @Override
    public final TreeReference processAction(FormDef model, TreeReference contextRef) {
        this.formDef = model;
        this.contextualizedTargetReference = contextRef == null ? this.targetReference : this.targetReference.contextualize(contextRef);
        this.requestLocationUpdates();
        return this.contextualizedTargetReference;
    }

    public abstract void requestLocationUpdates();

    public final void saveLocationValue(String location) {
        EvaluationContext context = new EvaluationContext(this.formDef.getEvaluationContext(), this.contextualizedTargetReference);
        AbstractTreeElement node = context.resolveReference(this.contextualizedTargetReference);
        if (node != null) {
            int dataType = node.getDataType();
            IAnswerData val = Recalculate.wrapData(location, dataType);
            IAnswerData answer = val != null ? AnswerDataFactory.templateByDataType(dataType).cast(val.uncast()) : null;
            this.formDef.setValue(answer, this.contextualizedTargetReference, true);
        }
    }

    @Override
    public void readExternal(DataInputStream in, PrototypeFactory pf) throws IOException, DeserializationException {
        super.readExternal(in, pf);
        this.targetReference = (TreeReference)ExtUtil.read(in, new ExtWrapNullable(TreeReference.class), pf);
    }

    @Override
    public void writeExternal(DataOutputStream out) throws IOException {
        super.writeExternal(out);
        ExtUtil.write(out, new ExtWrapNullable(this.targetReference));
    }
}

