/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.reference;

import java.util.Arrays;
import org.javarosa.core.reference.InvalidReferenceException;
import org.javarosa.core.reference.Reference;
import org.javarosa.core.reference.ReferenceFactory;
import org.javarosa.core.reference.ReferenceManager;

public abstract class PrefixedRootFactory
implements ReferenceFactory {
    String[] roots;

    public PrefixedRootFactory(String[] roots) {
        this.roots = new String[roots.length];
        for (int i = 0; i < this.roots.length; ++i) {
            this.roots[i] = roots[i].contains("://") ? roots[i] : "jr://" + roots[i];
        }
    }

    @Override
    public Reference derive(String URI2) throws InvalidReferenceException {
        for (String root : this.roots) {
            if (!URI2.contains(root)) continue;
            return this.factory(URI2.substring(root.length()), URI2);
        }
        throw new InvalidReferenceException("Invalid attempt to derive a reference from a prefixed root. Valid prefixes for this factory are " + Arrays.toString(this.roots), URI2);
    }

    protected abstract Reference factory(String var1, String var2);

    @Override
    public Reference derive(String URI2, String context) throws InvalidReferenceException {
        String referenceURI = context.substring(0, context.lastIndexOf(47) + 1) + URI2;
        return ReferenceManager.instance().deriveReference(referenceURI);
    }

    @Override
    public boolean derives(String URI2) {
        for (String root : this.roots) {
            if (!URI2.contains(root)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "PrefixedRootFactory{roots=" + Arrays.toString(this.roots) + '}';
    }
}

