/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.util.externalizable;

import java.util.Date;
import java.util.List;
import java.util.Vector;
import org.javarosa.core.util.externalizable.CannotCreateObjectException;
import org.javarosa.core.util.externalizable.ExtWrapTagged;
import org.javarosa.xpath.expr.DigestAlgorithm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrototypeFactory {
    private static final Logger logger = LoggerFactory.getLogger(PrototypeFactory.class);
    public static final int CLASS_HASH_SIZE = 4;
    private final Vector<Class> classes = new Vector();
    private final Vector<byte[]> hashes = new Vector();
    private List<String> classNames;
    private boolean initialized;

    public PrototypeFactory() {
        this(null);
    }

    public PrototypeFactory(List<String> classNames) {
        this.classNames = classNames;
        this.initialized = false;
    }

    private void lazyInit() {
        this.initialized = true;
        this.addDefaultClasses();
        if (this.classNames != null) {
            for (String className : this.classNames) {
                try {
                    this.addClass(Class.forName(className));
                }
                catch (ClassNotFoundException cnfe) {
                    throw new CannotCreateObjectException(className + ": not found");
                }
            }
            this.classNames = null;
        }
    }

    private void addDefaultClasses() {
        Class[] baseTypes;
        for (Class baseType : baseTypes = new Class[]{Object.class, Integer.class, Long.class, Short.class, Byte.class, Character.class, Boolean.class, Float.class, Double.class, String.class, Date.class}) {
            this.addClass(baseType);
        }
    }

    public void addClass(Class c) {
        byte[] hash;
        if (!this.initialized) {
            this.lazyInit();
        }
        if (PrototypeFactory.compareHash(hash = PrototypeFactory.getClassHash(c), ExtWrapTagged.WRAPPER_TAG)) {
            throw new Error("Hash collision! " + c.getName() + " and reserved wrapper tag");
        }
        Class d = this.getClass(hash);
        if (d != null && d != c) {
            throw new Error("Hash collision! " + c.getName() + " and " + d.getName());
        }
        this.classes.addElement(c);
        this.hashes.addElement(hash);
    }

    public Class getClass(byte[] hash) {
        if (!this.initialized) {
            this.lazyInit();
        }
        for (int i = 0; i < this.classes.size(); ++i) {
            if (!PrototypeFactory.compareHash(hash, this.hashes.elementAt(i))) continue;
            return this.classes.elementAt(i);
        }
        return null;
    }

    public Object getInstance(byte[] hash) {
        return PrototypeFactory.getInstance(this.getClass(hash));
    }

    public static Object getInstance(Class c) {
        try {
            return c.newInstance();
        }
        catch (IllegalAccessException iae) {
            throw new CannotCreateObjectException(c.getName() + ": not accessible or no empty constructor");
        }
        catch (InstantiationException e) {
            throw new CannotCreateObjectException(c.getName() + ": not instantiable");
        }
    }

    public static byte[] getClassHash(Class type) {
        byte[] hash = new byte[4];
        byte[] md5 = DigestAlgorithm.MD5.digest(type.getName());
        System.arraycopy(md5, 0, hash, 0, hash.length);
        byte[] badHash = new byte[]{0, 4, 78, 97};
        if (PrototypeFactory.compareHash(badHash, hash)) {
            logger.info("BAD CLASS: {}", (Object)type.getName());
        }
        return hash;
    }

    public static boolean compareHash(byte[] a, byte[] b) {
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }
}

