/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.javarosa.core.log.WrappedException;
import org.javarosa.core.model.FormElementStateListener;
import org.javarosa.core.model.FormIndex;
import org.javarosa.core.model.GroupDef;
import org.javarosa.core.model.IDataReference;
import org.javarosa.core.model.IFormElement;
import org.javarosa.core.model.ItemsetBinding;
import org.javarosa.core.model.QuestionDef;
import org.javarosa.core.model.QuickTriggerable;
import org.javarosa.core.model.SelectChoice;
import org.javarosa.core.model.SubmissionProfile;
import org.javarosa.core.model.TriggerableDag;
import org.javarosa.core.model.ValidateOutcome;
import org.javarosa.core.model.XFormExtension;
import org.javarosa.core.model.actions.ActionController;
import org.javarosa.core.model.condition.Constraint;
import org.javarosa.core.model.condition.EvaluationContext;
import org.javarosa.core.model.condition.IConditionExpr;
import org.javarosa.core.model.condition.IFunctionHandler;
import org.javarosa.core.model.condition.Triggerable;
import org.javarosa.core.model.data.IAnswerData;
import org.javarosa.core.model.data.MultipleItemsData;
import org.javarosa.core.model.data.SelectOneData;
import org.javarosa.core.model.data.StringData;
import org.javarosa.core.model.data.helper.Selection;
import org.javarosa.core.model.instance.DataInstance;
import org.javarosa.core.model.instance.ExternalDataInstance;
import org.javarosa.core.model.instance.FormInstance;
import org.javarosa.core.model.instance.InstanceInitializationFactory;
import org.javarosa.core.model.instance.InvalidReferenceException;
import org.javarosa.core.model.instance.TreeElement;
import org.javarosa.core.model.instance.TreeReference;
import org.javarosa.core.model.util.restorable.RestoreUtils;
import org.javarosa.core.model.utils.QuestionPreloader;
import org.javarosa.core.services.locale.Localizable;
import org.javarosa.core.services.locale.Localizer;
import org.javarosa.core.services.storage.IMetaData;
import org.javarosa.core.services.storage.Persistable;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.ExtWrapListPoly;
import org.javarosa.core.util.externalizable.ExtWrapMap;
import org.javarosa.core.util.externalizable.ExtWrapNullable;
import org.javarosa.core.util.externalizable.ExtWrapTagged;
import org.javarosa.core.util.externalizable.ExternalizableWrapper;
import org.javarosa.core.util.externalizable.PrototypeFactory;
import org.javarosa.debug.EvaluationResult;
import org.javarosa.debug.Event;
import org.javarosa.debug.EventNotifier;
import org.javarosa.debug.EventNotifierSilent;
import org.javarosa.form.api.FormEntryController;
import org.javarosa.form.api.FormEntryModel;
import org.javarosa.model.xform.XPathReference;
import org.javarosa.xform.parse.XFormParseException;
import org.javarosa.xform.util.XFormAnswerDataSerializer;
import org.javarosa.xml.InternalDataInstanceParser;
import org.javarosa.xpath.XPathException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormDef
implements IFormElement,
Localizable,
Persistable,
IMetaData,
ActionController.ActionResultProcessor {
    private static final Logger logger = LoggerFactory.getLogger(FormDef.class);
    public static final String STORAGE_KEY = "FORMDEF";
    public static final int TEMPLATING_RECURSION_LIMIT = 10;
    private static EventNotifier defaultEventNotifier = new EventNotifierSilent();
    private List<IFormElement> children;
    private int id;
    private String title;
    private String formXmlPath;
    private String name;
    private List<XFormExtension> extensions;
    private Localizer localizer;
    private List<IConditionExpr> outputFragments;
    private TriggerableDag dagImpl;
    private EvaluationContext exprEvalContext;
    private QuestionPreloader preloader = new QuestionPreloader();
    private static String DEFAULT_SUBMISSION_PROFILE = "1";
    private HashMap<String, SubmissionProfile> submissionProfiles;
    private HashMap<String, DataInstance> formInstances;
    private FormInstance mainInstance = null;
    private ActionController actionController;
    private Set<String> actions;
    private Set<IFormElement> elementsWithActionTriggeredByToplevelEvent;
    private EventNotifier eventNotifier;
    private List<String> parseWarnings = new ArrayList<String>();
    private List<String> parseErrors = new ArrayList<String>();

    public static IDataReference getAbsRef(IDataReference ref, TreeReference parentRef) {
        if (!parentRef.isAbsolute()) {
            throw new RuntimeException("XFormParser.getAbsRef: parentRef must be absolute");
        }
        TreeReference tref = ref != null ? (TreeReference)ref.getReference() : TreeReference.selfRef();
        if ((tref = tref.anchor(parentRef)) == null) {
            throw new XFormParseException("Binding path [" + tref + "] not allowed with parent binding of [" + parentRef + "]");
        }
        return new XPathReference(tref);
    }

    public FormDef() {
        this(defaultEventNotifier);
    }

    public FormDef(EventNotifier eventNotifier) {
        this.setID(-1);
        this.setChildren(null);
        TriggerableDag.EventNotifierAccessor ia = new TriggerableDag.EventNotifierAccessor(){

            @Override
            public EventNotifier getEventNotifier() {
                return FormDef.this.getEventNotifier();
            }
        };
        this.dagImpl = new TriggerableDag(ia);
        this.resetEvaluationContext();
        this.outputFragments = new ArrayList<IConditionExpr>();
        this.submissionProfiles = new HashMap();
        this.formInstances = new HashMap();
        this.extensions = new ArrayList<XFormExtension>();
        this.actionController = new ActionController();
        this.actions = new HashSet<String>();
        this.elementsWithActionTriggeredByToplevelEvent = new HashSet<IFormElement>();
        this.eventNotifier = eventNotifier;
    }

    public EventNotifier getEventNotifier() {
        return this.eventNotifier;
    }

    public void setEventNotifier(EventNotifier eventNotifier) {
        this.eventNotifier = eventNotifier;
    }

    public void addNonMainInstance(DataInstance instance) {
        this.formInstances.put(instance.getName(), instance);
        this.resetEvaluationContext();
    }

    public void setFormXmlPath(String formXmlPath) {
        this.formXmlPath = formXmlPath;
    }

    public DataInstance getNonMainInstance(String name) {
        HashMap<String, DataInstance> formInstances = this.getFormInstances();
        if (!formInstances.containsKey(name)) {
            return null;
        }
        return formInstances.get(name);
    }

    public Enumeration<DataInstance> getNonMainInstances() {
        return Collections.enumeration(this.getFormInstances().values());
    }

    public void setInstance(FormInstance fi) {
        this.mainInstance = fi;
        fi.setFormId(this.getID());
        this.resetEvaluationContext();
        FormDef.updateItemsetReferences(this.getChildren());
        this.attachControlsToInstanceData();
    }

    public FormInstance getMainInstance() {
        return this.mainInstance;
    }

    public FormInstance getInstance() {
        return this.getMainInstance();
    }

    public void fireEvent() {
    }

    @Override
    public void addChild(IFormElement fe) {
        this.children.add(fe);
    }

    @Override
    public IFormElement getChild(int i) {
        if (i < this.children.size()) {
            return this.children.get(i);
        }
        throw new ArrayIndexOutOfBoundsException("FormDef: invalid child index: " + i + " only " + this.children.size() + " children");
    }

    public IFormElement getChild(FormIndex index) {
        IFormElement element = this;
        while (index != null && index.isInForm()) {
            element = element.getChild(index.getLocalIndex());
            index = index.getNextLevel();
        }
        return element;
    }

    public List<IFormElement> explodeIndex(FormIndex index) {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        ArrayList<Integer> multiplicities = new ArrayList<Integer>();
        ArrayList<IFormElement> elements = new ArrayList<IFormElement>();
        this.collapseIndex(index, indexes, multiplicities, elements);
        return elements;
    }

    public TreeReference getChildInstanceRef(FormIndex index) {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        ArrayList<Integer> multiplicities = new ArrayList<Integer>();
        ArrayList<IFormElement> elements = new ArrayList<IFormElement>();
        this.collapseIndex(index, indexes, multiplicities, elements);
        return this.getChildInstanceRef(elements, multiplicities);
    }

    public TreeReference getChildInstanceRef(List<IFormElement> elements, List<Integer> multiplicities) {
        int i;
        if (elements.size() == 0) {
            return null;
        }
        IFormElement element = elements.get(elements.size() - 1);
        TreeReference ref = FormInstance.unpackReference(element.getBind()).clone();
        for (i = 0; i < ref.size(); ++i) {
            if (ref.getMultiplicity(i) == -4) continue;
            ref.setMultiplicity(i, 0);
        }
        for (i = 0; i < elements.size(); ++i) {
            IFormElement temp = elements.get(i);
            if (!(temp instanceof GroupDef) || !((GroupDef)temp).getRepeat()) continue;
            TreeReference repRef = FormInstance.unpackReference(temp.getBind());
            if (repRef.isAncestorOf(ref, false)) {
                int repMult = multiplicities.get(i);
                ref.setMultiplicity(repRef.size() - 1, repMult);
                continue;
            }
            return null;
        }
        return ref;
    }

    public void setLocalizer(Localizer l) {
        if (this.localizer != null) {
            this.localizer.unregisterLocalizable(this);
        }
        this.localizer = l;
        if (this.localizer != null) {
            this.localizer.registerLocalizable(this);
        }
    }

    @Override
    public IDataReference getBind() {
        throw new RuntimeException("method not implemented");
    }

    public void setValue(IAnswerData data, TreeReference ref, boolean midSurvey) {
        this.setValue(data, ref, (TreeElement)this.mainInstance.resolveReference(ref), midSurvey);
    }

    public void setValue(IAnswerData data, TreeReference ref, TreeElement node, boolean midSurvey) {
        XFormAnswerDataSerializer answerDataSerializer = new XFormAnswerDataSerializer();
        IAnswerData oldValue = node.getValue();
        boolean valueChanged = !FormDef.objectEquals(answerDataSerializer.serializeAnswerData(oldValue), answerDataSerializer.serializeAnswerData(data));
        this.setAnswer(data, node);
        QuestionDef currentQuestion = FormDef.findQuestionByRef(ref, this);
        if (valueChanged && currentQuestion != null) {
            currentQuestion.getActionController().triggerActionsFromEvent("xforms-value-changed", this, ref.getParentRef(), null);
        }
        Collection<QuickTriggerable> qts = this.triggerTriggerables(ref);
        this.dagImpl.publishSummary("New value", ref, qts);
    }

    public static boolean objectEquals(Object object1, Object object2) {
        if (object1 == object2) {
            return true;
        }
        if (object1 == null || object2 == null) {
            return false;
        }
        return object1.equals(object2);
    }

    public void setAnswer(IAnswerData data, TreeReference ref) {
        this.setAnswer(data, (TreeElement)this.mainInstance.resolveReference(ref));
    }

    public void setAnswer(IAnswerData data, TreeElement node) {
        node.setAnswer(data);
    }

    public FormIndex deleteRepeat(FormIndex index) {
        IFormElement e;
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        ArrayList<Integer> multiplicities = new ArrayList<Integer>();
        ArrayList<IFormElement> elements = new ArrayList<IFormElement>();
        this.collapseIndex(index, indexes, multiplicities, elements);
        for (int i = elements.size() - 1; !(i < 0 || (e = (IFormElement)elements.get(i)) instanceof GroupDef && ((GroupDef)e).getRepeat()); --i) {
            indexes.remove(i);
            multiplicities.remove(i);
            elements.remove(i);
        }
        FormIndex newIndex = this.buildIndex(indexes, multiplicities, elements);
        TreeReference deleteRef = this.getChildInstanceRef(newIndex);
        TreeElement deleteElement = (TreeElement)this.mainInstance.resolveReference(deleteRef);
        TreeReference parentRef = deleteRef.getParentRef();
        TreeElement parentElement = (TreeElement)this.mainInstance.resolveReference(parentRef);
        int childMult = deleteElement.getMult();
        parentElement.removeChild(deleteElement);
        for (int i = 0; i < parentElement.getNumChildren(); ++i) {
            TreeElement child = parentElement.getChildAt(i);
            if (!child.getName().equals(deleteElement.getName()) || child.getMult() <= childMult) continue;
            child.setMult(child.getMult() - 1);
            child.clearChildrenCaches();
        }
        this.dagImpl.deleteRepeatInstance(this.getMainInstance(), this.getEvaluationContext(), deleteRef, deleteElement);
        return newIndex;
    }

    public void createNewRepeat(FormIndex index) throws InvalidReferenceException {
        TreeReference repeatContextRef = this.getChildInstanceRef(index);
        TreeElement template = (TreeElement)this.mainInstance.getTemplate(repeatContextRef);
        this.mainInstance.copyNode(template, repeatContextRef);
        TreeElement newNode = (TreeElement)this.mainInstance.resolveReference(repeatContextRef);
        this.preloadInstance(newNode);
        this.actionController.triggerActionsFromEvent("jr-insert", this, repeatContextRef, this);
        this.actionController.triggerActionsFromEvent("odk-new-repeat", this, repeatContextRef, this);
        this.getChild(index).getActionController().triggerActionsFromEvent("odk-new-repeat", this, repeatContextRef, this);
        this.dagImpl.createRepeatInstance(this.getMainInstance(), this.getEvaluationContext(), repeatContextRef, newNode);
    }

    @Override
    public void processResultOfAction(TreeReference refSetByAction, String event) {
        if ("jr-insert".equals(event)) {
            // empty if block
        }
    }

    public boolean isRepeatRelevant(TreeReference repeatRef) {
        TreeElement repeatNode = (TreeElement)this.mainInstance.resolveReference(repeatRef);
        return repeatNode == null || repeatNode.isRelevant();
    }

    public boolean canCreateRepeat(TreeReference repeatRef, FormIndex repeatIndex) {
        GroupDef repeat = (GroupDef)this.getChild(repeatIndex);
        if (repeat.noAddRemove) {
            if (repeat.getCountReference() != null) {
                long fullcount;
                int currentMultiplicity = repeatIndex.getElementMultiplicity();
                TreeReference countRef = FormInstance.unpackReference(repeat.getCountReference());
                TreeElement countNode = (TreeElement)this.getMainInstance().resolveReference(countRef.contextualize(repeatRef));
                if (countNode == null) {
                    throw new RuntimeException("Could not locate the repeat count value expected at " + repeat.getCountReference().getReference().toString());
                }
                IAnswerData count = countNode.getValue();
                long l = fullcount = count == null ? 0L : (long)((Integer)count.getValue()).intValue();
                if (fullcount <= (long)currentMultiplicity) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    public void copyItemsetAnswer(QuestionDef q, TreeElement targetNode, IAnswerData data) throws InvalidReferenceException {
        ArrayList<String> selectedValues;
        ItemsetBinding itemset = q.getDynamicChoices();
        TreeReference targetRef = targetNode.getRef();
        TreeReference destRef = itemset.getDestRef().contextualize(targetRef);
        ArrayList<Selection> selections = null;
        if (data instanceof MultipleItemsData) {
            selections = (ArrayList<Selection>)data.getValue();
        } else if (data instanceof SelectOneData) {
            selections = new ArrayList<Selection>(1);
            selections.add((Selection)data.getValue());
        }
        if (itemset.valueRef != null) {
            selectedValues = new ArrayList(selections.size());
            for (Selection selection : selections) {
                selectedValues.add(selection.choice.getValue());
            }
        } else {
            selectedValues = new ArrayList<String>(0);
        }
        HashMap<String, TreeElement> existingValues = new HashMap<String, TreeElement>();
        List<TreeReference> existingNodes = this.exprEvalContext.expandReference(destRef);
        for (TreeReference existingNode : existingNodes) {
            String value;
            TreeElement node = (TreeElement)this.getMainInstance().resolveReference(existingNode);
            if (itemset.valueRef != null && selectedValues.contains(value = itemset.getRelativeValue().evalReadable(this.getMainInstance(), new EvaluationContext(this.exprEvalContext, node.getRef())))) {
                existingValues.put(value, node);
            }
            targetNode.removeChild(node);
        }
        for (int i = 0; i < selections.size(); ++i) {
            String value;
            Selection s = (Selection)selections.get(i);
            SelectChoice ch = s.choice;
            TreeElement cachedNode = null;
            if (itemset.valueRef != null && existingValues.containsKey(value = ch.getValue())) {
                cachedNode = (TreeElement)existingValues.get(value);
            }
            if (cachedNode != null) {
                cachedNode.setMult(i);
                targetNode.addChild(cachedNode);
                continue;
            }
            this.getMainInstance().copyItemsetNode(ch.copyNode, destRef, this);
        }
        this.dagImpl.copyItemsetAnswer(this.getMainInstance(), this.getEvaluationContext(), destRef, targetNode);
    }

    public Triggerable addTriggerable(Triggerable t) {
        return this.dagImpl.addTriggerable(t);
    }

    public void reportDependencyCycles() {
        this.dagImpl.reportDependencyCycles();
    }

    public void finalizeTriggerables() throws IllegalStateException {
        this.dagImpl.finalizeTriggerables(this.getMainInstance(), this.getEvaluationContext());
    }

    private Collection<QuickTriggerable> initializeTriggerables(TreeReference rootRef) {
        return this.dagImpl.initializeTriggerables(this.getMainInstance(), this.getEvaluationContext(), rootRef);
    }

    public Collection<QuickTriggerable> triggerTriggerables(TreeReference ref) {
        return this.dagImpl.triggerTriggerables(this.getMainInstance(), this.getEvaluationContext(), ref);
    }

    public ValidateOutcome validate(boolean markCompleted) {
        FormEntryModel formEntryModelToBeValidated = new FormEntryModel(this);
        FormEntryController formEntryControllerToBeValidated = new FormEntryController(formEntryModelToBeValidated);
        return this.dagImpl.validate(formEntryControllerToBeValidated, markCompleted);
    }

    public boolean evaluateConstraint(TreeReference ref, IAnswerData data) {
        if (data == null) {
            return true;
        }
        TreeElement node = (TreeElement)this.mainInstance.resolveReference(ref);
        Constraint c = node.getConstraint();
        if (c == null) {
            return true;
        }
        EvaluationContext ec = new EvaluationContext(this.exprEvalContext, ref);
        ec.isConstraint = true;
        ec.candidateValue = data;
        boolean result = c.constraint.eval(this.mainInstance, ec);
        this.getEventNotifier().publishEvent(new Event("Constraint", new EvaluationResult(ref, result)));
        return result;
    }

    private void resetEvaluationContext() {
        EvaluationContext ec = new EvaluationContext(null);
        ec = new EvaluationContext(this.mainInstance, this.getFormInstances(), ec);
        this.initEvalContext(ec);
        this.exprEvalContext = ec;
    }

    public EvaluationContext getEvaluationContext() {
        return this.exprEvalContext;
    }

    private void initEvalContext(EvaluationContext ec) {
        FormDef f;
        if (!ec.getFunctionHandlers().containsKey("jr:itext")) {
            f = this;
            ec.addFunctionHandler(new IFunctionHandler(){

                @Override
                public String getName() {
                    return "jr:itext";
                }

                @Override
                public Object eval(Object[] args, EvaluationContext ec) {
                    String textID = (String)args[0];
                    try {
                        String form = ec.getOutputTextForm();
                        if (form != null) {
                            textID = textID + ";" + form;
                            String result = f.getLocalizer().getRawText(f.getLocalizer().getLocale(), textID);
                            return result == null ? "" : result;
                        }
                        String text = f.getLocalizer().getText(textID);
                        return text == null ? "[itext:" + textID + "]" : text;
                    }
                    catch (NoSuchElementException nsee) {
                        return "[nolocale]";
                    }
                }

                @Override
                public List<Class[]> getPrototypes() {
                    Class[] proto = new Class[]{String.class};
                    ArrayList<Class[]> v = new ArrayList<Class[]>(1);
                    v.add(proto);
                    return v;
                }

                @Override
                public boolean rawArgs() {
                    return false;
                }

                @Override
                public boolean realTime() {
                    return false;
                }
            });
        }
        if (!ec.getFunctionHandlers().containsKey("jr:choice-name")) {
            f = this;
            ec.addFunctionHandler(new IFunctionHandler(){

                @Override
                public String getName() {
                    return "jr:choice-name";
                }

                @Override
                public Object eval(Object[] args, EvaluationContext ec) {
                    try {
                        List<SelectChoice> choices;
                        String value = (String)args[0];
                        String questionXpath = (String)args[1];
                        TreeReference ref = RestoreUtils.xfFact.ref(questionXpath);
                        ref = ref.anchor(ec.getContextRef());
                        QuestionDef q = FormDef.findQuestionByRef(ref, f);
                        if (q == null || q.getControlType() != 2 && q.getControlType() != 3 && q.getControlType() != 16) {
                            return "";
                        }
                        ItemsetBinding itemset = q.getDynamicChoices();
                        if (itemset != null) {
                            if (itemset.getChoices() == null) {
                                if (ref.isAmbiguous()) {
                                    ref = ref.contextualize(ec.getContextRef());
                                }
                                f.populateDynamicChoices(itemset, ref);
                            }
                            choices = itemset.getChoices();
                        } else {
                            choices = q.getChoices();
                        }
                        if (choices != null) {
                            for (SelectChoice ch : choices) {
                                if (!ch.getValue().equals(value)) continue;
                                String textID = ch.getTextID();
                                String templateStr = textID != null ? f.getLocalizer().getText(textID) : ch.getLabelInnerText();
                                return FormDef.this.fillTemplateString(templateStr, ref);
                            }
                        }
                        return "";
                    }
                    catch (Exception e) {
                        throw new WrappedException("error in evaluation of xpath function [choice-name]", e);
                    }
                }

                @Override
                public List<Class[]> getPrototypes() {
                    Class[] proto = new Class[]{String.class, String.class};
                    ArrayList<Class[]> v = new ArrayList<Class[]>(1);
                    v.add(proto);
                    return v;
                }

                @Override
                public boolean rawArgs() {
                    return false;
                }

                @Override
                public boolean realTime() {
                    return false;
                }
            });
        }
    }

    public String fillTemplateString(String template, TreeReference contextRef) {
        return this.fillTemplateString(template, contextRef, new HashMap());
    }

    public String fillTemplateString(String template, TreeReference contextRef, HashMap<String, ?> variables) {
        HashMap<String, String> args = new HashMap<String, String>();
        int depth = 0;
        List<String> outstandingArgs = Localizer.getArgs(template);
        while (outstandingArgs.size() > 0) {
            for (String argName : outstandingArgs) {
                if (args.containsKey(argName)) continue;
                int ix = -1;
                try {
                    ix = Integer.parseInt(argName);
                }
                catch (NumberFormatException nfe) {
                    logger.warn("expect arguments to be numeric [{}]", (Object)argName);
                }
                if (ix < 0 || ix >= this.outputFragments.size()) continue;
                IConditionExpr expr = this.outputFragments.get(ix);
                EvaluationContext ec = new EvaluationContext(this.exprEvalContext, contextRef);
                ec.setOriginalContext(contextRef);
                ec.setVariables(variables);
                String value = expr.evalReadable(this.getMainInstance(), ec);
                args.put(argName, value);
            }
            template = Localizer.processArguments(template, args);
            outstandingArgs = Localizer.getArgs(template);
            if (++depth < 10) continue;
            throw new RuntimeException("Dependency cycle in <output>s; recursion limit exceeded!!");
        }
        return template;
    }

    public void populateDynamicChoices(ItemsetBinding itemset, TreeReference curQRef) {
        DataInstance formInstance;
        this.getEventNotifier().publishEvent(new Event("Dynamic choices", new EvaluationResult(curQRef, null)));
        ArrayList<SelectChoice> choices = new ArrayList<SelectChoice>();
        List<TreeReference> matches = itemset.nodesetExpr.evalNodeset(this.getMainInstance(), new EvaluationContext(this.exprEvalContext, itemset.contextRef.contextualize(curQRef)));
        if (itemset.nodesetRef.getInstanceName() != null) {
            formInstance = this.getNonMainInstance(itemset.nodesetRef.getInstanceName());
            if (formInstance == null) {
                throw new XPathException("Instance " + itemset.nodesetRef.getInstanceName() + " not found");
            }
        } else {
            formInstance = this.getMainInstance();
        }
        if (matches == null) {
            throw new XPathException("Could not find references depended on by" + itemset.nodesetRef.getInstanceName());
        }
        HashMap<String, Boolean> currentAnswersInNewChoices = null;
        IAnswerData rawValue = ((TreeElement)this.getMainInstance().resolveReference(curQRef)).getValue();
        if (rawValue != null) {
            currentAnswersInNewChoices = new HashMap<String, Boolean>();
            if (rawValue instanceof MultipleItemsData) {
                for (Selection selection : (List)rawValue.getValue()) {
                    currentAnswersInNewChoices.put(selection.choice != null ? selection.choice.getValue() : selection.xmlValue, false);
                }
            } else {
                currentAnswersInNewChoices.put(rawValue.getDisplayText(), false);
            }
        }
        for (int i = 0; i < matches.size(); ++i) {
            TreeReference item = matches.get(i);
            String label = itemset.labelExpr.evalReadable(formInstance, new EvaluationContext(this.exprEvalContext, item));
            String value = null;
            TreeElement copyNode = null;
            if (itemset.copyMode) {
                copyNode = (TreeElement)this.getMainInstance().resolveReference(itemset.copyRef.contextualize(item));
            }
            if (itemset.valueRef != null) {
                value = itemset.valueExpr.evalReadable(formInstance, new EvaluationContext(this.exprEvalContext, item));
            }
            String string = value = value != null ? value : "dynamic:" + i;
            if (currentAnswersInNewChoices != null && currentAnswersInNewChoices.keySet().contains(value)) {
                currentAnswersInNewChoices.put(value, true);
            }
            SelectChoice choice = new SelectChoice(label, value, itemset.labelIsItext);
            choice.setIndex(i);
            if (itemset.copyMode) {
                choice.copyNode = copyNode;
            }
            choices.add(choice);
        }
        if (choices.size() == 0) {
            logger.info("Dynamic select question has no choices! [{}]. If this occurs while filling out a form (and not while saving an incomplete form), the filter condition may have eliminated all the choices. Is that what you intended?", (Object)itemset.nodesetRef);
        }
        if (currentAnswersInNewChoices != null && currentAnswersInNewChoices.containsValue(false)) {
            IAnswerData filteredAnswer = rawValue instanceof MultipleItemsData ? FormDef.getFilteredSelections((MultipleItemsData)rawValue, currentAnswersInNewChoices) : new StringData("");
            ((TreeElement)this.getMainInstance().resolveReference(curQRef)).setAnswer(filteredAnswer);
        }
        itemset.clearChoices();
        itemset.setChoices(choices, this.getMainInstance(), this.exprEvalContext, this.getLocalizer());
    }

    private static MultipleItemsData getFilteredSelections(MultipleItemsData selections, Map<String, Boolean> shouldKeepSelection) {
        ArrayList<Selection> newSelections = new ArrayList<Selection>();
        for (Selection oldSelection : (List)selections.getValue()) {
            String key = oldSelection.choice != null ? oldSelection.choice.getValue() : oldSelection.xmlValue;
            if (!shouldKeepSelection.get(key).booleanValue()) continue;
            newSelections.add(oldSelection);
        }
        return new MultipleItemsData(newSelections);
    }

    public QuestionPreloader getPreloader() {
        return this.preloader;
    }

    public void setPreloader(QuestionPreloader preloads) {
        this.preloader = preloads;
    }

    @Override
    public void localeChanged(String locale, Localizer localizer) {
        for (IFormElement child : this.children) {
            child.localeChanged(locale, localizer);
        }
    }

    public String toString() {
        return this.getTitle();
    }

    public void preloadInstance(TreeElement node) {
        IAnswerData preload = null;
        if (node.getPreloadHandler() != null) {
            preload = this.preloader.getQuestionPreload(node.getPreloadHandler(), node.getPreloadParams());
        }
        if (preload != null) {
            node.setAnswer(preload);
        }
        if (!node.isLeaf()) {
            for (int i = 0; i < node.getNumChildren(); ++i) {
                TreeElement child = node.getChildAt(i);
                if (child.getMult() == -2) continue;
                this.preloadInstance(child);
            }
        }
    }

    public boolean postProcessInstance() {
        this.actionController.triggerActionsFromEvent("xforms-revalidate", this);
        return this.postProcessInstance(this.mainInstance.getRoot());
    }

    private boolean postProcessInstance(TreeElement node) {
        if (node.isLeaf()) {
            if (node.getPreloadHandler() != null) {
                return this.preloader.questionPostProcess(node, node.getPreloadHandler(), node.getPreloadParams());
            }
            return false;
        }
        boolean instanceModified = false;
        for (int i = 0; i < node.getNumChildren(); ++i) {
            TreeElement child = node.getChildAt(i);
            if (child.getMult() == -2) continue;
            instanceModified |= this.postProcessInstance(child);
        }
        return instanceModified;
    }

    @Override
    public void readExternal(DataInputStream dis, PrototypeFactory pf) throws IOException, DeserializationException {
        this.setID(ExtUtil.readInt(dis));
        this.setName(ExtUtil.nullIfEmpty(ExtUtil.readString(dis)));
        this.setTitle((String)ExtUtil.read(dis, new ExtWrapNullable(String.class), pf));
        this.setChildren((List)ExtUtil.read(dis, new ExtWrapListPoly(), pf));
        this.setFormXmlPath(ExtUtil.nullIfEmpty(ExtUtil.readString(dis)));
        this.setInstance((FormInstance)ExtUtil.read(dis, FormInstance.class, pf));
        this.mainInstance.getBase().setInstanceName(null);
        this.setLocalizer((Localizer)ExtUtil.read(dis, new ExtWrapNullable(Localizer.class), pf));
        for (Triggerable triggerable : TriggerableDag.readExternalTriggerables(dis, pf)) {
            this.addTriggerable(triggerable);
        }
        this.finalizeTriggerables();
        this.outputFragments = (List)ExtUtil.read(dis, new ExtWrapListPoly(), pf);
        this.submissionProfiles = (HashMap)ExtUtil.read(dis, new ExtWrapMap(String.class, SubmissionProfile.class));
        if (this.formXmlPath == null) {
            HashMap formInstances = (HashMap)ExtUtil.read(dis, new ExtWrapMap(String.class, (ExternalizableWrapper)new ExtWrapTagged()), pf);
            for (Map.Entry entry : formInstances.entrySet()) {
                this.addNonMainInstance((DataInstance)entry.getValue());
            }
        } else {
            HashMap externalFormInstances = (HashMap)ExtUtil.read(dis, new ExtWrapMap(String.class, (ExternalizableWrapper)new ExtWrapTagged()), pf);
            HashMap<String, DataInstance> hashMap = InternalDataInstanceParser.buildInstances(this.getFormXmlPath());
            this.formInstances.putAll(externalFormInstances);
            this.formInstances.putAll(hashMap);
        }
        this.extensions = (List)ExtUtil.read(dis, new ExtWrapListPoly(), pf);
        this.resetEvaluationContext();
        this.actionController = (ActionController)ExtUtil.read(dis, new ExtWrapNullable(ActionController.class), pf);
        this.actions = new HashSet<String>((List)ExtUtil.read(dis, new ExtWrapListPoly(), pf));
        List treeReferencesWithActions = (List)ExtUtil.read(dis, new ExtWrapListPoly(), pf);
        this.elementsWithActionTriggeredByToplevelEvent = this.getElementsFromReferences(treeReferencesWithActions);
    }

    private Set<IFormElement> getElementsFromReferences(Collection<TreeReference> references) {
        HashSet<TreeReference> referencesRemaining = new HashSet<TreeReference>();
        referencesRemaining.addAll(references);
        HashSet<IFormElement> elements = new HashSet<IFormElement>();
        FormDef.getElementsFromReferences(referencesRemaining, this, elements);
        return elements;
    }

    private static void getElementsFromReferences(Set<TreeReference> referencesRemaining, IFormElement fe, Set<IFormElement> elementsSoFar) {
        if (referencesRemaining.size() > 0 && fe.getChildren() != null) {
            for (IFormElement candidate : fe.getChildren()) {
                TreeReference candidateReference = FormInstance.unpackReference(candidate.getBind());
                for (TreeReference reference : referencesRemaining) {
                    if (!candidateReference.equals(reference)) continue;
                    elementsSoFar.add(candidate);
                    referencesRemaining.remove(candidate);
                }
                FormDef.getElementsFromReferences(referencesRemaining, candidate, elementsSoFar);
            }
        }
    }

    public void initialize(boolean newInstance, InstanceInitializationFactory factory) {
        HashMap<String, DataInstance> formInstances = this.getFormInstances();
        for (String instanceId : formInstances.keySet()) {
            DataInstance instance = formInstances.get(instanceId);
            instance.initialize(factory, instanceId);
        }
        if (newInstance) {
            this.preloadInstance(this.mainInstance.getRoot());
        }
        if (this.getLocalizer() != null && this.getLocalizer().getLocale() == null) {
            this.getLocalizer().setToDefault();
        }
        if (newInstance) {
            this.actionController.triggerActionsFromEvent("odk-instance-first-load", this);
            for (IFormElement element : this.elementsWithActionTriggeredByToplevelEvent) {
                element.getActionController().triggerActionsFromEvent("odk-instance-first-load", this, ((TreeReference)element.getBind().getReference()).getParentRef(), null);
            }
            this.actionController.triggerActionsFromEvent("xforms-ready", this);
        }
        Collection<QuickTriggerable> qts = this.initializeTriggerables(TreeReference.rootRef());
        this.dagImpl.publishSummary("Form initialized", null, qts);
    }

    @Override
    public void writeExternal(DataOutputStream dos) throws IOException {
        ExtUtil.writeNumeric(dos, this.getID());
        ExtUtil.writeString(dos, ExtUtil.emptyIfNull(this.getName()));
        ExtUtil.write(dos, new ExtWrapNullable(this.getTitle()));
        ExtUtil.write(dos, new ExtWrapListPoly(this.getChildren()));
        ExtUtil.writeString(dos, ExtUtil.emptyIfNull(this.getFormXmlPath()));
        ExtUtil.write(dos, this.getMainInstance());
        ExtUtil.write(dos, new ExtWrapNullable(this.localizer));
        this.dagImpl.writeExternalTriggerables(dos);
        ExtUtil.write(dos, new ExtWrapListPoly(this.outputFragments));
        ExtUtil.write(dos, new ExtWrapMap(this.submissionProfiles));
        if (this.formXmlPath == null) {
            ExtUtil.write(dos, new ExtWrapMap(this.getFormInstances(), (ExternalizableWrapper)new ExtWrapTagged()));
        } else {
            ExtUtil.write(dos, new ExtWrapMap(this.getExternalInstances(), (ExternalizableWrapper)new ExtWrapTagged()));
        }
        ExtUtil.write(dos, new ExtWrapListPoly(this.extensions));
        ExtUtil.write(dos, new ExtWrapNullable(this.actionController));
        ExtUtil.write(dos, new ExtWrapListPoly(new ArrayList<String>(this.actions)));
        ExtUtil.write(dos, new ExtWrapListPoly(FormDef.getReferencesFromElements(this.elementsWithActionTriggeredByToplevelEvent)));
    }

    private static List<TreeReference> getReferencesFromElements(Collection<IFormElement> elements) {
        ArrayList<TreeReference> references = new ArrayList<TreeReference>();
        for (IFormElement element : elements) {
            references.add(FormInstance.unpackReference(element.getBind()));
        }
        return references;
    }

    public void collapseIndex(FormIndex index, List<Integer> indexes, List<Integer> multiplicities, List<IFormElement> elements) {
        if (!index.isInForm()) {
            return;
        }
        IFormElement element = this;
        while (index != null) {
            int i = index.getLocalIndex();
            element = element.getChild(i);
            indexes.add(i);
            multiplicities.add(index.getInstanceIndex() == -1 ? 0 : index.getInstanceIndex());
            elements.add(element);
            index = index.getNextLevel();
        }
    }

    public FormIndex buildIndex(List<Integer> indexes, List<Integer> multiplicities, List<IFormElement> elements) {
        FormIndex cur = null;
        ArrayList<Integer> curMultiplicities = new ArrayList<Integer>();
        curMultiplicities.addAll(multiplicities);
        ArrayList<IFormElement> curElements = new ArrayList<IFormElement>();
        curElements.addAll(elements);
        for (int i = indexes.size() - 1; i >= 0; --i) {
            int ix = indexes.get(i);
            int mult = multiplicities.get(i);
            if (!(elements.get(i) instanceof GroupDef) || !((GroupDef)elements.get(i)).getRepeat()) {
                mult = -1;
            }
            cur = new FormIndex(cur, ix, mult, this.getChildInstanceRef(curElements, curMultiplicities));
            curMultiplicities.remove(curMultiplicities.size() - 1);
            curElements.remove(curElements.size() - 1);
        }
        return cur;
    }

    public int getNumRepetitions(FormIndex index) {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        ArrayList<Integer> multiplicities = new ArrayList<Integer>();
        ArrayList<IFormElement> elements = new ArrayList<IFormElement>();
        if (!index.isInForm()) {
            throw new RuntimeException("not an in-form index");
        }
        this.collapseIndex(index, indexes, multiplicities, elements);
        if (!(elements.get(elements.size() - 1) instanceof GroupDef) || !((GroupDef)elements.get(elements.size() - 1)).getRepeat()) {
            throw new RuntimeException("current element not a repeat");
        }
        TreeElement templNode = (TreeElement)this.mainInstance.getTemplate(index.getReference());
        TreeReference parentPath = templNode.getParent().getRef().genericize();
        TreeElement parentNode = (TreeElement)this.mainInstance.resolveReference(parentPath.contextualize(index.getReference()));
        return parentNode.getChildMultiplicity(templNode.getName());
    }

    public FormIndex descendIntoRepeat(FormIndex index, int repIndex) {
        int numRepetitions = this.getNumRepetitions(index);
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        ArrayList<Integer> multiplicities = new ArrayList<Integer>();
        ArrayList<IFormElement> elements = new ArrayList<IFormElement>();
        this.collapseIndex(index, indexes, multiplicities, elements);
        if (repIndex == -1) {
            repIndex = numRepetitions;
        } else if (repIndex < 0 || repIndex >= numRepetitions) {
            throw new RuntimeException("selection exceeds current number of repetitions");
        }
        multiplicities.set(multiplicities.size() - 1, repIndex);
        return this.buildIndex(indexes, multiplicities, elements);
    }

    @Override
    public int getDeepChildCount() {
        int total = 0;
        for (IFormElement child : this.children) {
            total += child.getDeepChildCount();
        }
        return total;
    }

    @Override
    public void registerStateObserver(FormElementStateListener qsl) {
    }

    @Override
    public void unregisterStateObserver(FormElementStateListener qsl) {
    }

    @Override
    public List<IFormElement> getChildren() {
        return this.children;
    }

    @Override
    public void setChildren(List<IFormElement> children) {
        this.children = children == null ? new ArrayList() : children;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public void setID(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Localizer getLocalizer() {
        return this.localizer;
    }

    public List<IConditionExpr> getOutputFragments() {
        return this.outputFragments;
    }

    public void setOutputFragments(List<IConditionExpr> outputFragments) {
        this.outputFragments = outputFragments;
    }

    @Override
    public HashMap<String, Object> getMetaData() {
        String[] fields;
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        for (String field : fields = this.getMetaDataFields()) {
            try {
                metadata.put(field, this.getMetaData(field));
            }
            catch (NullPointerException npe) {
                if (this.getMetaData(field) != null) continue;
                logger.error("ERROR! XFORM MUST HAVE A NAME!", (Throwable)npe);
            }
        }
        return metadata;
    }

    @Override
    public String getMetaData(String fieldName) {
        if (fieldName.equals("DESCRIPTOR")) {
            return this.name;
        }
        if (fieldName.equals("XMLNS")) {
            return ExtUtil.emptyIfNull(this.mainInstance.schema);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public String[] getMetaDataFields() {
        return new String[]{"DESCRIPTOR", "XMLNS"};
    }

    public static void updateItemsetReferences(List<IFormElement> children) {
        if (children != null) {
            for (IFormElement child : children) {
                if (child instanceof QuestionDef) {
                    QuestionDef q = (QuestionDef)child;
                    ItemsetBinding itemset = q.getDynamicChoices();
                    if (itemset == null) continue;
                    itemset.initReferences(q);
                    continue;
                }
                FormDef.updateItemsetReferences(child.getChildren());
            }
        }
    }

    public void attachControlsToInstanceData() {
        this.attachControlsToInstanceData(this.getMainInstance().getRoot());
    }

    private void attachControlsToInstanceData(TreeElement node) {
        for (int i = 0; i < node.getNumChildren(); ++i) {
            this.attachControlsToInstanceData(node.getChildAt(i));
        }
        IAnswerData val = node.getValue();
        List selections = null;
        if (val instanceof SelectOneData) {
            selections = new ArrayList<Selection>();
            selections.add((Selection)val.getValue());
        } else if (val instanceof MultipleItemsData) {
            selections = (List)val.getValue();
        }
        if (selections != null) {
            QuestionDef q = FormDef.findQuestionByRef(node.getRef(), this);
            if (q == null) {
                throw new RuntimeException("FormDef.attachControlsToInstanceData: can't find question to link");
            }
            if (q.getDynamicChoices() != null) {
                // empty if block
            }
            for (Selection s : selections) {
                s.attachChoice(q);
            }
        }
    }

    public static QuestionDef findQuestionByRef(TreeReference ref, IFormElement fe) {
        if (fe instanceof FormDef) {
            ref = ref.genericize();
        }
        if (fe instanceof QuestionDef) {
            QuestionDef q = (QuestionDef)fe;
            TreeReference bind = FormInstance.unpackReference(q.getBind());
            return ref.equals(bind) ? q : null;
        }
        for (int i = 0; i < fe.getChildren().size(); ++i) {
            QuestionDef ret = FormDef.findQuestionByRef(ref, fe.getChild(i));
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    @Override
    public String getAppearanceAttr() {
        throw new RuntimeException("This method call is not relevant for FormDefs getAppearanceAttr ()");
    }

    @Override
    public ActionController getActionController() {
        return this.actionController;
    }

    @Override
    public void setAppearanceAttr(String appearanceAttr) {
        throw new RuntimeException("This method call is not relevant for FormDefs setAppearanceAttr()");
    }

    @Override
    public String getLabelInnerText() {
        return null;
    }

    @Override
    public String getTextID() {
        return null;
    }

    @Override
    public void setTextID(String textID) {
        throw new RuntimeException("This method call is not relevant for FormDefs [setTextID()]");
    }

    public void setDefaultSubmission(SubmissionProfile profile) {
        this.submissionProfiles.put(DEFAULT_SUBMISSION_PROFILE, profile);
    }

    public void addSubmissionProfile(String submissionId, SubmissionProfile profile) {
        this.submissionProfiles.put(submissionId, profile);
    }

    public SubmissionProfile getSubmissionProfile() {
        return this.submissionProfiles.get(DEFAULT_SUBMISSION_PROFILE);
    }

    @Override
    public void setAdditionalAttribute(String namespace, String name, String value) {
    }

    @Override
    public String getAdditionalAttribute(String namespace, String name) {
        return null;
    }

    @Override
    public List<TreeElement> getAdditionalAttributes() {
        return Collections.emptyList();
    }

    public <X extends XFormExtension> X getExtension(Class<X> extension) {
        XFormExtension newEx;
        for (XFormExtension ex : this.extensions) {
            if (!ex.getClass().isAssignableFrom(extension)) continue;
            return (X)ex;
        }
        try {
            newEx = (XFormExtension)extension.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Illegally Structured XForm Extension " + extension.getName());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Illegally Structured XForm Extension " + extension.getName());
        }
        this.extensions.add(newEx);
        return (X)newEx;
    }

    public void seal() {
        this.dagImpl = null;
        this.exprEvalContext = null;
    }

    public void registerAction(String actionName) {
        this.actions.add(actionName);
    }

    public boolean hasAction(String name) {
        return this.actions.contains(name);
    }

    public void registerElementWithActionTriggeredByToplevelEvent(IFormElement element) {
        this.elementsWithActionTriggeredByToplevelEvent.add(element);
    }

    public List<String> getParseWarnings() {
        return this.parseWarnings;
    }

    public List<String> getParseErrors() {
        return this.parseErrors;
    }

    public void addParseWarning(String warning) {
        this.parseWarnings.add(warning);
    }

    public void addParseError(String error) {
        this.parseErrors.add(error);
    }

    private HashMap<String, DataInstance> getExternalInstances() {
        HashMap<String, DataInstance> externalFormInstances = new HashMap<String, DataInstance>();
        for (Map.Entry<String, DataInstance> formInstanceEntry : this.formInstances.entrySet()) {
            if (!(formInstanceEntry.getValue() instanceof ExternalDataInstance)) continue;
            externalFormInstances.put(formInstanceEntry.getKey(), formInstanceEntry.getValue());
        }
        return externalFormInstances;
    }

    private String getFormXmlPath() {
        return this.formXmlPath;
    }

    public HashMap<String, DataInstance> getFormInstances() {
        return this.formInstances;
    }
}

