/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.xform.parse;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.javarosa.core.model.DataBinding;
import org.javarosa.core.model.FormDef;
import org.javarosa.core.model.GroupDef;
import org.javarosa.core.model.IDataReference;
import org.javarosa.core.model.IFormElement;
import org.javarosa.core.model.ItemsetBinding;
import org.javarosa.core.model.QuestionDef;
import org.javarosa.core.model.RangeQuestion;
import org.javarosa.core.model.SelectChoice;
import org.javarosa.core.model.SubmissionProfile;
import org.javarosa.core.model.actions.Action;
import org.javarosa.core.model.actions.ActionController;
import org.javarosa.core.model.actions.SetValueAction;
import org.javarosa.core.model.actions.setgeopoint.StubSetGeopointActionHandler;
import org.javarosa.core.model.instance.DataInstance;
import org.javarosa.core.model.instance.ExternalDataInstance;
import org.javarosa.core.model.instance.FormInstance;
import org.javarosa.core.model.instance.TreeElement;
import org.javarosa.core.model.instance.TreeReference;
import org.javarosa.core.model.instance.utils.IAnswerResolver;
import org.javarosa.core.model.osm.OSMTag;
import org.javarosa.core.model.osm.OSMTagItem;
import org.javarosa.core.model.util.restorable.Restorable;
import org.javarosa.core.model.util.restorable.RestoreUtils;
import org.javarosa.core.reference.InvalidReferenceException;
import org.javarosa.core.services.ProgramFlow;
import org.javarosa.core.services.locale.Localizer;
import org.javarosa.core.services.locale.TableLocaleSource;
import org.javarosa.core.util.CacheTable;
import org.javarosa.core.util.StopWatch;
import org.javarosa.core.util.externalizable.PrototypeFactory;
import org.javarosa.model.xform.XPathReference;
import org.javarosa.xform.parse.ElementChildDeleter;
import org.javarosa.xform.parse.FormInstanceParser;
import org.javarosa.xform.parse.IElementHandler;
import org.javarosa.xform.parse.IXFormParserFunctions;
import org.javarosa.xform.parse.RandomizeHelper;
import org.javarosa.xform.parse.RangeParser;
import org.javarosa.xform.parse.StandardBindAttributesProcessor;
import org.javarosa.xform.parse.SubmissionParser;
import org.javarosa.xform.parse.TypeMappings;
import org.javarosa.xform.parse.XFormParseException;
import org.javarosa.xform.parse.XmlTextConsolidator;
import org.javarosa.xform.util.InterningKXmlParser;
import org.javarosa.xform.util.XFormAnswerDataParser;
import org.javarosa.xform.util.XFormSerializer;
import org.javarosa.xform.util.XFormUtils;
import org.javarosa.xml.util.InvalidStructureException;
import org.javarosa.xml.util.UnfullfilledRequirementsException;
import org.javarosa.xpath.XPathConditional;
import org.javarosa.xpath.XPathParseTool;
import org.javarosa.xpath.expr.XPathFuncExpr;
import org.javarosa.xpath.expr.XPathNumericLiteral;
import org.javarosa.xpath.expr.XPathPathExpr;
import org.javarosa.xpath.expr.XPathStringLiteral;
import org.javarosa.xpath.parser.XPathSyntaxException;
import org.kxml2.io.KXmlParser;
import org.kxml2.kdom.Document;
import org.kxml2.kdom.Element;
import org.kxml2.kdom.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class XFormParser
implements IXFormParserFunctions {
    private static final Logger logger = LoggerFactory.getLogger((String)XFormParser.class.getSimpleName());
    public static final String NAMESPACE_JAVAROSA = "http://openrosa.org/javarosa";
    public static final String NAMESPACE_ODK = "http://www.opendatakit.org/xforms";
    private static final String FORM_ATTR = "form";
    private static final String APPEARANCE_ATTR = "appearance";
    private static final String LABEL_ELEMENT = "label";
    private static final String VALUE = "value";
    public static final String ITEXT_CLOSE = "')";
    public static final String ITEXT_OPEN = "jr:itext('";
    private static final String DYNAMIC_ITEXT_CLOSE = ")";
    private static final String DYNAMIC_ITEXT_OPEN = "jr:itext(";
    private static final String BIND_ATTR = "bind";
    private static final String REF_ATTR = "ref";
    public static final String EVENT_ATTR = "event";
    private static final String NAMESPACE_HTML = "http://www.w3.org/1999/xhtml";
    private static final int CONTAINER_GROUP = 1;
    private static final int CONTAINER_REPEAT = 2;
    private static HashMap<String, IElementHandler> topLevelHandlers;
    private static HashMap<String, IElementHandler> groupLevelHandlers;
    private static final Map<String, Integer> typeMappings;
    private static List<SubmissionParser> submissionParsers;
    private Reader _reader;
    private Document _xmldoc;
    private FormDef _f;
    private Reader _instReader;
    private Document _instDoc;
    private boolean modelFound;
    private Localizer localizer;
    private HashMap<String, DataBinding> bindingsByID;
    private List<DataBinding> bindings;
    private List<TreeReference> actionTargets;
    private List<TreeReference> repeats;
    private List<ItemsetBinding> itemsets;
    private List<TreeReference> selectOnes;
    private List<TreeReference> multipleItems;
    private Element mainInstanceNode;
    private List<Element> instanceNodes;
    private List<String> instanceNodeIdStrs;
    private List<String> itextKnownForms;
    private static HashMap<String, IElementHandler> actionHandlers;
    private static Set<String> referencedInstanceIds;
    private final List<WarningCallback> warningCallbacks = new ArrayList<WarningCallback>();
    private final List<ErrorCallback> errorCallbacks = new ArrayList<ErrorCallback>();
    private int serialQuestionID = 1;
    private static IAnswerResolver answerResolver;
    CacheTable<String> stringCache;
    private final Set<String> validElementNames = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("html", "head", "body", "xform", "chooseCaption", "addCaption", "addEmptyCaption", "delCaption", "doneCaption", "doneEmptyCaption", "mainHeader", "entryHeader", "delHeader")));
    private final List<String> usedAtts = Collections.unmodifiableList(Arrays.asList("id", "nodeset", "type", "relevant", "required", "readonly", "constraint", "constraintMsg", "calculate", "preload", "preloadParams", "requiredMsg", "saveIncomplete"));
    private final List<String> passedThroughAtts = Collections.unmodifiableList(Arrays.asList("requiredMsg", "saveIncomplete"));

    public static IAnswerResolver getAnswerResolver() {
        return answerResolver;
    }

    public static void setAnswerResolver(IAnswerResolver answerResolver) {
        XFormParser.answerResolver = answerResolver;
    }

    private static void staticInit() {
        XFormParser.initProcessingRules();
        submissionParsers = new ArrayList<SubmissionParser>(1);
        referencedInstanceIds = new HashSet<String>();
    }

    private static void initProcessingRules() {
        groupLevelHandlers = new HashMap<String, IElementHandler>(){
            {
                this.put("input", new IElementHandler(){

                    @Override
                    public void handle(XFormParser p, Element e, Object parent) {
                        List<String> passedThroughInputAtts = Collections.unmodifiableList(Arrays.asList("rows", "query"));
                        p.parseControl((IFormElement)parent, e, 1, passedThroughInputAtts, passedThroughInputAtts);
                    }
                });
                this.put("range", new IElementHandler(){

                    @Override
                    public void handle(XFormParser p, Element e, Object parent) {
                        p.parseControl((IFormElement)parent, e, 6, Arrays.asList("start", "end", "step"));
                    }
                });
                this.put("secret", new IElementHandler(){

                    @Override
                    public void handle(XFormParser p, Element e, Object parent) {
                        p.parseControl((IFormElement)parent, e, 5);
                    }
                });
                this.put("select", new IElementHandler(){

                    @Override
                    public void handle(XFormParser p, Element e, Object parent) {
                        p.parseControl((IFormElement)parent, e, 3);
                    }
                });
                this.put("rank", new IElementHandler(){

                    @Override
                    public void handle(XFormParser p, Element e, Object parent) {
                        p.parseControl((IFormElement)parent, e, 16);
                    }
                });
                this.put("select1", new IElementHandler(){

                    @Override
                    public void handle(XFormParser p, Element e, Object parent) {
                        p.parseControl((IFormElement)parent, e, 2);
                    }
                });
                this.put("group", new IElementHandler(){

                    @Override
                    public void handle(XFormParser p, Element e, Object parent) {
                        p.parseGroup((IFormElement)parent, e, 1);
                    }
                });
                this.put("repeat", new IElementHandler(){

                    @Override
                    public void handle(XFormParser p, Element e, Object parent) {
                        p.parseGroup((IFormElement)parent, e, 2);
                    }
                });
                this.put("trigger", new IElementHandler(){

                    @Override
                    public void handle(XFormParser p, Element e, Object parent) {
                        p.parseControl((IFormElement)parent, e, 9);
                    }
                });
                this.put("upload", new IElementHandler(){

                    @Override
                    public void handle(XFormParser p, Element e, Object parent) {
                        p.parseUpload((IFormElement)parent, e, 7);
                    }
                });
                this.put(XFormParser.LABEL_ELEMENT, new IElementHandler(){

                    @Override
                    public void handle(XFormParser p, Element e, Object parent) {
                        if (!(parent instanceof GroupDef)) {
                            throw new XFormParseException("parent of element is not a group", e);
                        }
                        p.parseGroupLabel((GroupDef)parent, e);
                    }
                });
            }
        };
        topLevelHandlers = new HashMap<String, IElementHandler>(){
            {
                this.put("model", new IElementHandler(){

                    @Override
                    public void handle(XFormParser p, Element e, Object parent) {
                        p.parseModel(e);
                    }
                });
                this.put("title", new IElementHandler(){

                    @Override
                    public void handle(XFormParser p, Element e, Object parent) {
                        p.parseTitle(e);
                    }
                });
                this.put("meta", new IElementHandler(){

                    @Override
                    public void handle(XFormParser p, Element e, Object parent) {
                        p.parseMeta(e);
                    }
                });
            }
        };
        topLevelHandlers.putAll(groupLevelHandlers);
        XFormParser.setUpActionHandlers();
    }

    private static void setUpActionHandlers() {
        actionHandlers = new HashMap();
        XFormParser.registerActionHandler("setvalue", SetValueAction.getHandler());
        XFormParser.registerActionHandler("setgeopoint", new StubSetGeopointActionHandler());
    }

    private void initState() {
        this.modelFound = false;
        this.bindingsByID = new HashMap();
        this.bindings = new ArrayList<DataBinding>();
        this.actionTargets = new ArrayList<TreeReference>();
        this.repeats = new ArrayList<TreeReference>();
        this.itemsets = new ArrayList<ItemsetBinding>();
        this.selectOnes = new ArrayList<TreeReference>();
        this.multipleItems = new ArrayList<TreeReference>();
        this.mainInstanceNode = null;
        this.instanceNodes = new ArrayList<Element>();
        this.instanceNodeIdStrs = new ArrayList<String>();
        this.itextKnownForms = new ArrayList<String>(4);
        this.itextKnownForms.add("long");
        this.itextKnownForms.add("short");
        this.itextKnownForms.add("image");
        this.itextKnownForms.add("audio");
    }

    public XFormParser(Reader reader) {
        this._reader = reader;
    }

    public XFormParser(Document doc) {
        this._xmldoc = doc;
    }

    public XFormParser(Reader form, Reader instance) {
        this._reader = form;
        this._instReader = instance;
    }

    public XFormParser(Document form, Document instance) {
        this._xmldoc = form;
        this._instDoc = instance;
    }

    public FormDef parse(String lastSavedSrc) throws IOException {
        return this.parse(null, lastSavedSrc);
    }

    public FormDef parse() throws IOException {
        return this.parse(null, null);
    }

    public FormDef parse(String formXmlSrc, String lastSavedSrc) throws IOException {
        if (this._f == null) {
            logger.info("Parsing form...");
            if (this._xmldoc == null) {
                this._xmldoc = XFormParser.getXMLDocument(this._reader, this.stringCache);
            }
            this.parseDoc(formXmlSrc, XFormParser.buildNamespacesMap(this._xmldoc.getRootElement()), lastSavedSrc);
            if (this._instReader != null) {
                this.loadXmlInstance(this._f, this._instReader);
            } else if (this._instDoc != null) {
                XFormParser.loadXmlInstance(this._f, this._instDoc);
            }
        }
        return this._f;
    }

    private static Map<String, String> buildNamespacesMap(Element el) {
        HashMap<String, String> namespacePrefixesByURI = new HashMap<String, String>();
        for (int i = 0; i < el.getNamespaceCount(); ++i) {
            namespacePrefixesByURI.put(el.getNamespaceUri(i), el.getNamespacePrefix(i));
        }
        return namespacePrefixesByURI;
    }

    public static Document getXMLDocument(Reader reader) throws IOException {
        return XFormParser.getXMLDocument(reader, null);
    }

    @Deprecated
    public static Document getXMLDocument(Reader reader, CacheTable<String> stringCache) throws IOException {
        StopWatch ctParse = StopWatch.start();
        Document doc = new Document();
        try {
            KXmlParser parser = stringCache != null ? new InterningKXmlParser(stringCache) : new KXmlParser();
            parser.setInput(reader);
            parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            doc.parse((XmlPullParser)parser);
        }
        catch (XmlPullParserException e) {
            String errorMsg = "XML Syntax Error at Line: " + e.getLineNumber() + ", Column: " + e.getColumnNumber() + "!";
            logger.error(errorMsg, (Throwable)e);
            throw new XFormParseException(errorMsg);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("Unhandled Exception while Parsing XForm", (Throwable)e);
            throw new XFormParseException("Unhandled Exception while Parsing XForm");
        }
        try {
            reader.close();
        }
        catch (IOException e) {
            logger.error("Error closing reader", (Throwable)e);
        }
        logger.info(ctParse.logLine("Reading XML and parsing with kXML2"));
        StopWatch ctConsolidate = StopWatch.start();
        XmlTextConsolidator.consolidateText(stringCache, doc.getRootElement());
        logger.info(ctConsolidate.logLine("Consolidating text"));
        return doc;
    }

    private void parseDoc(String formXmlSrc, Map<String, String> namespacePrefixesByUri, String lastSavedSrc) {
        Object instance;
        StopWatch codeTimer = StopWatch.start();
        this._f = new FormDef();
        this._f.setFormXmlPath(formXmlSrc);
        this.initState();
        String defaultNamespace = this._xmldoc.getRootElement().getNamespaceUri(null);
        referencedInstanceIds.clear();
        this.parseElement(this._xmldoc.getRootElement(), this._f, topLevelHandlers);
        XFormParser.collapseRepeatGroups(this._f);
        FormInstanceParser instanceParser = new FormInstanceParser(this._f, defaultNamespace, this.bindings, this.repeats, this.itemsets, this.selectOnes, this.multipleItems, this.actionTargets);
        if (this.instanceNodes.size() > 1) {
            for (int instanceIndex = 1; instanceIndex < this.instanceNodes.size(); ++instanceIndex) {
                instance = this.instanceNodes.get(instanceIndex);
                String instanceId = this.instanceNodeIdStrs.get(instanceIndex);
                String instanceSrc = this.parseInstanceSrc((Element)instance, lastSavedSrc);
                if (!referencedInstanceIds.contains(instanceId)) continue;
                if (instanceSrc != null) {
                    ExternalDataInstance externalDataInstance;
                    try {
                        externalDataInstance = ExternalDataInstance.build(instanceSrc, instanceId);
                    }
                    catch (IOException | InvalidReferenceException | InvalidStructureException | UnfullfilledRequirementsException | XmlPullParserException e) {
                        String msg = "Unable to parse external secondary instance";
                        logger.error(msg, e);
                        throw new XFormParseException(msg + ": " + e.toString(), (Element)instance);
                    }
                    this._f.addNonMainInstance(externalDataInstance);
                    continue;
                }
                FormInstance fi = instanceParser.parseInstance((Element)instance, false, this.instanceNodeIdStrs.get(this.instanceNodes.indexOf(instance)), namespacePrefixesByUri);
                XFormParser.loadNamespaces(this._xmldoc.getRootElement(), fi);
                XFormParser.loadInstanceData((Element)instance, fi.getRoot(), this._f);
                this._f.addNonMainInstance(fi);
            }
        }
        if (this.mainInstanceNode != null) {
            FormInstance fi = instanceParser.parseInstance(this.mainInstanceNode, true, this.instanceNodeIdStrs.get(this.instanceNodes.indexOf(this.mainInstanceNode)), namespacePrefixesByUri);
            XFormParser.loadNamespaces(this._xmldoc.getRootElement(), fi);
            this.addMainInstanceToFormDef(this.mainInstanceNode, fi);
        }
        Enumeration<DataInstance> e = this._f.getNonMainInstances();
        while (e.hasMoreElements()) {
            instance = e.nextElement();
            Object treeElement = ((DataInstance)instance).getRoot();
            if (treeElement instanceof TreeElement) {
                ((TreeElement)treeElement).clearChildrenCaches();
            }
            treeElement.clearCaches();
        }
        this._f.getMainInstance().getRoot().clearChildrenCaches();
        this._f.getMainInstance().getRoot().clearCaches();
        logger.info(codeTimer.logLine("Creating FormDef from parsed XML"));
    }

    private String parseInstanceSrc(Element instance, String lastSavedSrc) {
        String rawSrcLower;
        String rawSrc = instance.getAttributeValue(null, "src");
        String string = rawSrcLower = rawSrc == null ? null : rawSrc.toLowerCase();
        if (rawSrc == null) {
            return null;
        }
        if (rawSrcLower.startsWith("jr://file/") || rawSrcLower.startsWith("jr://file-csv/")) {
            return rawSrc;
        }
        if (rawSrcLower.equals("jr://instance/last-saved")) {
            return lastSavedSrc;
        }
        logger.warn("Invalid instance `src`: " + rawSrc);
        return null;
    }

    private void parseElement(Element e, Object parent, HashMap<String, IElementHandler> handlers) {
        String name = e.getName();
        IElementHandler eh = handlers.get(name);
        if (eh != null) {
            eh.handle(this, e, parent);
        } else {
            if (!this.validElementNames.contains(name)) {
                this.triggerWarning("Unrecognized element [" + name + "]. Ignoring and processing children...", XFormParser.getVagueLocation(e));
            }
            for (int i = 0; i < e.getChildCount(); ++i) {
                if (e.getType(i) != 2) continue;
                this.parseElement(e.getElement(i), parent, handlers);
            }
        }
    }

    public static void recordInstanceFunctionCall(String instanceId) {
        referencedInstanceIds.add(instanceId);
    }

    private void parseTitle(Element e) {
        ArrayList<String> usedAtts = new ArrayList<String>();
        String title = XFormParser.getXMLText((Node)e, true);
        logger.info("Title: \"" + title + "\"");
        this._f.setTitle(title);
        if (this._f.getName() == null) {
            this._f.setName(title);
        }
        if (XFormUtils.showUnusedAttributeWarning(e, usedAtts)) {
            this.triggerWarning(XFormUtils.unusedAttWarning(e, usedAtts), XFormParser.getVagueLocation(e));
        }
    }

    private void parseMeta(Element e) {
        ArrayList<String> usedAtts = new ArrayList<String>();
        int attributes = e.getAttributeCount();
        for (int i = 0; i < attributes; ++i) {
            String name = e.getAttributeName(i);
            String value = e.getAttributeValue(i);
            if (!"name".equals(name)) continue;
            this._f.setName(value);
        }
        usedAtts.add("name");
        if (XFormUtils.showUnusedAttributeWarning(e, usedAtts)) {
            this.triggerWarning(XFormUtils.unusedAttWarning(e, usedAtts), XFormParser.getVagueLocation(e));
        }
    }

    private void parseModel(Element e) {
        ArrayList<String> usedAtts = new ArrayList<String>();
        ArrayList<Element> delayedParseElements = new ArrayList<Element>();
        if (this.modelFound) {
            this.triggerWarning("Multiple models not supported. Ignoring subsequent models.", XFormParser.getVagueLocation(e));
            return;
        }
        this.modelFound = true;
        if (XFormUtils.showUnusedAttributeWarning(e, usedAtts)) {
            this.triggerWarning(XFormUtils.unusedAttWarning(e, usedAtts), XFormParser.getVagueLocation(e));
        }
        for (int i = 0; i < e.getChildCount(); ++i) {
            String childName;
            int type = e.getType(i);
            Element child = type == 2 ? e.getElement(i) : null;
            String string = childName = child != null ? child.getName() : null;
            if ("itext".equals(childName)) {
                this.parseIText(child);
            } else if ("instance".equals(childName)) {
                this.saveInstanceNode(child);
            } else if (BIND_ATTR.equals(childName)) {
                this.parseBind(child);
            } else if ("submission".equals(childName)) {
                delayedParseElements.add(child);
            } else if (childName != null && actionHandlers.containsKey(childName)) {
                delayedParseElements.add(child);
            } else {
                if (type == 2) {
                    throw new XFormParseException("Unrecognized top-level tag [" + childName + "] found within <model>", child);
                }
                if (type == 4 && XFormParser.getXMLText((Node)e, i, true).length() != 0) {
                    throw new XFormParseException("Unrecognized text content found within <model>: \"" + XFormParser.getXMLText((Node)e, i, true) + "\"", child == null ? e : child);
                }
            }
            if (child != null && !BIND_ATTR.equals(childName) && !"itext".equals(childName)) continue;
            e.removeChild(i);
            --i;
        }
        for (Element child : delayedParseElements) {
            String name = child.getName();
            if (name.equals("submission")) {
                this.parseSubmission(child);
                continue;
            }
            if (actionHandlers.containsKey(name) && child.getAttributeValue(null, EVENT_ATTR).equals("odk-new-repeat")) {
                throw new XFormParseException("Actions triggered by odk-new-repeat must be nested in the repeat form control.", child);
            }
            actionHandlers.get(name).handle(this, child, this._f);
        }
    }

    private void parseAction(Element e, Object parent, IElementHandler specificHandler) {
        List<String> validEvents = XFormParser.getValidEventNames(e.getAttributeValue(null, EVENT_ATTR));
        for (String event : validEvents) {
            if (!(parent instanceof IFormElement)) {
                throw new XFormParseException("An action element occurred in an invalid location. Must be either a child of a control element, or a child of the <model>");
            }
            if (parent.equals(this._f) || !event.equals("odk-instance-first-load")) continue;
            this._f.registerElementWithActionTriggeredByToplevelEvent((IFormElement)parent);
        }
        this._f.registerAction(e.getName());
        specificHandler.handle(this, e, parent);
    }

    public static List<String> getValidEventNames(String eventsString) {
        ArrayList<String> validEvents = new ArrayList<String>();
        ArrayList<String> invalidEventList = new ArrayList<String>();
        for (String event : eventsString.split(" ")) {
            if (Action.isValidEvent(event)) {
                validEvents.add(event);
                continue;
            }
            invalidEventList.add(event);
        }
        if (!invalidEventList.isEmpty()) {
            throw new XFormParseException("An action was registered for unsupported events: " + XPathFuncExpr.join(", ", invalidEventList.toArray()));
        }
        return validEvents;
    }

    public void parseSetValueAction(ActionController source, Element e) {
        SetValueAction action;
        IDataReference dataRef;
        String ref = e.getAttributeValue(null, REF_ATTR);
        String bind = e.getAttributeValue(null, BIND_ATTR);
        boolean refFromBind = false;
        if (bind != null) {
            DataBinding binding = this.bindingsByID.get(bind);
            if (binding == null) {
                throw new XFormParseException("XForm Parse: invalid binding ID in submit'" + bind + "'", e);
            }
            dataRef = binding.getReference();
            refFromBind = true;
        } else if (ref != null) {
            dataRef = new XPathReference(ref);
        } else {
            throw new XFormParseException("setvalue action with no target!", e);
        }
        if (dataRef != null && !refFromBind) {
            dataRef = FormDef.getAbsRef(dataRef, TreeReference.rootRef());
        }
        String valueExpression = e.getAttributeValue(null, VALUE);
        TreeReference treeref = FormInstance.unpackReference(dataRef);
        this.registerActionTarget(treeref);
        if (valueExpression == null) {
            if (e.getChildCount() == 0 || !e.isText(0)) {
                throw new XFormParseException("No 'value' attribute and no inner value set in <setvalue> associated with: " + treeref, e);
            }
            action = new SetValueAction(treeref, e.getText(0));
        } else {
            try {
                action = new SetValueAction(treeref, valueExpression.equals("") ? new XPathStringLiteral("") : XPathParseTool.parseXPath(valueExpression));
            }
            catch (XPathSyntaxException e1) {
                logger.error("Error", (Throwable)e1);
                throw new XFormParseException("Invalid XPath in value set action declaration: '" + valueExpression + "'", e);
            }
        }
        source.registerEventListener(XFormParser.getValidEventNames(e.getAttributeValue(null, EVENT_ATTR)), (Action)action);
    }

    private void parseSubmission(Element submission) {
        String id = submission.getAttributeValue(null, "id");
        String method = submission.getAttributeValue(null, "method");
        String action = submission.getAttributeValue(null, "action");
        SubmissionParser parser = new SubmissionParser();
        for (SubmissionParser p : submissionParsers) {
            if (!p.matchesCustomMethod(method)) continue;
            parser = p;
        }
        String ref = submission.getAttributeValue(null, REF_ATTR);
        String bind = submission.getAttributeValue(null, BIND_ATTR);
        IDataReference dataRef = null;
        boolean refFromBind = false;
        if (bind != null) {
            DataBinding binding = this.bindingsByID.get(bind);
            if (binding == null) {
                throw new XFormParseException("XForm Parse: invalid binding ID in submit'" + bind + "'", submission);
            }
            dataRef = binding.getReference();
            refFromBind = true;
        } else {
            dataRef = ref != null ? new XPathReference(ref) : new XPathReference("/");
        }
        if (dataRef != null && !refFromBind) {
            dataRef = FormDef.getAbsRef(dataRef, TreeReference.rootRef());
        }
        SubmissionProfile profile = parser.parseSubmission(method, action, dataRef, submission);
        if (id == null) {
            this._f.setDefaultSubmission(profile);
        } else {
            this._f.addSubmissionProfile(id, profile);
        }
    }

    private void saveInstanceNode(Element instance) {
        Element instanceNode = null;
        String instanceId = instance.getAttributeValue("", "id");
        String instanceSrc = instance.getAttributeValue("", "src");
        if (instanceSrc == null) {
            for (int i = 0; i < instance.getChildCount(); ++i) {
                if (instance.getType(i) != 2) continue;
                if (instanceNode != null) {
                    throw new XFormParseException("XForm Parse: <instance> has more than one child element", instance);
                }
                instanceNode = instance.getElement(i);
            }
        }
        if (instanceNode == null) {
            instanceNode = instance;
        }
        if (this.mainInstanceNode == null) {
            this.mainInstanceNode = instanceNode;
        }
        this.instanceNodes.add(instanceNode);
        this.instanceNodeIdStrs.add(instanceId);
    }

    private void processAdditionalAttributes(QuestionDef question, Element e, List<String> usedAtts, List<String> passedThroughAtts) {
        for (int i = 0; i < e.getAttributeCount(); ++i) {
            String name = e.getAttributeName(i);
            if (usedAtts.contains(name) && (passedThroughAtts == null || !passedThroughAtts.contains(name))) continue;
            question.setAdditionalAttribute(e.getAttributeNamespace(i), name, e.getAttributeValue(i));
        }
        if (XFormUtils.showUnusedAttributeWarning(e, usedAtts)) {
            this.triggerWarning(XFormUtils.unusedAttWarning(e, usedAtts), XFormParser.getVagueLocation(e));
        }
    }

    protected QuestionDef parseUpload(IFormElement parent, Element e, int controlUpload) {
        String mediaType = e.getAttributeValue(null, "mediatype");
        QuestionDef question = this.parseControl(parent, e, controlUpload, Arrays.asList("mediatype"));
        if ("image/*".equals(mediaType)) {
            question.setControlType(10);
        } else if ("audio/*".equals(mediaType)) {
            question.setControlType(12);
        } else if ("video/*".equals(mediaType)) {
            question.setControlType(13);
        } else if ("osm/*".equals(mediaType)) {
            question.setControlType(14);
            List<OSMTag> tags = this.parseOsmTags(e);
            question.setOsmTags(tags);
        } else {
            question.setControlType(15);
        }
        return question;
    }

    private List<OSMTag> parseOsmTags(Element e) {
        ArrayList<OSMTag> tags = new ArrayList<OSMTag>();
        int childCount = e.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            Element childEl;
            String name;
            Object child = e.getChild(i);
            if (!(child instanceof Element) || !(name = (childEl = (Element)child).getName()).equals("tag")) continue;
            OSMTag tag = new OSMTag();
            tags.add(tag);
            int attrCount = childEl.getAttributeCount();
            for (int j = 0; j < attrCount; ++j) {
                String attrName = childEl.getAttributeName(j);
                if (!attrName.equals("key")) continue;
                tag.key = childEl.getAttributeValue(j);
                int tagChildCount = childEl.getChildCount();
                for (int k = 0; k < tagChildCount; ++k) {
                    Object child2 = childEl.getChild(k);
                    if (!(child2 instanceof Element)) continue;
                    Element tagChildEl = (Element)child2;
                    String tagChildName = tagChildEl.getName();
                    if (tagChildName.equals(LABEL_ELEMENT)) {
                        tag.label = tagChildEl.getText(0);
                        continue;
                    }
                    if (!tagChildName.equals("item")) continue;
                    OSMTagItem item = new OSMTagItem();
                    tag.items.add(item);
                    int itemChildCount = tagChildEl.getChildCount();
                    for (int l = 0; l < itemChildCount; ++l) {
                        Object child3 = tagChildEl.getChild(l);
                        if (!(child3 instanceof Element)) continue;
                        Element itemChildEl = (Element)child3;
                        String itemChildName = itemChildEl.getName();
                        if (itemChildName.equals(LABEL_ELEMENT)) {
                            item.label = itemChildEl.getText(0);
                            continue;
                        }
                        if (!itemChildName.equals(VALUE)) continue;
                        item.value = itemChildEl.getText(0);
                    }
                }
            }
        }
        return tags;
    }

    private QuestionDef parseControl(IFormElement parent, Element e, int controlType) {
        return this.parseControl(parent, e, controlType, null, null);
    }

    private QuestionDef parseControl(IFormElement parent, Element e, int controlType, List<String> additionalUsedAtts) {
        return this.parseControl(parent, e, controlType, additionalUsedAtts, null);
    }

    private QuestionDef parseControl(IFormElement parent, Element e, int controlType, List<String> additionalUsedAtts, List<String> passedThroughAtts) {
        QuestionDef question = this.questionForControlType(controlType);
        question.setID(this.serialQuestionID++);
        ArrayList<String> usedAtts = new ArrayList<String>(Arrays.asList(REF_ATTR, BIND_ATTR, APPEARANCE_ATTR));
        if (additionalUsedAtts != null) {
            usedAtts.addAll(additionalUsedAtts);
        }
        IDataReference dataRef = null;
        boolean refFromBind = false;
        String ref = e.getAttributeValue(null, REF_ATTR);
        String bind = e.getAttributeValue(null, BIND_ATTR);
        if (bind != null) {
            DataBinding binding = this.bindingsByID.get(bind);
            if (binding == null) {
                throw new XFormParseException("XForm Parse: invalid binding ID '" + bind + "'", e);
            }
            dataRef = binding.getReference();
            refFromBind = true;
        } else if (ref != null) {
            try {
                dataRef = new XPathReference(ref);
            }
            catch (RuntimeException el) {
                logger.info(XFormParser.getVagueLocation(e));
                throw el;
            }
        } else if (controlType != 9) {
            throw new XFormParseException("XForm Parse: input control with neither 'ref' nor 'bind'", e);
        }
        if (dataRef != null) {
            if (!refFromBind) {
                dataRef = this.getAbsRef(dataRef, parent);
            }
            question.setBind(dataRef);
            if (controlType == 2) {
                this.selectOnes.add((TreeReference)dataRef.getReference());
            } else if (controlType == 3 || controlType == 16) {
                this.multipleItems.add((TreeReference)dataRef.getReference());
            }
        }
        boolean isItem = controlType == 3 || controlType == 16 || controlType == 2;
        question.setControlType(controlType);
        question.setAppearanceAttr(e.getAttributeValue(null, APPEARANCE_ATTR));
        for (int i = 0; i < e.getChildCount(); ++i) {
            String childName;
            int type = e.getType(i);
            Element child = type == 2 ? e.getElement(i) : null;
            String string = childName = child != null ? child.getName() : null;
            if (LABEL_ELEMENT.equals(childName)) {
                this.parseQuestionLabel(question, child);
                continue;
            }
            if ("hint".equals(childName)) {
                this.parseHint(question, child);
                continue;
            }
            if (isItem && "item".equals(childName)) {
                this.parseItem(question, child);
                continue;
            }
            if (isItem && "itemset".equals(childName)) {
                this.parseItemset(question, child, parent);
                continue;
            }
            if (!actionHandlers.containsKey(childName)) continue;
            actionHandlers.get(childName).handle(this, child, question);
        }
        if (isItem) {
            if (question.getNumChoices() > 0 && question.getDynamicChoices() != null) {
                throw new XFormParseException("Select question contains both literal choices and <itemset>");
            }
            if (question.getNumChoices() == 0 && question.getDynamicChoices() == null) {
                throw new XFormParseException("Select question '" + question.getLabelInnerText() + "' has no choices");
            }
        }
        if (question instanceof RangeQuestion) {
            RangeParser.populateQuestionWithRangeAttributes((RangeQuestion)question, e);
        }
        parent.addChild(question);
        this.processAdditionalAttributes(question, e, usedAtts, passedThroughAtts);
        return question;
    }

    private QuestionDef questionForControlType(int controlType) {
        return controlType == 6 ? new RangeQuestion() : new QuestionDef();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseQuestionLabel(QuestionDef q, Element e) {
        String label = this.getLabel(e);
        String ref = e.getAttributeValue("", REF_ATTR);
        ArrayList<String> usedAtts = new ArrayList<String>();
        usedAtts.add(REF_ATTR);
        if (ref != null) {
            if (!ref.startsWith(ITEXT_OPEN) || !ref.endsWith(ITEXT_CLOSE)) throw new RuntimeException("malformed ref [" + ref + "] for <label>");
            String textRef = ref.substring(ITEXT_OPEN.length(), ref.lastIndexOf(ITEXT_CLOSE));
            this.verifyTextMappings(textRef, "Question <label>", true);
            q.setTextID(textRef);
        } else {
            q.setLabelInnerText(label);
        }
        if (!XFormUtils.showUnusedAttributeWarning(e, usedAtts)) return;
        this.triggerWarning(XFormUtils.unusedAttWarning(e, usedAtts), XFormParser.getVagueLocation(e));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseGroupLabel(GroupDef g, Element e) {
        if (g.getRepeat()) {
            return;
        }
        ArrayList<String> usedAtts = new ArrayList<String>();
        usedAtts.add(REF_ATTR);
        String label = this.getLabel(e);
        String ref = e.getAttributeValue("", REF_ATTR);
        if (ref != null) {
            if (!ref.startsWith(ITEXT_OPEN) || !ref.endsWith(ITEXT_CLOSE)) throw new RuntimeException("malformed ref [" + ref + "] for <label>");
            String textRef = ref.substring(ITEXT_OPEN.length(), ref.lastIndexOf(ITEXT_CLOSE));
            this.verifyTextMappings(textRef, "Group <label>", true);
            g.setTextID(textRef);
        } else {
            g.setLabelInnerText(label);
        }
        if (!XFormUtils.showUnusedAttributeWarning(e, usedAtts)) return;
        this.triggerWarning(XFormUtils.unusedAttWarning(e, usedAtts), XFormParser.getVagueLocation(e));
    }

    private String getLabel(Element e) {
        if (e.getChildCount() == 0) {
            return null;
        }
        this.recurseForOutput(e);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < e.getChildCount(); ++i) {
            if (e.getType(i) != 4 && !(e.getChild(i) instanceof String)) {
                Object b = e.getChild(i);
                Element child = (Element)b;
                if (NAMESPACE_HTML.equals(child.getNamespace())) {
                    sb.append(XFormSerializer.elementToString(child));
                    continue;
                }
                logger.info("Unrecognized tag inside of text: <{}>. Did you intend to use HTML markup? If so, ensure that the element is defined in the HTML namespace.", (Object)child.getName());
                continue;
            }
            sb.append(e.getText(i));
        }
        return sb.toString().trim();
    }

    private void recurseForOutput(Element e) {
        if (e.getChildCount() == 0) {
            return;
        }
        for (int i = 0; i < e.getChildCount(); ++i) {
            int kidType = e.getType(i);
            if (kidType == 4 || e.getChild(i) instanceof String) continue;
            Element kid = (Element)e.getChild(i);
            if (kidType == 2 && XFormUtils.isOutput(kid)) {
                String s = "${" + this.parseOutput(kid) + "}";
                e.removeChild(i);
                e.addChild(i, 4, (Object)s);
                continue;
            }
            if (kid.getChildCount() == 0) continue;
            this.recurseForOutput(kid);
        }
    }

    private String parseOutput(Element e) {
        ArrayList<String> usedAtts = new ArrayList<String>();
        usedAtts.add(REF_ATTR);
        usedAtts.add(VALUE);
        String xpath = e.getAttributeValue(null, REF_ATTR);
        if (xpath == null) {
            xpath = e.getAttributeValue(null, VALUE);
        }
        if (xpath == null) {
            throw new XFormParseException("XForm Parse: <output> without 'ref' or 'value'", e);
        }
        XPathConditional expr = null;
        try {
            expr = new XPathConditional(xpath);
        }
        catch (XPathSyntaxException xse) {
            this.triggerError("Invalid XPath expression in <output> [" + xpath + "]! " + xse.getMessage());
            return "";
        }
        int index = -1;
        if (this._f.getOutputFragments().contains(expr)) {
            index = this._f.getOutputFragments().indexOf(expr);
        } else {
            index = this._f.getOutputFragments().size();
            this._f.getOutputFragments().add(expr);
        }
        if (XFormUtils.showUnusedAttributeWarning(e, usedAtts)) {
            this.triggerWarning(XFormUtils.unusedAttWarning(e, usedAtts), XFormParser.getVagueLocation(e));
        }
        return String.valueOf(index);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseHint(QuestionDef q, Element e) {
        ArrayList<String> usedAtts = new ArrayList<String>();
        usedAtts.add(REF_ATTR);
        String hint = XFormParser.getXMLText((Node)e, true);
        String hintInnerText = this.getLabel(e);
        String ref = e.getAttributeValue("", REF_ATTR);
        if (ref != null) {
            if (!ref.startsWith(ITEXT_OPEN) || !ref.endsWith(ITEXT_CLOSE)) throw new RuntimeException("malformed ref [" + ref + "] for <hint>");
            String textRef = ref.substring(ITEXT_OPEN.length(), ref.lastIndexOf(ITEXT_CLOSE));
            this.verifyTextMappings(textRef, "<hint>", true);
            q.setHelpTextID(textRef);
        } else {
            q.setHelpInnerText(hintInnerText);
            q.setHelpText(hint);
        }
        if (!XFormUtils.showUnusedAttributeWarning(e, usedAtts)) return;
        this.triggerWarning(XFormUtils.unusedAttWarning(e, usedAtts), XFormParser.getVagueLocation(e));
    }

    private void parseItem(QuestionDef q, Element e) {
        int MAX_VALUE_LEN = 32;
        ArrayList<String> usedAtts = new ArrayList<String>();
        ArrayList<String> labelUA = new ArrayList<String>();
        ArrayList<String> valueUA = new ArrayList<String>();
        labelUA.add(REF_ATTR);
        valueUA.add(FORM_ATTR);
        String labelInnerText = null;
        String textRef = null;
        String value = null;
        block0: for (int i = 0; i < e.getChildCount(); ++i) {
            String childName;
            int type = e.getType(i);
            Element child = type == 2 ? e.getElement(i) : null;
            String string = childName = child != null ? child.getName() : null;
            if (LABEL_ELEMENT.equals(childName)) {
                if (XFormUtils.showUnusedAttributeWarning(child, labelUA)) {
                    this.triggerWarning(XFormUtils.unusedAttWarning(child, labelUA), XFormParser.getVagueLocation(child));
                }
                labelInnerText = this.getLabel(child);
                String ref = child.getAttributeValue("", REF_ATTR);
                if (ref == null) continue;
                if (ref.startsWith(ITEXT_OPEN) && ref.endsWith(ITEXT_CLOSE)) {
                    textRef = ref.substring(ITEXT_OPEN.length(), ref.lastIndexOf(ITEXT_CLOSE));
                    this.verifyTextMappings(textRef, "Item <label>", true);
                    continue;
                }
                throw new XFormParseException("malformed ref [" + ref + "] for <item>", child);
            }
            if (!VALUE.equals(childName)) continue;
            value = XFormParser.getXMLText((Node)child, true);
            if (XFormUtils.showUnusedAttributeWarning(child, valueUA)) {
                this.triggerWarning(XFormUtils.unusedAttWarning(child, valueUA), XFormParser.getVagueLocation(child));
            }
            if (value == null) continue;
            if (value.length() > 32) {
                this.triggerWarning("choice value [" + value + "] is too long; max. suggested length " + 32 + " chars", XFormParser.getVagueLocation(child));
            }
            for (int k = 0; k < value.length(); ++k) {
                boolean isMultipleItems;
                char c = value.charAt(k);
                if (" \n\t\f\r'\"`".indexOf(c) < 0) continue;
                boolean bl = isMultipleItems = q.getControlType() == 3 || q.getControlType() == 16;
                String questionType = !isMultipleItems ? "select1" : (q.getControlType() == 3 ? "select" : "rank");
                this.triggerWarning(questionType + " question <value>s [" + value + "] " + (isMultipleItems ? "cannot" : "should not") + " contain spaces, and are recommended not to contain apostraphes/quotation marks", XFormParser.getVagueLocation(child));
                continue block0;
            }
        }
        if (textRef == null && labelInnerText == null) {
            throw new XFormParseException("<item> without proper <label>", e);
        }
        if (value == null) {
            throw new XFormParseException("<item> without proper <value>", e);
        }
        if (textRef != null) {
            q.addSelectChoice(new SelectChoice(textRef, value));
        } else {
            q.addSelectChoice(new SelectChoice(null, labelInnerText, value, false));
        }
        if (XFormUtils.showUnusedAttributeWarning(e, usedAtts)) {
            this.triggerWarning(XFormUtils.unusedAttWarning(e, usedAtts), XFormParser.getVagueLocation(e));
        }
    }

    private void parseItemset(QuestionDef q, Element e, IFormElement qparent) {
        ItemsetBinding itemset = new ItemsetBinding();
        ArrayList<String> usedAtts = new ArrayList<String>();
        ArrayList<String> labelUA = new ArrayList<String>();
        ArrayList<String> valueUA = new ArrayList<String>();
        ArrayList<String> copyUA = new ArrayList<String>();
        usedAtts.add("nodeset");
        labelUA.add(REF_ATTR);
        valueUA.add(REF_ATTR);
        valueUA.add(FORM_ATTR);
        copyUA.add(REF_ATTR);
        String nodesetStr = e.getAttributeValue("", "nodeset");
        if (nodesetStr == null) {
            throw new RuntimeException("No nodeset attribute in element: [" + e.getName() + "]. This is required. (Element Printout:" + XFormSerializer.elementToString(e) + DYNAMIC_ITEXT_CLOSE);
        }
        if (nodesetStr.startsWith("randomize(")) {
            itemset.randomize = true;
            String seedStr = RandomizeHelper.cleanSeedDefinition(nodesetStr);
            if (seedStr != null && seedStr.matches("\\d*\\.?\\d+")) {
                itemset.randomSeedNumericExpr = new XPathNumericLiteral(Double.parseDouble(seedStr));
            } else if (seedStr != null) {
                itemset.randomSeedPathExpr = XPathReference.getPathExpr(seedStr);
            }
            nodesetStr = RandomizeHelper.cleanNodesetDefinition(nodesetStr);
        }
        XPathPathExpr path = XPathReference.getPathExpr(nodesetStr);
        itemset.nodesetExpr = new XPathConditional(path);
        itemset.contextRef = this.getFormElementRef(q);
        itemset.nodesetRef = null;
        itemset.copyMode = false;
        for (int i = 0; i < e.getChildCount(); ++i) {
            String childName;
            int type = e.getType(i);
            Element child = type == 2 ? e.getElement(i) : null;
            String string = childName = child != null ? child.getName() : null;
            if (LABEL_ELEMENT.equals(childName)) {
                String labelXpath = child.getAttributeValue("", REF_ATTR);
                boolean labelItext = false;
                if (XFormUtils.showUnusedAttributeWarning(child, labelUA)) {
                    this.triggerWarning(XFormUtils.unusedAttWarning(child, labelUA), XFormParser.getVagueLocation(child));
                }
                if (labelXpath != null) {
                    if (labelXpath.startsWith(DYNAMIC_ITEXT_OPEN) && labelXpath.endsWith(DYNAMIC_ITEXT_CLOSE)) {
                        labelXpath = labelXpath.substring(DYNAMIC_ITEXT_OPEN.length(), labelXpath.lastIndexOf(DYNAMIC_ITEXT_CLOSE));
                        labelItext = true;
                    }
                } else {
                    throw new XFormParseException("<label> in <itemset> requires 'ref'");
                }
                XPathPathExpr labelPath = XPathReference.getPathExpr(labelXpath);
                itemset.labelRef = null;
                itemset.labelExpr = new XPathConditional(labelPath);
                itemset.labelIsItext = labelItext;
                continue;
            }
            if ("copy".equals(childName)) {
                String copyXpath = child.getAttributeValue("", REF_ATTR);
                if (XFormUtils.showUnusedAttributeWarning(child, copyUA)) {
                    this.triggerWarning(XFormUtils.unusedAttWarning(child, copyUA), XFormParser.getVagueLocation(child));
                }
                if (copyXpath == null) {
                    throw new XFormParseException("<copy> in <itemset> requires 'ref'");
                }
                XPathPathExpr copyPath = XPathReference.getPathExpr(copyXpath);
                itemset.copyRef = null;
                itemset.copyExpr = new XPathConditional(copyPath);
                itemset.copyMode = true;
                continue;
            }
            if (!VALUE.equals(childName)) continue;
            String valueXpath = child.getAttributeValue("", REF_ATTR);
            if (XFormUtils.showUnusedAttributeWarning(child, valueUA)) {
                this.triggerWarning(XFormUtils.unusedAttWarning(child, valueUA), XFormParser.getVagueLocation(child));
            }
            if (valueXpath == null) {
                throw new XFormParseException("<value> in <itemset> requires 'ref'");
            }
            XPathPathExpr valuePath = XPathReference.getPathExpr(valueXpath);
            itemset.valueRef = null;
            itemset.valueExpr = new XPathConditional(valuePath);
        }
        if (itemset.labelExpr == null) {
            throw new XFormParseException("<itemset> requires <label>");
        }
        if (itemset.copyExpr == null && itemset.valueExpr == null) {
            throw new XFormParseException("<itemset> requires <copy> or <value>");
        }
        if (itemset.copyExpr != null && itemset.valueExpr == null) {
            this.triggerWarning("<itemset>s with <copy> are STRONGLY recommended to have <value> as well; pre-selecting, default answers, and display of answers will not work properly otherwise", XFormParser.getVagueLocation(e));
        }
        this.itemsets.add(itemset);
        q.setDynamicChoices(itemset);
        if (XFormUtils.showUnusedAttributeWarning(e, usedAtts)) {
            this.triggerWarning(XFormUtils.unusedAttWarning(e, usedAtts), XFormParser.getVagueLocation(e));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseGroup(IFormElement parent, Element e, int groupType) {
        int i;
        GroupDef group = new GroupDef();
        group.setID(this.serialQuestionID++);
        IDataReference dataRef = null;
        boolean refFromBind = false;
        ArrayList<String> usedAtts = new ArrayList<String>();
        usedAtts.add(REF_ATTR);
        usedAtts.add("nodeset");
        usedAtts.add(BIND_ATTR);
        usedAtts.add(APPEARANCE_ATTR);
        usedAtts.add("count");
        usedAtts.add("noAddRemove");
        if (groupType == 2) {
            group.setRepeat(true);
        }
        String ref = e.getAttributeValue(null, REF_ATTR);
        String nodeset = e.getAttributeValue(null, "nodeset");
        String bind = e.getAttributeValue(null, BIND_ATTR);
        group.setAppearanceAttr(e.getAttributeValue(null, APPEARANCE_ATTR));
        if (bind != null) {
            DataBinding binding = this.bindingsByID.get(bind);
            if (binding == null) {
                throw new XFormParseException("XForm Parse: invalid binding ID [" + bind + "]", e);
            }
            dataRef = binding.getReference();
            refFromBind = true;
        } else if (group.getRepeat()) {
            if (nodeset == null) throw new XFormParseException("XForm Parse: <repeat> with no binding ('bind' or 'nodeset')", e);
            dataRef = new XPathReference(nodeset);
        } else if (ref != null) {
            dataRef = new XPathReference(ref);
        } else if (nodeset != null) {
            dataRef = new XPathReference(nodeset);
        }
        if (!refFromBind) {
            dataRef = this.getAbsRef(dataRef, parent);
        }
        group.setBind(dataRef);
        if (group.getRepeat()) {
            this.repeats.add((TreeReference)dataRef.getReference());
            String countRef = e.getAttributeValue(NAMESPACE_JAVAROSA, "count");
            if (countRef != null) {
                group.count = this.getAbsRef(new XPathReference(countRef), parent);
                group.noAddRemove = true;
            } else {
                group.noAddRemove = e.getAttributeValue(NAMESPACE_JAVAROSA, "noAddRemove") != null;
            }
        }
        for (i = 0; i < e.getChildCount(); ++i) {
            String childNamespace;
            int type = e.getType(i);
            Element child = type == 2 ? e.getElement(i) : null;
            String childName = child != null ? child.getName() : null;
            String string = childNamespace = child != null ? child.getNamespace() : null;
            if (group.getRepeat() && NAMESPACE_JAVAROSA.equals(childNamespace)) {
                if ("chooseCaption".equals(childName)) {
                    group.chooseCaption = this.getLabel(child);
                } else if ("addCaption".equals(childName)) {
                    group.addCaption = this.getLabel(child);
                } else if ("delCaption".equals(childName)) {
                    group.delCaption = this.getLabel(child);
                } else if ("doneCaption".equals(childName)) {
                    group.doneCaption = this.getLabel(child);
                } else if ("addEmptyCaption".equals(childName)) {
                    group.addEmptyCaption = this.getLabel(child);
                } else if ("doneEmptyCaption".equals(childName)) {
                    group.doneEmptyCaption = this.getLabel(child);
                } else if ("entryHeader".equals(childName)) {
                    group.entryHeader = this.getLabel(child);
                } else if ("delHeader".equals(childName)) {
                    group.delHeader = this.getLabel(child);
                } else if ("mainHeader".equals(childName)) {
                    group.mainHeader = this.getLabel(child);
                }
            }
            if (type != 2) continue;
            if (group.getRepeat() && actionHandlers.containsKey(e.getElement(i).getName())) {
                actionHandlers.get(childName).handle(this, child, group);
                continue;
            }
            this.parseElement(e.getElement(i), group, groupLevelHandlers);
        }
        for (i = 0; i < e.getAttributeCount(); ++i) {
            String name = e.getAttributeName(i);
            if (usedAtts.contains(name)) continue;
            group.setAdditionalAttribute(e.getAttributeNamespace(i), name, e.getAttributeValue(i));
        }
        if (XFormUtils.showUnusedAttributeWarning(e, usedAtts)) {
            this.triggerWarning(XFormUtils.unusedAttWarning(e, usedAtts), XFormParser.getVagueLocation(e));
        }
        parent.addChild(group);
    }

    private TreeReference getFormElementRef(IFormElement fe) {
        if (fe instanceof FormDef) {
            TreeReference ref = TreeReference.rootRef();
            ref.add(this.mainInstanceNode.getName(), 0);
            return ref;
        }
        return (TreeReference)fe.getBind().getReference();
    }

    @Override
    public IDataReference getAbsRef(IDataReference ref, IFormElement parent) {
        return FormDef.getAbsRef(ref, this.getFormElementRef(parent));
    }

    private static void collapseRepeatGroups(IFormElement fe) {
        if (fe.getChildren() == null) {
            return;
        }
        for (int i = 0; i < fe.getChildren().size(); ++i) {
            IFormElement child = fe.getChild(i);
            GroupDef group = null;
            if (child instanceof GroupDef) {
                group = (GroupDef)child;
            }
            if (group == null) continue;
            if (!group.getRepeat() && group.getChildren().size() == 1) {
                IFormElement grandchild = group.getChildren().get(0);
                GroupDef repeat = null;
                if (grandchild instanceof GroupDef) {
                    repeat = (GroupDef)grandchild;
                }
                if (repeat != null && repeat.getRepeat()) {
                    repeat.setLabelInnerText(group.getLabelInnerText());
                    repeat.setTextID(group.getTextID());
                    fe.getChildren().set(i, repeat);
                    group = repeat;
                }
            }
            XFormParser.collapseRepeatGroups(group);
        }
    }

    private void parseIText(Element itext) {
        Localizer l = new Localizer(true, true);
        ArrayList<String> usedAtts = new ArrayList<String>();
        for (int i = 0; i < itext.getChildCount(); ++i) {
            Element trans = itext.getElement(i);
            if (trans == null || !trans.getName().equals("translation")) continue;
            this.parseTranslation(l, trans);
        }
        if (l.getAvailableLocales().length == 0) {
            throw new XFormParseException("no <translation>s defined", itext);
        }
        if (l.getDefaultLocale() == null) {
            l.setDefaultLocale(l.getAvailableLocales()[0]);
        }
        if (XFormUtils.showUnusedAttributeWarning(itext, usedAtts)) {
            this.triggerWarning(XFormUtils.unusedAttWarning(itext, usedAtts), XFormParser.getVagueLocation(itext));
        }
        this.localizer = l;
    }

    private void parseTranslation(Localizer l, Element trans) {
        ArrayList<String> usedAtts = new ArrayList<String>();
        usedAtts.add("lang");
        usedAtts.add("default");
        String lang = trans.getAttributeValue("", "lang");
        if (lang == null || lang.length() == 0) {
            throw new XFormParseException("no language specified for <translation>", trans);
        }
        String isDefault = trans.getAttributeValue("", "default");
        if (!l.addAvailableLocale(lang)) {
            throw new XFormParseException("duplicate <translation> for language '" + lang + "'", trans);
        }
        if (isDefault != null) {
            if (l.getDefaultLocale() != null) {
                throw new XFormParseException("more than one <translation> set as default", trans);
            }
            l.setDefaultLocale(lang);
        }
        TableLocaleSource source = new TableLocaleSource();
        HashSet<Integer> removeIndexes = new HashSet<Integer>();
        for (int j = 0; j < trans.getChildCount(); ++j) {
            Element text = trans.getElement(j);
            if (text == null || !text.getName().equals("text")) continue;
            this.parseTextHandle(source, text);
            removeIndexes.add(j);
        }
        ElementChildDeleter.delete(trans, removeIndexes);
        if (XFormUtils.showUnusedAttributeWarning(trans, usedAtts)) {
            this.triggerWarning(XFormUtils.unusedAttWarning(trans, usedAtts), XFormParser.getVagueLocation(trans));
        }
        l.registerLocaleResource(lang, source);
    }

    private void parseTextHandle(TableLocaleSource l, Element text) {
        String id = text.getAttributeValue("", "id");
        ArrayList<String> usedAtts = new ArrayList<String>();
        ArrayList<String> childUsedAtts = new ArrayList<String>();
        usedAtts.add("id");
        usedAtts.add(FORM_ATTR);
        childUsedAtts.add(FORM_ATTR);
        childUsedAtts.add("id");
        if (id == null || id.length() == 0) {
            throw new XFormParseException("no id defined for <text>", text);
        }
        for (int k = 0; k < text.getChildCount(); ++k) {
            String textID;
            String data;
            Element value = text.getElement(k);
            if (value == null) continue;
            if (!value.getName().equals(VALUE)) {
                throw new XFormParseException("Unrecognized element [" + value.getName() + "] in Itext->translation->text");
            }
            String form = value.getAttributeValue("", FORM_ATTR);
            if (form != null && form.length() == 0) {
                form = null;
            }
            if ((data = this.getLabel(value)) == null) {
                data = "";
            }
            String string = textID = form == null ? id : id + ";" + form;
            if (l.hasMapping(textID)) {
                throw new XFormParseException("duplicate definition for text ID \"" + id + "\" and form \"" + form + "\". Can only have one definition for each text form.", text);
            }
            l.setLocaleMapping(textID, data);
            if (!XFormUtils.showUnusedAttributeWarning(value, childUsedAtts)) continue;
            this.triggerWarning(XFormUtils.unusedAttWarning(value, childUsedAtts), XFormParser.getVagueLocation(value));
        }
        if (XFormUtils.showUnusedAttributeWarning(text, usedAtts)) {
            this.triggerWarning(XFormUtils.unusedAttWarning(text, usedAtts), XFormParser.getVagueLocation(text));
        }
    }

    private boolean hasITextMapping(String textID, String locale) {
        return this.localizer.hasMapping(locale == null ? this.localizer.getDefaultLocale() : locale, textID);
    }

    private void verifyTextMappings(String textID, String type, boolean allowSubforms) {
        String[] locales;
        for (String locale : locales = this.localizer.getAvailableLocales()) {
            if (this.hasITextMapping(textID, locale) || allowSubforms && this.hasSpecialFormMapping(textID, locale)) continue;
            if (locale.equals(this.localizer.getDefaultLocale())) {
                throw new XFormParseException(type + " '" + textID + "': text is not localizable for default locale [" + this.localizer.getDefaultLocale() + "]!");
            }
            this.triggerWarning(type + " '" + textID + "': text is not localizable for locale " + locale + ".", null);
        }
    }

    private boolean hasSpecialFormMapping(String textID, String locale) {
        for (String guess : this.itextKnownForms) {
            if (!this.hasITextMapping(textID + ";" + guess, locale)) continue;
            return true;
        }
        for (String key : this.localizer.getLocaleData(locale).keySet()) {
            if (!key.startsWith(textID + ";")) continue;
            String textForm = key.substring(key.indexOf(";") + 1, key.length());
            if (!this.itextKnownForms.contains(textForm)) {
                logger.info("adding unexpected special itext form: {} to list of expected forms", (Object)textForm);
                this.itextKnownForms.add(textForm);
            }
            return true;
        }
        return false;
    }

    private DataBinding processStandardBindAttributes(List<String> usedAtts, List<String> passedThroughAtts, Element element) {
        return new StandardBindAttributesProcessor(typeMappings).createBinding(this, this._f, usedAtts, passedThroughAtts, element);
    }

    private void parseBind(Element element) {
        DataBinding binding = this.processStandardBindAttributes(this.usedAtts, this.passedThroughAtts, element);
        if (XFormUtils.showUnusedAttributeWarning(element, this.usedAtts)) {
            this.triggerWarning(XFormUtils.unusedAttWarning(element, this.usedAtts), XFormParser.getVagueLocation(element));
        }
        this.addBinding(binding);
    }

    private void addBinding(DataBinding binding) {
        this.bindings.add(binding);
        if (binding.getId() != null && this.bindingsByID.put(binding.getId(), binding) != null) {
            throw new XFormParseException("XForm Parse: <bind>s with duplicate ID: '" + binding.getId() + "'");
        }
    }

    private void addMainInstanceToFormDef(Element e, FormInstance instanceModel) {
        XFormParser.loadInstanceData(e, instanceModel.getRoot(), this._f);
        this._f.setInstance(instanceModel);
        this._f.setLocalizer(this.localizer);
        try {
            this._f.finalizeTriggerables();
        }
        catch (IllegalStateException ise) {
            throw new XFormParseException(ise.getMessage() == null ? "Form has an illegal cycle in its calculate and relevancy expressions!" : ise.getMessage());
        }
    }

    static HashMap<String, String> loadNamespaces(Element e, FormInstance tree) {
        HashMap<String, String> prefixes = new HashMap<String, String>();
        for (int i = 0; i < e.getNamespaceCount(); ++i) {
            String uri = e.getNamespaceUri(i);
            String prefix = e.getNamespacePrefix(i);
            if (uri == null || prefix == null) continue;
            tree.addNamespace(prefix, uri);
        }
        return prefixes;
    }

    public static TreeElement buildInstanceStructure(Element node, TreeElement parent, Map<String, String> namespacePrefixesByUri, Integer multiplicityFromGroup) {
        return XFormParser.buildInstanceStructure(node, parent, null, node.getNamespace(), namespacePrefixesByUri, multiplicityFromGroup);
    }

    public static TreeElement buildInstanceStructure(Element node, TreeElement parent, String instanceName, String docnamespace, Map<String, String> namespacePrefixesByUri, Integer multiplicityFromGroup) {
        TreeElement element;
        String modelType;
        int multiplicity;
        int numChildren = node.getChildCount();
        boolean hasText = false;
        boolean hasElements = false;
        block4: for (int i = 0; i < numChildren; ++i) {
            switch (node.getType(i)) {
                case 2: {
                    hasElements = true;
                    continue block4;
                }
                case 4: {
                    if (node.getText(i).trim().length() <= 0) continue block4;
                    hasText = true;
                }
            }
        }
        if (hasElements && hasText) {
            logger.warn("instance node '{}' contains both elements and text as children; text ignored", (Object)node.getName());
        }
        String name = node.getName();
        if (XFormParser.isTemplate(node)) {
            multiplicity = -2;
            if (parent != null && parent.getChild(name, -2) != null) {
                throw new XFormParseException("More than one node declared as the template for the same repeated set [" + name + "]", node);
            }
        } else {
            int n = multiplicityFromGroup != null ? multiplicityFromGroup : (multiplicity = parent == null ? 0 : parent.getChildMultiplicity(name));
        }
        if ((modelType = node.getAttributeValue(NAMESPACE_JAVAROSA, "modeltype")) == null) {
            element = new TreeElement(name, multiplicity);
            element.setInstanceName(instanceName);
        } else {
            if (typeMappings.get(modelType) == null) {
                throw new XFormParseException("ModelType " + modelType + " is not recognized.", node);
            }
            element = new TreeElement(name, multiplicity);
            logger.info("No model type prototype available for {}", (Object)modelType);
        }
        if (node.getNamespace() != null) {
            if (!node.getNamespace().equals(docnamespace)) {
                element.setNamespace(node.getNamespace());
            }
            if (namespacePrefixesByUri.containsKey(node.getNamespace())) {
                element.setNamespacePrefix(namespacePrefixesByUri.get(node.getNamespace()));
            }
        }
        if (hasElements) {
            Integer newMultiplicityFromGroup = XFormParser.childOptimizationsOk(node) ? Integer.valueOf(0) : null;
            for (int i = 0; i < numChildren; ++i) {
                if (node.getType(i) != 2) continue;
                TreeElement newChild = XFormParser.buildInstanceStructure(node.getElement(i), element, instanceName, docnamespace, namespacePrefixesByUri, newMultiplicityFromGroup);
                element.addChild(newChild);
                if (newMultiplicityFromGroup == null) continue;
                Integer n = newMultiplicityFromGroup;
                Integer n2 = newMultiplicityFromGroup = Integer.valueOf(newMultiplicityFromGroup + 1);
            }
        }
        if (node.getAttributeCount() > 0) {
            for (int i = 0; i < node.getAttributeCount(); ++i) {
                String attrNamespace = node.getAttributeNamespace(i);
                String attrName = node.getAttributeName(i);
                if (attrNamespace.equals(NAMESPACE_JAVAROSA) && attrName.equals("template") || attrNamespace.equals(NAMESPACE_JAVAROSA) && attrName.equals("recordset")) continue;
                element.setAttribute(attrNamespace, attrName, node.getAttributeValue(i));
            }
        }
        return element;
    }

    private static boolean isTemplate(Element node) {
        return node.getAttributeValue(NAMESPACE_JAVAROSA, "template") != null;
    }

    static boolean childOptimizationsOk(Element parent) {
        if (parent.getChildCount() == 0) {
            return false;
        }
        Element firstChild = parent.getElement(0);
        if (firstChild == null || XFormParser.isTemplate(firstChild)) {
            return false;
        }
        String firstName = firstChild.getName();
        for (int i = 1; i < parent.getChildCount(); ++i) {
            Element child = parent.getElement(i);
            if (child != null && !XFormParser.isTemplate(child) && child.getName().equals(firstName)) continue;
            return false;
        }
        return true;
    }

    private static void loadInstanceData(Element node, TreeElement cur, FormDef f) {
        int numChildren = node.getChildCount();
        boolean hasElements = false;
        for (int i = 0; i < numChildren; ++i) {
            if (node.getType(i) != 2) continue;
            hasElements = true;
            break;
        }
        if (hasElements) {
            HashMap<String, Integer> multiplicities = new HashMap<String, Integer>();
            for (int i = 0; i < numChildren; ++i) {
                int index;
                if (node.getType(i) != 2) continue;
                Element child = node.getElement(i);
                String name = child.getName();
                boolean isTemplate = XFormParser.isTemplate(child);
                if (isTemplate) {
                    index = -2;
                } else {
                    Integer mult = (Integer)multiplicities.get(name);
                    index = mult == null ? 0 : mult + 1;
                    multiplicities.put(name, index);
                }
                XFormParser.loadInstanceData(child, cur.getChild(name, index), f);
            }
        } else {
            String text = XFormParser.getXMLText((Node)node, true);
            if (text != null && text.trim().length() > 0) {
                cur.setValue(XFormAnswerDataParser.getAnswerData(text, cur.getDataType(), XFormParser.ghettoGetQuestionDef(cur.getDataType(), f, cur.getRef())));
            }
        }
    }

    public static QuestionDef ghettoGetQuestionDef(int dataType, FormDef f, TreeReference ref) {
        if (dataType == 7 || dataType == 8) {
            return FormDef.findQuestionByRef(ref, f);
        }
        return null;
    }

    private void checkDependencyCycles() {
        this._f.reportDependencyCycles();
    }

    private void loadXmlInstance(FormDef f, Reader xmlReader) throws IOException {
        XFormParser.loadXmlInstance(f, XFormParser.getXMLDocument(xmlReader));
    }

    private static void loadXmlInstance(FormDef f, Document xmlInst) {
        TreeElement savedRoot = XFormParser.restoreDataModel(xmlInst, null).getRoot();
        TreeElement templateRoot = f.getMainInstance().getRoot().deepCopy(true);
        if (!savedRoot.getName().equals(templateRoot.getName()) || savedRoot.getMult() != 0) {
            throw new RuntimeException("Saved form instance does not match template form definition");
        }
        TreeReference tr = TreeReference.rootRef();
        tr.add(templateRoot.getName(), -1);
        templateRoot.populate(savedRoot, f);
        f.getMainInstance().setRoot(templateRoot);
    }

    public static void registerActionHandler(String name, final IElementHandler specificHandler) {
        actionHandlers.put(name, new IElementHandler(){

            @Override
            public void handle(XFormParser p, Element e, Object parent) {
                p.parseAction(e, parent, specificHandler);
            }
        });
    }

    public void registerActionTarget(TreeReference target) {
        this.actionTargets.add(target);
    }

    public static String getXMLText(Node n, boolean trim) {
        return n.getChildCount() == 0 ? null : XFormParser.getXMLText(n, 0, trim);
    }

    public static String getXMLText(Node node, int i, boolean trim) {
        StringBuilder strBuff = null;
        String text = node.getText(i);
        if (text == null) {
            return null;
        }
        ++i;
        while (i < node.getChildCount() && node.getType(i) == 4) {
            if (strBuff == null) {
                strBuff = new StringBuilder(text);
            }
            strBuff.append(node.getText(i));
            ++i;
        }
        if (strBuff != null) {
            text = strBuff.toString();
        }
        if (trim) {
            text = text.trim();
        }
        return text;
    }

    public static FormInstance restoreDataModel(InputStream input, Class restorableType) throws IOException {
        Document doc = XFormParser.getXMLDocument(new InputStreamReader(input, "UTF-8"));
        if (doc == null) {
            throw new RuntimeException("syntax error in XML instance; could not parse");
        }
        return XFormParser.restoreDataModel(doc, restorableType);
    }

    public static FormInstance restoreDataModel(Document doc, Class restorableType) {
        Restorable r = restorableType != null ? (Restorable)PrototypeFactory.getInstance(restorableType) : null;
        Element e = doc.getRootElement();
        TreeElement te = XFormParser.buildInstanceStructure(e, null, XFormParser.buildNamespacesMap(e), null);
        FormInstance dm = new FormInstance(te);
        XFormParser.loadNamespaces(e, dm);
        if (r != null) {
            RestoreUtils.templateData(r, dm, null);
        }
        XFormParser.loadInstanceData(e, te, null);
        return dm;
    }

    public static FormInstance restoreDataModel(byte[] data, Class restorableType) {
        try {
            return XFormParser.restoreDataModel(new ByteArrayInputStream(data), restorableType);
        }
        catch (IOException e) {
            logger.error("Error", (Throwable)e);
            throw new XFormParseException("Bad parsing from byte array " + e.getMessage());
        }
    }

    public static String getVagueLocation(Element e) {
        String path = e.getName();
        Element walker = e;
        while (walker != null) {
            Node n = walker.getParent();
            if (n instanceof Element) {
                walker = (Element)n;
                String step = walker.getName();
                for (int i = 0; i < walker.getAttributeCount(); ++i) {
                    step = step + "[@" + walker.getAttributeName(i) + "=";
                    step = step + walker.getAttributeValue(i) + "]";
                }
                path = step + "/" + path;
                continue;
            }
            walker = null;
            path = "/" + path;
        }
        String elementString = XFormParser.getVagueElementPrintout(e, 2);
        String fullmsg = "\n    Problem found at nodeset: " + path;
        fullmsg = fullmsg + "\n    With element " + elementString + "\n";
        return fullmsg;
    }

    private static String getVagueElementPrintout(Element e, int maxDepth) {
        String elementString = "<" + e.getName();
        for (int i = 0; i < e.getAttributeCount(); ++i) {
            elementString = elementString + " " + e.getAttributeName(i) + "=\"";
            elementString = elementString + e.getAttributeValue(i) + "\"";
        }
        if (e.getChildCount() > 0) {
            elementString = elementString + ">";
            if (e.getType(0) == 2) {
                elementString = maxDepth > 0 ? elementString + XFormParser.getVagueElementPrintout((Element)e.getChild(0), maxDepth - 1) : elementString + "...";
            }
        } else {
            elementString = elementString + "/>";
        }
        return elementString;
    }

    void setStringCache(CacheTable<String> stringCache) {
        this.stringCache = stringCache;
    }

    public void onWarning(WarningCallback callback) {
        this.warningCallbacks.add(callback);
    }

    public void onError(ErrorCallback callback) {
        this.errorCallbacks.add(callback);
    }

    private void triggerWarning(String message, String xmlLocation) {
        String warning = "XForm Parse Warning: " + message + (xmlLocation == null ? "" : xmlLocation);
        logger.warn(warning);
        this._f.addParseWarning(warning);
        for (WarningCallback callback : this.warningCallbacks) {
            callback.accept(warning);
        }
    }

    private void triggerError(String message) {
        String error = "XForm Parse Error: " + message;
        logger.error(error);
        this._f.addParseError(error);
        for (ErrorCallback callback : this.errorCallbacks) {
            callback.accept(error);
        }
    }

    static {
        typeMappings = TypeMappings.getMap();
        try {
            XFormParser.staticInit();
        }
        catch (Exception e) {
            ProgramFlow.die("xfparser-static-init", e);
        }
    }

    public static interface ErrorCallback {
        public void accept(String var1);
    }

    public static interface WarningCallback {
        public void accept(String var1);
    }
}

