/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.javarosa.core.model.FormIndex;
import org.javarosa.core.model.QuickTriggerable;
import org.javarosa.core.model.ValidateOutcome;
import org.javarosa.core.model.condition.Condition;
import org.javarosa.core.model.condition.EvaluationContext;
import org.javarosa.core.model.condition.Recalculate;
import org.javarosa.core.model.condition.Triggerable;
import org.javarosa.core.model.instance.AbstractTreeElement;
import org.javarosa.core.model.instance.FormInstance;
import org.javarosa.core.model.instance.TreeElement;
import org.javarosa.core.model.instance.TreeReference;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.ExtWrapList;
import org.javarosa.core.util.externalizable.PrototypeFactory;
import org.javarosa.debug.EvaluationResult;
import org.javarosa.debug.Event;
import org.javarosa.debug.EventNotifier;
import org.javarosa.form.api.FormEntryController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriggerableDag {
    private static final Logger logger = LoggerFactory.getLogger(TriggerableDag.class);
    private final EventNotifierAccessor accessor;
    private final Set<QuickTriggerable> allTriggerables = new HashSet<QuickTriggerable>();
    private Set<QuickTriggerable> triggerablesDAG = Collections.emptySet();
    private final Map<TreeReference, Set<QuickTriggerable>> triggerablesPerTrigger = new HashMap<TreeReference, Set<QuickTriggerable>>();

    TriggerableDag(EventNotifierAccessor accessor) {
        this.accessor = accessor;
    }

    Triggerable addTriggerable(Triggerable triggerable) {
        QuickTriggerable existingQuickTriggerable = this.findTriggerable(triggerable);
        if (existingQuickTriggerable != null) {
            existingQuickTriggerable.intersectContextWith(triggerable);
            return existingQuickTriggerable.getTriggerable();
        }
        QuickTriggerable newQuickTriggerable = QuickTriggerable.of(triggerable);
        this.allTriggerables.add(newQuickTriggerable);
        Set<TreeReference> triggers = triggerable.getTriggers();
        for (TreeReference trigger : triggers) {
            if (!this.triggerablesPerTrigger.containsKey(trigger)) {
                this.triggerablesPerTrigger.put(trigger, new HashSet());
            }
            this.triggerablesPerTrigger.get(trigger).add(newQuickTriggerable);
        }
        return triggerable;
    }

    private QuickTriggerable findTriggerable(Triggerable t) {
        for (QuickTriggerable qt : this.allTriggerables) {
            if (!qt.contains(t)) continue;
            return qt;
        }
        return null;
    }

    void finalizeTriggerables(FormInstance mainInstance, EvaluationContext ec) throws IllegalStateException {
        this.triggerablesDAG = TriggerableDag.buildDag(this.allTriggerables, this.getDagEdges(mainInstance, ec));
    }

    private Set<QuickTriggerable[]> getDagEdges(FormInstance mainInstance, EvaluationContext ec) {
        HashSet<QuickTriggerable[]> edges = new HashSet<QuickTriggerable[]>();
        for (QuickTriggerable source : this.allTriggerables) {
            Set<QuickTriggerable> targets = TriggerableDag.getDependantTriggerables(mainInstance, ec, source, this.triggerablesPerTrigger);
            if (targets.contains(source)) {
                TriggerableDag.throwCyclesInDagException(targets);
            }
            for (QuickTriggerable target : targets) {
                edges.add(new QuickTriggerable[]{source, target});
            }
            source.setImmediateCascades(targets);
        }
        return edges;
    }

    private static Set<QuickTriggerable> getDependantTriggerables(FormInstance mainInstance, EvaluationContext ec, QuickTriggerable triggerable, Map<TreeReference, Set<QuickTriggerable>> triggerIndex) {
        LinkedHashSet<QuickTriggerable> allDependantTriggerables = new LinkedHashSet<QuickTriggerable>();
        HashSet<TreeReference> targets = new HashSet<TreeReference>();
        for (TreeReference target : triggerable.getTargets()) {
            targets.add(target);
            if (!triggerable.isCascadingToChildren()) continue;
            targets.addAll(TriggerableDag.getChildrenOfReference(mainInstance, ec, target));
        }
        for (TreeReference target : targets) {
            Set<QuickTriggerable> dependantTriggerables = triggerIndex.get(target.hasPredicates() ? target.removePredicates() : target);
            if (dependantTriggerables == null) continue;
            allDependantTriggerables.addAll(dependantTriggerables);
        }
        return allDependantTriggerables;
    }

    private static Set<TreeReference> getChildrenOfReference(FormInstance mainInstance, EvaluationContext evalContext, TreeReference original) {
        HashSet<TreeReference> descendantRefs = new HashSet<TreeReference>();
        TreeElement repeatTemplate = (TreeElement)mainInstance.getTemplatePath(original);
        if (repeatTemplate != null) {
            for (int i = 0; i < repeatTemplate.getNumChildren(); ++i) {
                TreeElement child = repeatTemplate.getChildAt(i);
                descendantRefs.add(child.getRef().genericize());
                descendantRefs.addAll(TriggerableDag.getChildrenRefsOfElement(mainInstance, child));
            }
        } else {
            List<TreeReference> refSet = evalContext.expandReference(original);
            for (TreeReference ref : refSet) {
                descendantRefs.addAll(TriggerableDag.getChildrenRefsOfElement(mainInstance, evalContext.resolveReference(ref)));
            }
        }
        return descendantRefs;
    }

    private static Set<TreeReference> getChildrenRefsOfElement(FormInstance mainInstance, AbstractTreeElement<?> el) {
        HashSet<TreeReference> childrenRefs = new HashSet<TreeReference>();
        TreeElement repeatTemplate = (TreeElement)mainInstance.getTemplatePath(el.getRef());
        if (repeatTemplate != null) {
            for (int i = 0; i < repeatTemplate.getNumChildren(); ++i) {
                TreeElement child = repeatTemplate.getChildAt(i);
                childrenRefs.add(child.getRef().genericize());
                childrenRefs.addAll(TriggerableDag.getChildrenRefsOfElement(mainInstance, child));
            }
        } else {
            for (int i = 0; i < el.getNumChildren(); ++i) {
                Object child = el.getChildAt(i);
                childrenRefs.add(child.getRef().genericize());
                childrenRefs.addAll(TriggerableDag.getChildrenRefsOfElement(mainInstance, child));
            }
        }
        return childrenRefs;
    }

    private static Set<QuickTriggerable> buildDag(Set<QuickTriggerable> vertices, Set<QuickTriggerable[]> edges) {
        LinkedHashSet<QuickTriggerable> dag = new LinkedHashSet<QuickTriggerable>();
        HashSet<QuickTriggerable> remainingVertices = new HashSet<QuickTriggerable>(vertices);
        HashSet<QuickTriggerable[]> remainingEdges = new HashSet<QuickTriggerable[]>(edges);
        while (remainingVertices.size() > 0) {
            HashSet<QuickTriggerable> roots = new HashSet<QuickTriggerable>(remainingVertices);
            for (QuickTriggerable[] edge : remainingEdges) {
                roots.remove(edge[1]);
            }
            if (roots.size() == 0) {
                TriggerableDag.throwCyclesInDagException(vertices);
            }
            remainingVertices.removeAll(roots);
            dag.addAll(roots);
            HashSet<QuickTriggerable[]> newRemainingEdges = new HashSet<QuickTriggerable[]>();
            for (QuickTriggerable[] edge : remainingEdges) {
                if (roots.contains(edge[0])) continue;
                newRemainingEdges.add(edge);
            }
            remainingEdges = newRemainingEdges;
        }
        return dag;
    }

    private static void throwCyclesInDagException(Collection<QuickTriggerable> triggerables) {
        StringBuilder hints = new StringBuilder();
        for (QuickTriggerable qt : triggerables) {
            for (TreeReference r : qt.getTargets()) {
                hints.append("\n").append(r.toString(true));
            }
        }
        String message = "Cycle detected in form's relevant and calculation logic!";
        if (!hints.toString().equals("")) {
            message = message + "\nThe following nodes are likely involved in the loop:" + hints;
        }
        throw new IllegalStateException(message);
    }

    void reportDependencyCycles() {
        HashSet<TreeReference> vertices = new HashSet<TreeReference>();
        ArrayList<TreeReference[]> edges = new ArrayList<TreeReference[]>();
        ArrayList<TreeReference> targets = new ArrayList<TreeReference>();
        for (TreeReference trigger : this.triggerablesPerTrigger.keySet()) {
            vertices.add(trigger);
            Set<QuickTriggerable> triggered = this.triggerablesPerTrigger.get(trigger);
            targets.clear();
            for (QuickTriggerable qt : triggered) {
                for (TreeReference target : qt.getTargets()) {
                    if (targets.contains(target)) continue;
                    targets.add(target);
                }
            }
            for (TreeReference target : targets) {
                vertices.add(target);
                TreeReference[] edge = new TreeReference[]{trigger, target};
                edges.add(edge);
            }
        }
        boolean acyclic = true;
        HashSet<TreeReference> leaves = new HashSet<TreeReference>(vertices.size());
        while (vertices.size() > 0) {
            leaves.clear();
            leaves.addAll(vertices);
            for (TreeReference[] edge : edges) {
                leaves.remove(edge[0]);
            }
            if (leaves.size() == 0) {
                acyclic = false;
                break;
            }
            for (TreeReference leaf : leaves) {
                vertices.remove(leaf);
            }
            for (int i = edges.size() - 1; i >= 0; --i) {
                TreeReference[] edge;
                edge = (TreeReference[])edges.get(i);
                if (!leaves.contains(edge[1])) continue;
                edges.remove(i);
            }
        }
        if (!acyclic) {
            StringBuilder b = new StringBuilder();
            b.append("XPath Dependency Cycle:\n");
            for (TreeReference[] edge : edges) {
                b.append(edge[0].toString()).append(" => ").append(edge[1].toString()).append("\n");
            }
            logger.error("XForm Parse Error: {}", (Object)b.toString());
            throw new RuntimeException("Dependency cycles amongst the xpath expressions in relevant/calculate");
        }
    }

    public ValidateOutcome validate(FormEntryController formEntryControllerToBeValidated, boolean markCompleted) {
        int event;
        formEntryControllerToBeValidated.jumpToIndex(FormIndex.createBeginningOfFormIndex());
        while ((event = formEntryControllerToBeValidated.stepToNextEvent()) != 1) {
            if (event != 4) continue;
            FormIndex formControllerToBeValidatedFormIndex = formEntryControllerToBeValidated.getModel().getFormIndex();
            int saveStatus = formEntryControllerToBeValidated.answerQuestion(formControllerToBeValidatedFormIndex, formEntryControllerToBeValidated.getModel().getQuestionPrompt().getAnswerValue(), false);
            if (!markCompleted || saveStatus == 0) continue;
            return new ValidateOutcome(formControllerToBeValidatedFormIndex, saveStatus);
        }
        return null;
    }

    Collection<QuickTriggerable> initializeTriggerables(FormInstance mainInstance, EvaluationContext evalContext, TreeReference rootRef) {
        return this.initializeTriggerables(mainInstance, evalContext, rootRef, new HashSet<QuickTriggerable>());
    }

    private Set<QuickTriggerable> initializeTriggerables(FormInstance mainInstance, EvaluationContext evalContext, TreeReference rootRef, Set<QuickTriggerable> alreadyEvaluated) {
        TreeReference genericRoot = rootRef.genericize();
        HashSet<QuickTriggerable> applicable = new HashSet<QuickTriggerable>();
        block0: for (QuickTriggerable qt : this.triggerablesDAG) {
            for (TreeReference target : qt.getTargets()) {
                if (!genericRoot.isAncestorOf(target, false)) continue;
                applicable.add(qt);
                continue block0;
            }
        }
        Set<QuickTriggerable> toTrigger = this.getAllToTrigger(applicable);
        return this.doEvaluateTriggerables(mainInstance, evalContext, toTrigger, rootRef, new HashSet<QuickTriggerable>(), alreadyEvaluated);
    }

    Collection<QuickTriggerable> triggerTriggerables(FormInstance mainInstance, EvaluationContext evalContext, TreeReference changedRef) {
        return this.triggerTriggerables(mainInstance, evalContext, changedRef, new HashSet<QuickTriggerable>(), new HashSet<QuickTriggerable>());
    }

    private Set<QuickTriggerable> triggerTriggerables(FormInstance mainInstance, EvaluationContext evalContext, TreeReference changedRef, Set<QuickTriggerable> affectAllRepeatInstances, Set<QuickTriggerable> alreadyEvaluated) {
        TreeReference genericRef = changedRef.genericize();
        Set<QuickTriggerable> cascadeRoots = this.triggerablesPerTrigger.get(genericRef);
        if (cascadeRoots == null) {
            return alreadyEvaluated;
        }
        Set<QuickTriggerable> toTrigger = this.getAllToTrigger(cascadeRoots);
        return this.doEvaluateTriggerables(mainInstance, evalContext, toTrigger, changedRef, affectAllRepeatInstances, alreadyEvaluated);
    }

    private Set<QuickTriggerable> getAllToTrigger(Set<QuickTriggerable> cascadeRoots) {
        HashSet<QuickTriggerable> refSet = new HashSet<QuickTriggerable>(cascadeRoots);
        HashSet<QuickTriggerable> toTrigger = new HashSet<QuickTriggerable>(cascadeRoots);
        while (!refSet.isEmpty()) {
            HashSet<QuickTriggerable> newSet = new HashSet<QuickTriggerable>();
            for (QuickTriggerable qt : refSet) {
                for (QuickTriggerable qu : qt.getImmediateCascades()) {
                    if (toTrigger.contains(qu)) continue;
                    toTrigger.add(qu);
                    newSet.add(qu);
                }
            }
            refSet = newSet;
        }
        return toTrigger;
    }

    private Set<QuickTriggerable> doEvaluateTriggerables(FormInstance mainInstance, EvaluationContext evalContext, Set<QuickTriggerable> toTrigger, TreeReference changedRef, Set<QuickTriggerable> affectAllRepeatInstances, Set<QuickTriggerable> alreadyEvaluated) {
        HashSet<QuickTriggerable> evaluated = new HashSet<QuickTriggerable>();
        for (QuickTriggerable qt : this.triggerablesDAG) {
            if (!toTrigger.contains(qt) || alreadyEvaluated.contains(qt)) continue;
            this.evaluateTriggerable(mainInstance, evalContext, qt, affectAllRepeatInstances.contains(qt), changedRef);
            evaluated.add(qt);
        }
        return evaluated;
    }

    private void evaluateTriggerable(FormInstance mainInstance, EvaluationContext evalContext, QuickTriggerable toTrigger, boolean affectsAllRepeatInstances, TreeReference changedRef) {
        TreeReference contextRef = affectsAllRepeatInstances ? toTrigger.getContext() : toTrigger.getContext().contextualize(changedRef);
        List<TreeReference> qualifiedReferences = evalContext.expandReference(contextRef);
        TreeElement template = (TreeElement)mainInstance.getTemplate(contextRef);
        if (template != null) {
            TreeReference templateRef = template.getRef();
            qualifiedReferences.add(templateRef);
        }
        ArrayList<EvaluationResult> evaluationResults = new ArrayList<EvaluationResult>(0);
        for (TreeReference qualified : qualifiedReferences) {
            try {
                evaluationResults.addAll(toTrigger.apply(mainInstance, new EvaluationContext(evalContext, qualified), qualified));
            }
            catch (Exception e) {
                throw new RuntimeException("Error evaluating field '" + contextRef.getNameLast() + "' (" + qualified + "): " + e.getMessage(), e);
            }
        }
        if (evaluationResults.size() > 0) {
            this.accessor.getEventNotifier().publishEvent(new Event(toTrigger.isCondition() ? "Condition" : "Recalculate", evaluationResults));
        }
    }

    private void evaluateChildrenTriggerables(FormInstance mainInstance, EvaluationContext evalContext, TreeElement newNode, boolean createdOrDeleted, Set<QuickTriggerable> alreadyEvaluated) {
        int numChildren = newNode.getNumChildren();
        for (int i = 0; i < numChildren; ++i) {
            TreeReference anchorRef = newNode.getChildAt(i).getRef();
            Set<QuickTriggerable> childTriggerables = this.triggerTriggerables(mainInstance, evalContext, anchorRef, new HashSet<QuickTriggerable>(), alreadyEvaluated);
            this.publishSummary(createdOrDeleted ? "Created" : "Deleted", anchorRef, childTriggerables);
        }
    }

    void createRepeatInstance(FormInstance mainInstance, EvaluationContext evalContext, TreeReference createdRef, TreeElement createdElement) {
        Set<QuickTriggerable> affectAllInstances = this.getTriggerablesAffectingAllInstances(createdRef.genericize());
        Set<QuickTriggerable> qtSet1 = this.triggerTriggerables(mainInstance, evalContext, createdRef, affectAllInstances, new HashSet<QuickTriggerable>(0));
        this.publishSummary("Created (phase 1)", createdRef, qtSet1);
        Set<QuickTriggerable> qtSet2 = this.initializeTriggerables(mainInstance, evalContext, createdRef, qtSet1);
        this.publishSummary("Created (phase 2)", createdRef, qtSet2);
        HashSet<QuickTriggerable> alreadyEvaluated = new HashSet<QuickTriggerable>(qtSet1);
        alreadyEvaluated.addAll(qtSet2);
        this.evaluateChildrenTriggerables(mainInstance, evalContext, createdElement, true, alreadyEvaluated);
    }

    void deleteRepeatInstance(FormInstance mainInstance, EvaluationContext evalContext, TreeReference deleteRef, TreeElement deletedElement) {
        Set<QuickTriggerable> affectAllInstances = this.getTriggerablesAffectingAllInstances(deleteRef.genericize());
        Set<QuickTriggerable> alreadyEvaluated = this.triggerTriggerables(mainInstance, evalContext, deleteRef, affectAllInstances, new HashSet<QuickTriggerable>());
        this.evaluateChildrenTriggerables(mainInstance, evalContext, deletedElement, false, alreadyEvaluated);
    }

    private Set<QuickTriggerable> getTriggerablesAffectingAllInstances(TreeReference genericRepeatRef) {
        HashSet<QuickTriggerable> result = new HashSet<QuickTriggerable>();
        Set<QuickTriggerable> cascadeRoots = this.triggerablesPerTrigger.get(genericRepeatRef);
        HashSet<QuickTriggerable> outsideRepeat = new HashSet<QuickTriggerable>();
        if (cascadeRoots != null) {
            for (QuickTriggerable root : cascadeRoots) {
                if (!genericRepeatRef.isAncestorOf(root.getContext(), false)) continue;
                result.add(root);
            }
            HashSet<QuickTriggerable> toConsider = new HashSet<QuickTriggerable>(cascadeRoots);
            while (!toConsider.isEmpty()) {
                HashSet<QuickTriggerable> nextCascadeLevel = new HashSet<QuickTriggerable>();
                for (QuickTriggerable qt : toConsider) {
                    if (!genericRepeatRef.isAncestorOf(qt.getContext(), true)) {
                        outsideRepeat.add(qt);
                    } else {
                        HashSet<QuickTriggerable> parentsToConsider = new HashSet<QuickTriggerable>(outsideRepeat);
                        parentsToConsider.addAll(result);
                        for (QuickTriggerable parent : parentsToConsider) {
                            if (!parent.getImmediateCascades().contains(qt)) continue;
                            result.add(qt);
                        }
                    }
                    nextCascadeLevel.addAll(qt.getImmediateCascades());
                }
                toConsider = nextCascadeLevel;
            }
        }
        return result;
    }

    void copyItemsetAnswer(FormInstance mainInstance, EvaluationContext evalContext, TreeReference copyRef, TreeElement copyToElement) {
        TreeReference targetRef = copyToElement.getRef();
        Set<QuickTriggerable> qtSet1 = this.triggerTriggerables(mainInstance, evalContext, copyRef, new HashSet<QuickTriggerable>(), new HashSet<QuickTriggerable>());
        this.publishSummary("Copied itemset answer (phase 1)", targetRef, qtSet1);
        Set<QuickTriggerable> qtSet2 = this.initializeTriggerables(mainInstance, evalContext, copyRef, qtSet1);
        this.publishSummary("Copied itemset answer (phase 2)", targetRef, qtSet2);
    }

    final void publishSummary(String lead, TreeReference ref, Collection<QuickTriggerable> quickTriggerables) {
        this.accessor.getEventNotifier().publishEvent(new Event(lead + ": " + (ref != null ? ref.toShortString() + ": " : "") + quickTriggerables.size() + " triggerables were fired."));
    }

    void writeExternalTriggerables(DataOutputStream dos) throws IOException {
        ExtUtil.write(dos, new ExtWrapList(this.getConditions()));
        ExtUtil.write(dos, new ExtWrapList(this.getRecalculates()));
    }

    static List<Triggerable> readExternalTriggerables(DataInputStream dis, PrototypeFactory pf) throws IOException, DeserializationException {
        LinkedList<Triggerable> triggerables = new LinkedList<Triggerable>();
        triggerables.addAll((List)ExtUtil.read(dis, new ExtWrapList(Condition.class), pf));
        triggerables.addAll((List)ExtUtil.read(dis, new ExtWrapList(Recalculate.class), pf));
        return triggerables;
    }

    private List<Condition> getConditions() {
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        for (QuickTriggerable qt : this.allTriggerables) {
            if (!qt.isCondition()) continue;
            conditions.add((Condition)qt.getTriggerable());
        }
        return conditions;
    }

    private List<Recalculate> getRecalculates() {
        ArrayList<Recalculate> recalculates = new ArrayList<Recalculate>();
        for (QuickTriggerable qt : this.allTriggerables) {
            if (!qt.isRecalculate()) continue;
            recalculates.add((Recalculate)qt.getTriggerable());
        }
        return recalculates;
    }

    public static interface EventNotifierAccessor {
        public EventNotifier getEventNotifier();
    }
}

