/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model.condition;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.javarosa.core.model.condition.EvaluationContext;
import org.javarosa.core.model.condition.IConditionExpr;
import org.javarosa.core.model.instance.FormInstance;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.ExtWrapTagged;
import org.javarosa.core.util.externalizable.Externalizable;
import org.javarosa.core.util.externalizable.PrototypeFactory;
import org.javarosa.xpath.XPathParseTool;
import org.javarosa.xpath.expr.XPathExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Constraint
implements Externalizable {
    private static final Logger logger = LoggerFactory.getLogger(Constraint.class);
    public IConditionExpr constraint;
    private String constraintMsg;
    private XPathExpression xPathConstraintMsg;

    public Constraint() {
    }

    public Constraint(IConditionExpr constraint, String constraintMsg) {
        this.constraint = constraint;
        this.constraintMsg = constraintMsg == null ? null : constraintMsg.trim();
        this.attemptConstraintCompile();
    }

    public String getConstraintMessage(EvaluationContext ec, FormInstance instance, String textForm) {
        if (this.xPathConstraintMsg == null) {
            return textForm == null ? this.constraintMsg : null;
        }
        if (textForm != null) {
            ec.setOutputTextForm(textForm);
        }
        try {
            Object value = this.xPathConstraintMsg.eval(instance, ec);
            if (value != null && ((String)value).length() != 0) {
                return (String)value;
            }
            return null;
        }
        catch (Exception e) {
            logger.error("Error evaluating a valid-looking constraint xpath ", (Throwable)e);
            return this.constraintMsg;
        }
    }

    private void attemptConstraintCompile() {
        this.xPathConstraintMsg = null;
        try {
            if (this.constraintMsg != null && this.constraintMsg.startsWith("jr:itext('") && this.constraintMsg.endsWith("')")) {
                this.xPathConstraintMsg = XPathParseTool.parseXPath("string(" + this.constraintMsg + ")");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void readExternal(DataInputStream in, PrototypeFactory pf) throws IOException, DeserializationException {
        this.constraint = (IConditionExpr)ExtUtil.read(in, new ExtWrapTagged(), pf);
        this.constraintMsg = ExtUtil.nullIfEmpty(ExtUtil.readString(in));
        this.attemptConstraintCompile();
    }

    @Override
    public void writeExternal(DataOutputStream out) throws IOException {
        ExtUtil.write(out, new ExtWrapTagged(this.constraint));
        ExtUtil.writeString(out, ExtUtil.emptyIfNull(this.constraintMsg));
    }
}

