/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.io;

import java.io.IOException;
import java.io.InputStream;

public class BufferedInputStream
extends InputStream {
    private InputStream in;
    private byte[] buffer;
    private int position;
    private int count;

    public BufferedInputStream(InputStream in) {
        this(in, 2048);
    }

    public BufferedInputStream(InputStream in, int size) {
        this.in = in;
        this.buffer = new byte[size];
        this.cleanBuffer();
    }

    private void cleanBuffer() {
        this.position = 0;
        this.count = 0;
    }

    @Override
    public int available() throws IOException {
        if (this.count == -1) {
            return 0;
        }
        return this.in.available() + (this.count - this.position);
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        this.buffer = null;
    }

    @Override
    public void mark(int arg0) {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.count == -1) {
            return -1;
        }
        if (len == 0) {
            return 0;
        }
        if (off == -1 || len == -1 || off + len > b.length) {
            throw new IndexOutOfBoundsException("Bad inputs to input stream read");
        }
        int counter = 0;
        boolean quitEarly = false;
        while (counter != len && !quitEarly) {
            while (this.position < this.count && counter < len) {
                b[off + counter] = this.buffer[this.position];
                ++counter;
                ++this.position;
            }
            if (counter == len || this.position != this.count || quitEarly || this.fillBuffer()) continue;
            if (this.count == -1) {
                if (counter == 0) {
                    return -1;
                }
                return counter;
            }
            quitEarly = true;
        }
        return counter;
    }

    private boolean fillBuffer() throws IOException {
        if (this.count == -1) {
            return false;
        }
        this.position = 0;
        this.count = this.in.read(this.buffer);
        return this.count == this.buffer.length;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public void reset() throws IOException {
    }

    @Override
    public long skip(long len) throws IOException {
        long skipped = this.in.skip(len);
        if (skipped > (long)(this.count - this.position)) {
            this.cleanBuffer();
        } else {
            int bytesSkipped = (int)skipped;
            this.position += bytesSkipped;
        }
        return skipped;
    }

    @Override
    public int read() throws IOException {
        if (this.position == this.count) {
            this.fillBuffer();
        }
        if (this.count == -1) {
            return -1;
        }
        return this.buffer[this.position++] & 0xFF;
    }
}

