/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.javarosa.core.model.FormDef;
import org.javarosa.core.model.IDataReference;
import org.javarosa.core.model.QuestionDef;
import org.javarosa.core.model.SelectChoice;
import org.javarosa.core.model.condition.EvaluationContext;
import org.javarosa.core.model.condition.IConditionExpr;
import org.javarosa.core.model.data.IAnswerData;
import org.javarosa.core.model.data.MultipleItemsData;
import org.javarosa.core.model.data.SelectOneData;
import org.javarosa.core.model.data.helper.Selection;
import org.javarosa.core.model.instance.DataInstance;
import org.javarosa.core.model.instance.TreeElement;
import org.javarosa.core.model.instance.TreeReference;
import org.javarosa.core.model.util.restorable.RestoreUtils;
import org.javarosa.core.services.locale.Localizable;
import org.javarosa.core.services.locale.Localizer;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.ExtWrapNullable;
import org.javarosa.core.util.externalizable.ExtWrapTagged;
import org.javarosa.core.util.externalizable.Externalizable;
import org.javarosa.core.util.externalizable.PrototypeFactory;
import org.javarosa.debug.EvaluationResult;
import org.javarosa.debug.Event;
import org.javarosa.model.xform.XPathReference;
import org.javarosa.xform.parse.RandomizeHelper;
import org.javarosa.xpath.XPathConditional;
import org.javarosa.xpath.XPathException;
import org.javarosa.xpath.expr.XPathFuncExpr;
import org.javarosa.xpath.expr.XPathNumericLiteral;
import org.javarosa.xpath.expr.XPathPathExpr;

public class ItemsetBinding
implements Externalizable,
Localizable {
    private List<SelectChoice> cachedFilteredChoiceList;
    private Map<TreeReference, IAnswerData> cachedTriggerValues;
    private Long cachedRandomizeSeed;
    public TreeReference nodesetRef;
    public IConditionExpr nodesetExpr;
    public TreeReference contextRef;
    public TreeReference labelRef;
    public IConditionExpr labelExpr;
    public boolean labelIsItext;
    public boolean copyMode;
    public IConditionExpr copyExpr;
    public TreeReference copyRef;
    public TreeReference valueRef;
    public IConditionExpr valueExpr;
    private TreeReference destRef;
    public boolean randomize = false;
    public XPathNumericLiteral randomSeedNumericExpr = null;
    public XPathPathExpr randomSeedPathExpr = null;

    public List<SelectChoice> getChoices(FormDef formDef, TreeReference curQRef) {
        String curLocale;
        int i;
        List<TreeReference> filteredItemReferences;
        DataInstance formInstance;
        Map<TreeReference, IAnswerData> currentTriggerValues = this.getCurrentTriggerValues(formDef, curQRef);
        boolean allTriggerRefsBound = currentTriggerValues != null;
        Long currentRandomizeSeed = this.resolveRandomSeed(formDef.getMainInstance(), formDef.getEvaluationContext());
        if (this.cachedFilteredChoiceList != null && allTriggerRefsBound && Objects.equals(currentTriggerValues, this.cachedTriggerValues) && Objects.equals(currentRandomizeSeed, this.cachedRandomizeSeed)) {
            return this.randomize && this.cachedRandomizeSeed == null ? RandomizeHelper.shuffle(this.cachedFilteredChoiceList) : this.cachedFilteredChoiceList;
        }
        formDef.getEventNotifier().publishEvent(new Event("Dynamic choices", new EvaluationResult(curQRef, null)));
        if (this.nodesetRef.getInstanceName() != null) {
            formInstance = formDef.getNonMainInstance(this.nodesetRef.getInstanceName());
            if (formInstance == null) {
                throw new XPathException("Instance " + this.nodesetRef.getInstanceName() + " not found");
            }
        } else {
            formInstance = formDef.getMainInstance();
        }
        if ((filteredItemReferences = this.nodesetExpr.evalNodeset(formDef.getMainInstance(), new EvaluationContext(formDef.getEvaluationContext(), this.contextRef.contextualize(curQRef)))) == null) {
            throw new XPathException("Could not find references depended on by" + this.nodesetRef.getInstanceName());
        }
        Map<String, SelectChoice> selectChoicesForAnswer = this.initializeAnswerMap(formDef, curQRef);
        ArrayList<SelectChoice> choices = new ArrayList<SelectChoice>();
        for (i = 0; i < filteredItemReferences.size(); ++i) {
            SelectChoice choice = this.getChoiceForTreeReference(formDef, formInstance, i, filteredItemReferences.get(i));
            choices.add(choice);
            if (selectChoicesForAnswer == null || !selectChoicesForAnswer.containsKey(choice.getValue())) continue;
            selectChoicesForAnswer.put(choice.getValue(), choice);
        }
        this.updateQuestionAnswerInModel(formDef, curQRef, selectChoicesForAnswer);
        List<SelectChoice> list = this.cachedFilteredChoiceList = this.randomize ? RandomizeHelper.shuffle(choices, currentRandomizeSeed) : choices;
        if (this.randomize) {
            for (i = 0; i < choices.size(); ++i) {
                ((SelectChoice)choices.get(i)).setIndex(i);
            }
        }
        if (formDef.getLocalizer() != null && (curLocale = formDef.getLocalizer().getLocale()) != null) {
            this.localeChanged(curLocale, formDef.getLocalizer());
        }
        this.cachedTriggerValues = currentTriggerValues;
        this.cachedRandomizeSeed = currentRandomizeSeed;
        return this.cachedFilteredChoiceList;
    }

    private Map<TreeReference, IAnswerData> getCurrentTriggerValues(FormDef formDef, TreeReference curQRef) {
        HashMap<TreeReference, IAnswerData> currentTriggerValues = new HashMap<TreeReference, IAnswerData>();
        Set<TreeReference> triggers = this.nodesetExpr.getTriggers(curQRef);
        for (TreeReference trigger : triggers) {
            if (trigger.getInstanceName() != null) continue;
            TreeElement element = (TreeElement)formDef.getMainInstance().resolveReference(trigger);
            if (element != null && !element.isRepeatable()) {
                currentTriggerValues.put(trigger, element.getValue());
                continue;
            }
            return null;
        }
        return currentTriggerValues;
    }

    private SelectChoice getChoiceForTreeReference(FormDef formDef, DataInstance formInstance, int i, TreeReference item) {
        String label = this.labelExpr.evalReadable(formInstance, new EvaluationContext(formDef.getEvaluationContext(), item));
        String value = null;
        if (this.valueRef != null) {
            value = this.valueExpr.evalReadable(formInstance, new EvaluationContext(formDef.getEvaluationContext(), item));
        }
        value = value != null ? value : "dynamic:" + i;
        TreeElement copyNode = null;
        if (this.copyMode) {
            copyNode = (TreeElement)formDef.getMainInstance().resolveReference(this.copyRef.contextualize(item));
        }
        SelectChoice choice = new SelectChoice(label, value, this.labelIsItext);
        choice.setIndex(i);
        if (this.copyMode) {
            choice.copyNode = copyNode;
        }
        return choice;
    }

    private Map<String, SelectChoice> initializeAnswerMap(FormDef formDef, TreeReference curQRef) {
        HashMap<String, Object> selectChoicesForAnswer = null;
        IAnswerData rawValue = ((TreeElement)formDef.getMainInstance().resolveReference(curQRef)).getValue();
        if (rawValue != null) {
            selectChoicesForAnswer = new HashMap<String, Object>();
            if (rawValue instanceof MultipleItemsData) {
                for (Selection selection : (List)rawValue.getValue()) {
                    selectChoicesForAnswer.put(selection.choice != null ? selection.choice.getValue() : selection.xmlValue, null);
                }
            } else {
                selectChoicesForAnswer.put(rawValue.getDisplayText(), null);
            }
        }
        return selectChoicesForAnswer;
    }

    private void updateQuestionAnswerInModel(FormDef formDef, TreeReference curQRef, Map<String, SelectChoice> selectChoicesForAnswer) {
        IAnswerData originalValue = ((TreeElement)formDef.getMainInstance().resolveReference(curQRef)).getValue();
        if (selectChoicesForAnswer != null) {
            IAnswerData boundAndFilteredValue;
            if (originalValue instanceof MultipleItemsData) {
                boundAndFilteredValue = ItemsetBinding.getFilteredAndBoundSelections((MultipleItemsData)originalValue, selectChoicesForAnswer);
            } else if (selectChoicesForAnswer.containsValue(null)) {
                boundAndFilteredValue = null;
            } else {
                SelectChoice selectChoice = selectChoicesForAnswer.get(originalValue.getDisplayText());
                boundAndFilteredValue = new SelectOneData(selectChoice.selection());
            }
            ((TreeElement)formDef.getMainInstance().resolveReference(curQRef)).setAnswer(boundAndFilteredValue);
        }
    }

    private static MultipleItemsData getFilteredAndBoundSelections(MultipleItemsData selections, Map<String, SelectChoice> selectChoicesForAnswer) {
        ArrayList<Selection> newSelections = new ArrayList<Selection>();
        for (Selection oldSelection : (List)selections.getValue()) {
            String key = oldSelection.choice != null ? oldSelection.choice.getValue() : oldSelection.xmlValue;
            SelectChoice selectChoice = selectChoicesForAnswer.get(key);
            if (selectChoice == null) continue;
            newSelections.add(selectChoice.selection());
        }
        return new MultipleItemsData(newSelections);
    }

    private Long resolveRandomSeed(DataInstance model, EvaluationContext ec) {
        if (this.randomSeedNumericExpr != null) {
            return ((Double)this.randomSeedNumericExpr.eval(model, ec)).longValue();
        }
        if (this.randomSeedPathExpr != null) {
            return XPathFuncExpr.toNumeric(this.randomSeedPathExpr.eval(model, ec)).longValue();
        }
        return null;
    }

    @Override
    public void localeChanged(String locale, Localizer localizer) {
        if (this.cachedFilteredChoiceList != null) {
            for (SelectChoice selectChoice : this.cachedFilteredChoiceList) {
                selectChoice.localeChanged(locale, localizer);
            }
        }
    }

    public TreeReference getDestRef() {
        return this.destRef;
    }

    public IConditionExpr getRelativeValue() {
        TreeReference relRef = null;
        if (this.copyRef == null) {
            relRef = this.valueRef;
        } else if (this.valueRef != null) {
            relRef = this.valueRef.relativize(this.copyRef);
        }
        return relRef != null ? RestoreUtils.xfFact.refToPathExpr(relRef) : null;
    }

    public void initReferences(QuestionDef q) {
        this.nodesetRef = ItemsetBinding.getAbsoluteRef(this.nodesetExpr, this.contextRef);
        if (this.labelExpr != null) {
            this.labelRef = ItemsetBinding.getAbsoluteRef(this.labelExpr, this.nodesetRef);
        }
        if (this.copyExpr != null) {
            this.copyRef = ItemsetBinding.getAbsoluteRef(this.copyExpr, this.nodesetRef);
        }
        if (this.valueExpr != null) {
            this.valueRef = ItemsetBinding.getAbsoluteRef(this.valueExpr, this.nodesetRef);
        }
        if (q != null) {
            this.destRef = ((TreeReference)q.getBind().getReference()).clone();
            if (this.copyMode) {
                this.destRef.add(this.copyRef.getNameLast(), -1);
            }
        }
    }

    private static TreeReference getAbsoluteRef(IConditionExpr condExpr, TreeReference baseRef) {
        XPathPathExpr xPathPathExpr = (XPathPathExpr)((XPathConditional)condExpr).getExpr();
        IDataReference dataReference = FormDef.getAbsRef(new XPathReference(xPathPathExpr), baseRef);
        return (TreeReference)dataReference.getReference();
    }

    @Override
    public void readExternal(DataInputStream in, PrototypeFactory pf) throws IOException, DeserializationException {
        this.nodesetExpr = (IConditionExpr)ExtUtil.read(in, new ExtWrapTagged(), pf);
        this.contextRef = (TreeReference)ExtUtil.read(in, TreeReference.class, pf);
        this.labelExpr = (IConditionExpr)ExtUtil.read(in, new ExtWrapTagged(), pf);
        this.valueExpr = (IConditionExpr)ExtUtil.read(in, new ExtWrapNullable(new ExtWrapTagged()), pf);
        this.copyExpr = (IConditionExpr)ExtUtil.read(in, new ExtWrapNullable(new ExtWrapTagged()), pf);
        this.labelIsItext = ExtUtil.readBool(in);
        this.copyMode = ExtUtil.readBool(in);
        this.randomize = ExtUtil.readBool(in);
        this.randomSeedNumericExpr = (XPathNumericLiteral)ExtUtil.read(in, new ExtWrapNullable(new ExtWrapTagged()), pf);
        this.randomSeedPathExpr = (XPathPathExpr)ExtUtil.read(in, new ExtWrapNullable(new ExtWrapTagged()), pf);
    }

    @Override
    public void writeExternal(DataOutputStream out) throws IOException {
        ExtUtil.write(out, new ExtWrapTagged(this.nodesetExpr));
        ExtUtil.write(out, this.contextRef);
        ExtUtil.write(out, new ExtWrapTagged(this.labelExpr));
        ExtUtil.write(out, new ExtWrapNullable(this.valueExpr == null ? null : new ExtWrapTagged(this.valueExpr)));
        ExtUtil.write(out, new ExtWrapNullable(this.copyExpr == null ? null : new ExtWrapTagged(this.copyExpr)));
        ExtUtil.writeBool(out, this.labelIsItext);
        ExtUtil.writeBool(out, this.copyMode);
        ExtUtil.writeBool(out, this.randomize);
        ExtUtil.write(out, new ExtWrapNullable(this.randomSeedNumericExpr == null ? null : new ExtWrapTagged(this.randomSeedNumericExpr)));
        ExtUtil.write(out, new ExtWrapNullable(this.randomSeedPathExpr == null ? null : new ExtWrapTagged(this.randomSeedPathExpr)));
    }
}

