/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model.instance;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.javarosa.core.util.ArrayUtilities;
import org.javarosa.core.util.CacheTable;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.ExtWrapListPoly;
import org.javarosa.core.util.externalizable.Externalizable;
import org.javarosa.core.util.externalizable.PrototypeFactory;
import org.javarosa.xpath.expr.XPathExpression;

public class TreeReferenceLevel
implements Externalizable,
Serializable {
    public static final int MULT_UNINIT = -16;
    private String name;
    private int multiplicity = -16;
    private List<XPathExpression> predicates;
    private static CacheTable<TreeReferenceLevel> refs;
    public static boolean treeRefLevelInterningEnabled;

    public static void attachCacheTable(CacheTable<TreeReferenceLevel> refs) {
        TreeReferenceLevel.refs = refs;
    }

    public TreeReferenceLevel() {
    }

    public TreeReferenceLevel(String name, int multiplicity, List<XPathExpression> predicates) {
        this.name = name;
        this.multiplicity = multiplicity;
        this.predicates = predicates;
    }

    public TreeReferenceLevel(String name, int multiplicity) {
        this(name, multiplicity, null);
    }

    public int getMultiplicity() {
        return this.multiplicity;
    }

    public String getName() {
        return this.name;
    }

    public TreeReferenceLevel setMultiplicity(int mult) {
        return new TreeReferenceLevel(this.name, mult, this.predicates).intern();
    }

    public TreeReferenceLevel setPredicates(List<XPathExpression> xpe) {
        return new TreeReferenceLevel(this.name, this.multiplicity, xpe).intern();
    }

    public List<XPathExpression> getPredicates() {
        return this.predicates;
    }

    public TreeReferenceLevel shallowCopy() {
        return new TreeReferenceLevel(this.name, this.multiplicity, ArrayUtilities.listCopy(this.predicates)).intern();
    }

    public TreeReferenceLevel setName(String name) {
        return new TreeReferenceLevel(name, this.multiplicity, this.predicates).intern();
    }

    @Override
    public void readExternal(DataInputStream in, PrototypeFactory pf) throws IOException, DeserializationException {
        this.name = ExtUtil.nullIfEmpty(ExtUtil.readString(in));
        this.multiplicity = ExtUtil.readInt(in);
        this.predicates = ExtUtil.nullIfEmpty((List)ExtUtil.read(in, new ExtWrapListPoly()));
    }

    @Override
    public void writeExternal(DataOutputStream out) throws IOException {
        ExtUtil.writeString(out, ExtUtil.emptyIfNull(this.name));
        ExtUtil.writeNumeric(out, this.multiplicity);
        ExtUtil.write(out, new ExtWrapListPoly(ExtUtil.emptyIfNull(this.predicates)));
    }

    public int hashCode() {
        int predPart = 0;
        if (this.predicates != null) {
            for (XPathExpression xpe : this.predicates) {
                predPart ^= xpe.hashCode();
            }
        }
        return this.name.hashCode() ^ this.multiplicity ^ predPart;
    }

    public boolean equals(Object o) {
        if (!(o instanceof TreeReferenceLevel)) {
            return false;
        }
        TreeReferenceLevel l = (TreeReferenceLevel)o;
        if (this.multiplicity != l.multiplicity) {
            return false;
        }
        if (this.name == null && l.name != null) {
            return false;
        }
        if (!this.name.equals(l.name)) {
            return false;
        }
        if (this.predicates == null && l.predicates == null) {
            return true;
        }
        if (this.predicates == null && l.predicates != null || l.predicates == null && this.predicates != null) {
            return false;
        }
        if (this.predicates.size() != l.predicates.size()) {
            return false;
        }
        for (int i = 0; i < this.predicates.size(); ++i) {
            if (this.predicates.get(i).equals(l.predicates.get(i))) continue;
            return false;
        }
        return true;
    }

    public TreeReferenceLevel intern() {
        if (!treeRefLevelInterningEnabled || refs == null) {
            return this;
        }
        return refs.intern(this);
    }

    static {
        treeRefLevelInterningEnabled = true;
    }
}

