/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.form.api;

import org.javarosa.core.model.FormDef;
import org.javarosa.core.model.FormIndex;
import org.javarosa.core.model.GroupDef;
import org.javarosa.core.model.IFormElement;
import org.javarosa.core.model.QuestionDef;
import org.javarosa.core.model.data.IAnswerData;
import org.javarosa.core.model.instance.InvalidReferenceException;
import org.javarosa.core.model.instance.TreeElement;
import org.javarosa.form.api.FormEntryModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormEntryController {
    private static final Logger logger = LoggerFactory.getLogger(FormEntryController.class);
    public static final int ANSWER_OK = 0;
    public static final int ANSWER_REQUIRED_BUT_EMPTY = 1;
    public static final int ANSWER_CONSTRAINT_VIOLATED = 2;
    public static final int EVENT_BEGINNING_OF_FORM = 0;
    public static final int EVENT_END_OF_FORM = 1;
    public static final int EVENT_PROMPT_NEW_REPEAT = 2;
    public static final int EVENT_QUESTION = 4;
    public static final int EVENT_GROUP = 8;
    public static final int EVENT_REPEAT = 16;
    public static final int EVENT_REPEAT_JUNCTURE = 32;
    FormEntryModel model;

    public FormEntryController(FormEntryModel model) {
        this.model = model;
    }

    public FormEntryModel getModel() {
        return this.model;
    }

    public int answerQuestion(IAnswerData data, boolean midSurvey) {
        return this.answerQuestion(this.model.getFormIndex(), data, midSurvey);
    }

    public int answerQuestion(FormIndex index, IAnswerData data, boolean midSurvey) {
        QuestionDef q = this.model.getQuestionPrompt(index).getQuestion();
        if (this.model.getEvent(index) != 4) {
            throw new RuntimeException("Non-Question object at the form index.");
        }
        TreeElement element = this.model.getTreeElement(index);
        boolean complexQuestion = q.isComplex();
        boolean hasConstraints = false;
        if (element.isRequired() && data == null) {
            return 1;
        }
        if (!complexQuestion && !this.model.getForm().evaluateConstraint(index.getReference(), data)) {
            return 2;
        }
        if (!complexQuestion) {
            this.commitAnswer(element, index, data, midSurvey);
            return 0;
        }
        if (complexQuestion && hasConstraints) {
            throw new RuntimeException("Itemsets do not currently evaluate constraints. Your constraint will not work, please remove it before proceeding.");
        }
        try {
            this.model.getForm().copyItemsetAnswer(q, element, data);
        }
        catch (InvalidReferenceException ire) {
            logger.error("Error", (Throwable)ire);
            throw new RuntimeException("Invalid reference while copying itemset answer: " + ire.getMessage());
        }
        return 0;
    }

    public boolean saveAnswer(FormIndex index, IAnswerData data, boolean midSurvey) {
        if (this.model.getEvent(index) != 4) {
            throw new RuntimeException("Non-Question object at the form index.");
        }
        TreeElement element = this.model.getTreeElement(index);
        return this.commitAnswer(element, index, data, midSurvey);
    }

    public boolean saveAnswer(IAnswerData data, boolean midSurvey) {
        return this.saveAnswer(this.model.getFormIndex(), data, midSurvey);
    }

    private boolean commitAnswer(TreeElement element, FormIndex index, IAnswerData data, boolean midSurvey) {
        if (data != null || element.getValue() != null) {
            this.model.getForm().setValue(data, index.getReference(), element, midSurvey);
            return true;
        }
        return false;
    }

    public int stepToNextEvent() {
        return this.stepEvent(true);
    }

    public int stepToPreviousEvent() {
        return this.stepEvent(false);
    }

    private int stepEvent(boolean forward) {
        FormIndex index = this.model.getFormIndex();
        while ((index = forward ? this.model.incrementIndex(index) : this.model.decrementIndex(index)).isInForm() && !this.model.isIndexRelevant(index)) {
        }
        return this.jumpToIndex(index);
    }

    public int jumpToIndex(FormIndex index) {
        this.model.setQuestionIndex(index);
        return this.model.getEvent(index);
    }

    public FormIndex descendIntoRepeat(int n) {
        this.jumpToIndex(this.model.getForm().descendIntoRepeat(this.model.getFormIndex(), n));
        return this.model.getFormIndex();
    }

    public FormIndex descendIntoNewRepeat() {
        this.jumpToIndex(this.model.getForm().descendIntoRepeat(this.model.getFormIndex(), -1));
        this.newRepeat(this.model.getFormIndex());
        return this.model.getFormIndex();
    }

    public void newRepeat(FormIndex questionIndex) {
        try {
            this.model.getForm().createNewRepeat(questionIndex);
        }
        catch (InvalidReferenceException ire) {
            throw new RuntimeException("Invalid reference while copying itemset answer: " + ire.getMessage());
        }
    }

    public void newRepeat() {
        this.newRepeat(this.model.getFormIndex());
    }

    public FormIndex deleteRepeat(FormIndex questionIndex) {
        return this.model.getForm().deleteRepeat(questionIndex);
    }

    public FormIndex deleteRepeat() {
        return this.deleteRepeat(this.model.getFormIndex());
    }

    public void deleteRepeat(int n) {
        this.deleteRepeat(this.model.getForm().descendIntoRepeat(this.model.getFormIndex(), n));
    }

    public void setLanguage(String language) {
        this.model.setLanguage(language);
    }

    public void jumpToNewRepeatPrompt() {
        FormIndex repeatIndex = FormEntryController.getRepeatGroupIndex(this.getModel().getFormIndex(), this.getModel().getForm());
        if (repeatIndex == null) {
            return;
        }
        int repeatDepth = repeatIndex.getDepth();
        do {
            this.stepToNextEvent();
        } while (this.getModel().getEvent() != 2 || this.getModel().getFormIndex().getDepth() != repeatDepth);
    }

    private static FormIndex getRepeatGroupIndex(FormIndex index, FormDef formDef) {
        IFormElement element = formDef.getChild(index);
        if (element instanceof GroupDef && ((GroupDef)element).getRepeat()) {
            return index;
        }
        if (index.getPreviousLevel() != null) {
            return FormEntryController.getRepeatGroupIndex(index.getPreviousLevel(), formDef);
        }
        return null;
    }
}

