/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model.instance.geojson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.javarosa.core.model.instance.TreeElement;
import org.javarosa.core.model.instance.geojson.GeojsonFeature;

public class GeoJsonExternalInstance {
    public static TreeElement parse(String instanceId, String path) throws IOException {
        TreeElement root = new TreeElement("root", 0);
        root.setInstanceName(instanceId);
        ObjectMapper objectMapper = new ObjectMapper();
        try (JsonParser jsonParser = objectMapper.getFactory().createParser((InputStream)new FileInputStream(path));){
            GeoJsonExternalInstance.validatePreamble(jsonParser);
            int multiplicity = 0;
            while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                GeojsonFeature feature = (GeojsonFeature)objectMapper.readValue(jsonParser, GeojsonFeature.class);
                root.addChild(feature.toTreeElement(multiplicity));
                ++multiplicity;
            }
        }
        return root;
    }

    private static void validatePreamble(JsonParser jsonParser) throws IOException {
        if (jsonParser.nextToken() != JsonToken.START_OBJECT) {
            throw new IOException("GeoJSON file must contain a top-level Object");
        }
        jsonParser.nextToken();
        String propertyName = jsonParser.getCurrentName();
        jsonParser.nextToken();
        if (!propertyName.equals("type") || !jsonParser.getValueAsString().equals("FeatureCollection")) {
            throw new IOException("GeoJSON file must contain a top-level FeatureCollection");
        }
        jsonParser.nextToken();
        propertyName = jsonParser.getCurrentName();
        if (!propertyName.equals("features") || jsonParser.nextToken() != JsonToken.START_ARRAY) {
            throw new IOException("GeoJSON FeatureCollection must contain an array of features");
        }
    }
}

