/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.form.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.javarosa.core.model.FormDef;
import org.javarosa.core.model.FormIndex;
import org.javarosa.core.model.GroupDef;
import org.javarosa.core.model.IFormElement;
import org.javarosa.core.model.QuestionDef;
import org.javarosa.core.model.data.IAnswerData;
import org.javarosa.core.model.instance.FormInstance;
import org.javarosa.core.model.instance.InvalidReferenceException;
import org.javarosa.core.model.instance.TreeElement;
import org.javarosa.core.model.instance.TreeReference;
import org.javarosa.form.api.FormEntryCaption;
import org.javarosa.form.api.FormEntryPrompt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormEntryModel {
    private static final Logger logger = LoggerFactory.getLogger(FormEntryModel.class);
    private FormDef form;
    private FormIndex currentFormIndex;
    private int repeatStructure = -1;
    public static final int REPEAT_STRUCTURE_LINEAR = 1;
    public static final int REPEAT_STRUCTURE_NON_LINEAR = 2;

    public FormEntryModel(FormDef form) {
        this(form, 1);
    }

    public FormEntryModel(FormDef form, int repeatStructure) {
        this.form = form;
        if (repeatStructure != 1 && repeatStructure != 2) {
            throw new IllegalArgumentException(repeatStructure + ": does not correspond to a valid repeat structure");
        }
        if (repeatStructure == 2 && this.containsRepeatGuesses(form)) {
            repeatStructure = 1;
        }
        this.repeatStructure = repeatStructure;
        this.currentFormIndex = FormIndex.createBeginningOfFormIndex();
    }

    public int getEvent(FormIndex index) {
        if (index.isBeginningOfFormIndex()) {
            return 0;
        }
        if (index.isEndOfFormIndex()) {
            return 1;
        }
        IFormElement element = this.form.getChild(index);
        if (element instanceof GroupDef) {
            if (((GroupDef)element).getRepeat()) {
                if (this.repeatStructure != 2 && this.form.getMainInstance().resolveReference(this.form.getChildInstanceRef(index)) == null) {
                    return 2;
                }
                if (this.repeatStructure == 2 && index.getElementMultiplicity() == -10) {
                    return 32;
                }
                return 16;
            }
            return 8;
        }
        return 4;
    }

    protected TreeElement getTreeElement(FormIndex index) {
        return (TreeElement)this.form.getMainInstance().resolveReference(index.getReference());
    }

    public int getEvent() {
        return this.getEvent(this.currentFormIndex);
    }

    public String getFormTitle() {
        return this.form.getTitle();
    }

    public FormEntryPrompt getQuestionPrompt(FormIndex index) {
        if (this.form.getChild(index) instanceof QuestionDef) {
            return new FormEntryPrompt(this.form, index);
        }
        throw new RuntimeException("Invalid query for Question prompt. Non-Question object at the form index");
    }

    public FormEntryPrompt getQuestionPrompt() {
        return this.getQuestionPrompt(this.currentFormIndex);
    }

    public FormEntryCaption getCaptionPrompt(FormIndex index) {
        return new FormEntryCaption(this.form, index);
    }

    public FormEntryCaption getCaptionPrompt() {
        return this.getCaptionPrompt(this.currentFormIndex);
    }

    public String[] getLanguages() {
        if (this.form.getLocalizer() != null) {
            return this.form.getLocalizer().getAvailableLocales();
        }
        return null;
    }

    public int getCompletedRelevantQuestionCount() {
        return 0;
    }

    public int getTotalRelevantQuestionCount() {
        return 0;
    }

    public int getNumQuestions() {
        return this.form.getDeepChildCount();
    }

    public FormIndex getFormIndex() {
        return this.currentFormIndex;
    }

    protected void setLanguage(String language) {
        if (this.form.getLocalizer() != null) {
            this.form.getLocalizer().setLocale(language);
        }
    }

    public String getLanguage() {
        return this.form.getLocalizer().getLocale();
    }

    public void setQuestionIndex(FormIndex index) {
        if (!this.currentFormIndex.equals(index)) {
            this.createModelIfNecessary(index);
            this.currentFormIndex = index;
        }
    }

    public FormDef getForm() {
        return this.form;
    }

    public FormEntryCaption[] getCaptionHierarchy(FormIndex index) {
        ArrayList<FormEntryCaption> captions = new ArrayList<FormEntryCaption>();
        FormIndex remaining = index;
        while (remaining != null) {
            FormIndex localIndex = index.diff(remaining = remaining.getNextLevel());
            IFormElement element = this.form.getChild(localIndex);
            if (element == null) continue;
            FormEntryCaption caption = null;
            if (element instanceof GroupDef) {
                caption = new FormEntryCaption(this.getForm(), localIndex);
            } else if (element instanceof QuestionDef) {
                caption = new FormEntryPrompt(this.getForm(), localIndex);
            }
            if (caption == null) continue;
            captions.add(caption);
        }
        FormEntryCaption[] captionArray = new FormEntryCaption[captions.size()];
        return captions.toArray(captionArray);
    }

    public FormEntryCaption[] getCaptionHierarchy() {
        return this.getCaptionHierarchy(this.currentFormIndex);
    }

    public boolean isIndexReadonly(FormIndex index) {
        boolean isAskNewRepeat;
        if (index.isBeginningOfFormIndex() || index.isEndOfFormIndex()) {
            return true;
        }
        TreeReference ref = this.form.getChildInstanceRef(index);
        boolean bl = isAskNewRepeat = this.getEvent(index) == 2 || this.getEvent(index) == 32;
        if (isAskNewRepeat) {
            return false;
        }
        TreeElement node = (TreeElement)this.form.getMainInstance().resolveReference(ref);
        return !node.isEnabled();
    }

    public boolean isIndexReadonly() {
        return this.isIndexReadonly(this.currentFormIndex);
    }

    public boolean isIndexRelevant(FormIndex index) {
        boolean isRepeatJuncture;
        TreeReference ref = this.form.getChildInstanceRef(index);
        boolean isAskNewRepeat = this.getEvent(index) == 2;
        boolean bl = isRepeatJuncture = this.getEvent(index) == 32;
        if (isAskNewRepeat) {
            if (!this.form.canCreateRepeat(ref, index)) {
                return false;
            }
            return this.form.isRepeatRelevant(ref);
        }
        if (isRepeatJuncture) {
            return this.form.isRepeatRelevant(ref);
        }
        TreeElement node = (TreeElement)this.form.getMainInstance().resolveReference(ref);
        return node != null && node.isRelevant();
    }

    public boolean isIndexRelevant() {
        return this.isIndexRelevant(this.currentFormIndex);
    }

    private void createModelIfNecessary(FormIndex index) {
        GroupDef g;
        IFormElement e;
        if (index.isInForm() && (e = this.getForm().getChild(index)) instanceof GroupDef && (g = (GroupDef)e).getRepeat() && g.getCountReference() != null) {
            TreeReference countRef = FormInstance.unpackReference(g.getCountReference());
            TreeReference contextualized = countRef.contextualize(index.getReference());
            IAnswerData count = ((TreeElement)this.getForm().getMainInstance().resolveReference(contextualized)).getValue();
            if (count != null) {
                long fullcount = ((Integer)count.getValue()).intValue();
                TreeReference ref = this.getForm().getChildInstanceRef(index);
                TreeElement element = (TreeElement)this.getForm().getMainInstance().resolveReference(ref);
                if (element == null && (long)index.getTerminal().getInstanceIndex() < fullcount) {
                    try {
                        this.getForm().createNewRepeat(index);
                    }
                    catch (InvalidReferenceException ire) {
                        logger.error("Error", (Throwable)ire);
                        throw new RuntimeException("Invalid Reference while creating new repeat!" + ire.getMessage());
                    }
                }
            }
        }
    }

    public boolean isIndexCompoundContainer() {
        return this.isIndexCompoundContainer(this.getFormIndex());
    }

    public boolean isIndexCompoundContainer(FormIndex index) {
        FormEntryCaption caption = this.getCaptionPrompt(index);
        return this.getEvent(index) == 8 && caption.getAppearanceHint() != null && caption.getAppearanceHint().toLowerCase(Locale.ENGLISH).equals("full");
    }

    public boolean isIndexCompoundElement() {
        return this.isIndexCompoundElement(this.getFormIndex());
    }

    public boolean isIndexCompoundElement(FormIndex index) {
        FormEntryCaption[] captions;
        if (this.getEvent(index) != 4) {
            return false;
        }
        for (FormEntryCaption caption : captions = this.getCaptionHierarchy(index)) {
            if (!this.isIndexCompoundContainer(caption.getIndex())) continue;
            return true;
        }
        return false;
    }

    public FormIndex[] getCompoundIndices() {
        return this.getCompoundIndices(this.getFormIndex());
    }

    public FormIndex[] getCompoundIndices(FormIndex container) {
        ArrayList<FormIndex> indices = new ArrayList<FormIndex>();
        FormIndex walker = this.incrementIndex(container);
        while (FormIndex.isSubElement(container, walker)) {
            if (this.isIndexRelevant(walker)) {
                indices.add(walker);
            }
            walker = this.incrementIndex(walker);
        }
        FormIndex[] array = new FormIndex[indices.size()];
        for (int i = 0; i < indices.size(); ++i) {
            array[i] = (FormIndex)indices.get(i);
        }
        return array;
    }

    public int getRepeatStructure() {
        return this.repeatStructure;
    }

    public FormIndex incrementIndex(FormIndex index) {
        return this.incrementIndex(index, true);
    }

    public FormIndex incrementIndex(FormIndex index, boolean descend) {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        ArrayList<Integer> multiplicities = new ArrayList<Integer>();
        ArrayList<IFormElement> elements = new ArrayList<IFormElement>();
        if (index.isEndOfFormIndex()) {
            return index;
        }
        if (index.isBeginningOfFormIndex()) {
            if (this.form.getChildren() == null || this.form.getChildren().size() == 0) {
                return FormIndex.createEndOfFormIndex();
            }
        } else {
            this.form.collapseIndex(index, indexes, multiplicities, elements);
        }
        this.incrementHelper(indexes, multiplicities, elements, descend);
        if (indexes.size() == 0) {
            return FormIndex.createEndOfFormIndex();
        }
        return this.form.buildIndex(indexes, multiplicities, elements);
    }

    private void incrementHelper(List<Integer> indexes, List<Integer> multiplicities, List<IFormElement> elements, boolean descend) {
        int i = indexes.size() - 1;
        boolean exitRepeat = false;
        if (i == -1 || elements.get(i) instanceof GroupDef) {
            GroupDef group;
            if (i >= 0 && (group = (GroupDef)elements.get(i)).getRepeat()) {
                if (this.repeatStructure == 2) {
                    if (multiplicities.get(multiplicities.size() - 1) == -10) {
                        descend = false;
                        exitRepeat = true;
                    }
                } else if (this.form.getMainInstance().resolveReference(this.form.getChildInstanceRef(elements, multiplicities)) == null) {
                    descend = false;
                    exitRepeat = true;
                }
            }
            if (descend) {
                IFormElement ife;
                IFormElement iFormElement = ife = i == -1 ? null : elements.get(i);
                if (i == -1 || ife != null && ife.getChildren() != null && ife.getChildren().size() > 0) {
                    indexes.add(0);
                    multiplicities.add(0);
                    elements.add((i == -1 ? this.form : elements.get(i)).getChild(0));
                    if (this.repeatStructure == 2 && elements.get(elements.size() - 1) instanceof GroupDef && ((GroupDef)elements.get(elements.size() - 1)).getRepeat()) {
                        multiplicities.set(multiplicities.size() - 1, -10);
                    }
                    return;
                }
            }
        }
        while (i >= 0) {
            if (!exitRepeat && elements.get(i) instanceof GroupDef && ((GroupDef)elements.get(i)).getRepeat()) {
                if (this.repeatStructure == 2) {
                    multiplicities.set(i, -10);
                } else {
                    multiplicities.set(i, multiplicities.get(i) + 1);
                }
                return;
            }
            FormDef parent = i == 0 ? this.form : elements.get(i - 1);
            int curIndex = indexes.get(i);
            if (curIndex + 1 >= parent.getChildren().size()) {
                indexes.remove(i);
                multiplicities.remove(i);
                elements.remove(i);
                --i;
                exitRepeat = false;
                continue;
            }
            indexes.set(i, curIndex + 1);
            multiplicities.set(i, 0);
            elements.set(i, parent.getChild(curIndex + 1));
            if (this.repeatStructure == 2 && elements.get(elements.size() - 1) instanceof GroupDef && ((GroupDef)elements.get(elements.size() - 1)).getRepeat()) {
                multiplicities.set(multiplicities.size() - 1, -10);
            }
            return;
        }
    }

    public FormIndex decrementIndex(FormIndex index) {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        ArrayList<Integer> multiplicities = new ArrayList<Integer>();
        ArrayList<IFormElement> elements = new ArrayList<IFormElement>();
        if (index.isBeginningOfFormIndex()) {
            return index;
        }
        if (index.isEndOfFormIndex()) {
            if (this.form.getChildren() == null || this.form.getChildren().size() == 0) {
                return FormIndex.createBeginningOfFormIndex();
            }
        } else {
            this.form.collapseIndex(index, indexes, multiplicities, elements);
        }
        this.decrementHelper(indexes, multiplicities, elements);
        if (indexes.size() == 0) {
            return FormIndex.createBeginningOfFormIndex();
        }
        return this.form.buildIndex(indexes, multiplicities, elements);
    }

    private void decrementHelper(List<Integer> indexes, List<Integer> multiplicities, List<IFormElement> elements) {
        IFormElement element;
        int i = indexes.size() - 1;
        if (i != -1) {
            int curIndex = indexes.get(i);
            int curMult = multiplicities.get(i);
            if (this.repeatStructure == 2 && elements.get(elements.size() - 1) instanceof GroupDef && ((GroupDef)elements.get(elements.size() - 1)).getRepeat() && multiplicities.get(multiplicities.size() - 1) != -10) {
                multiplicities.set(i, -10);
                return;
            }
            if (this.repeatStructure != 2 && curMult > 0) {
                multiplicities.set(i, curMult - 1);
            } else if (curIndex > 0) {
                indexes.set(i, curIndex - 1);
                multiplicities.set(i, 0);
                elements.set(i, (i == 0 ? this.form : elements.get(i - 1)).getChild(curIndex - 1));
                if (this.setRepeatNextMultiplicity(elements, multiplicities)) {
                    return;
                }
            } else {
                indexes.remove(i);
                multiplicities.remove(i);
                elements.remove(i);
                return;
            }
        }
        IFormElement iFormElement = element = i < 0 ? this.form : elements.get(i);
        while (!(element instanceof QuestionDef)) {
            if (element.getChildren() == null || element.getChildren().size() == 0) {
                return;
            }
            int subIndex = element.getChildren().size() - 1;
            element = element.getChild(subIndex);
            indexes.add(subIndex);
            multiplicities.add(0);
            elements.add(element);
            if (!this.setRepeatNextMultiplicity(elements, multiplicities)) continue;
            return;
        }
    }

    private boolean setRepeatNextMultiplicity(List<IFormElement> elements, List<Integer> multiplicities) {
        TreeReference nodeRef = this.form.getChildInstanceRef(elements, multiplicities);
        TreeElement node = (TreeElement)this.form.getMainInstance().resolveReference(nodeRef);
        if (node == null || node.isRepeatable()) {
            int mult;
            IFormElement lastElement = elements.get(elements.size() - 1);
            if (lastElement instanceof GroupDef && !((GroupDef)lastElement).getRepeat()) {
                return false;
            }
            if (node == null) {
                mult = 0;
            } else {
                String name = node.getName();
                TreeElement parentNode = (TreeElement)this.form.getMainInstance().resolveReference(nodeRef.getParentRef());
                mult = parentNode.getChildMultiplicity(name);
            }
            multiplicities.set(multiplicities.size() - 1, this.repeatStructure == 2 ? -10 : mult);
            return true;
        }
        return false;
    }

    private boolean containsRepeatGuesses(IFormElement parent) {
        GroupDef g;
        if (parent instanceof GroupDef && (g = (GroupDef)parent).getRepeat() && g.getCountReference() != null) {
            return true;
        }
        List<IFormElement> children = parent.getChildren();
        if (children == null) {
            return false;
        }
        for (IFormElement child : children) {
            if (!this.containsRepeatGuesses(child)) continue;
            return true;
        }
        return false;
    }
}

