/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.util.externalizable;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import org.javarosa.core.util.externalizable.CannotCreateObjectException;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.ExtWrapBase;
import org.javarosa.core.util.externalizable.ExtWrapIntEncodingSmall;
import org.javarosa.core.util.externalizable.ExtWrapIntEncodingUniform;
import org.javarosa.core.util.externalizable.ExtWrapList;
import org.javarosa.core.util.externalizable.ExtWrapListPoly;
import org.javarosa.core.util.externalizable.ExtWrapMap;
import org.javarosa.core.util.externalizable.ExtWrapMapPoly;
import org.javarosa.core.util.externalizable.ExtWrapNullable;
import org.javarosa.core.util.externalizable.ExternalizableWrapper;
import org.javarosa.core.util.externalizable.PrototypeFactory;

public class ExtWrapTagged
extends ExternalizableWrapper {
    public static final byte[] WRAPPER_TAG = new byte[]{-1, -1, -1, -1};
    public static HashMap<Class, Integer> WRAPPER_CODES = new HashMap();

    public ExtWrapTagged(Object val) {
        if (val == null) {
            throw new NullPointerException();
        }
        if (val instanceof ExtWrapTagged) {
            throw new IllegalArgumentException("Wrapping tagged with tagged is redundant");
        }
        this.val = val;
    }

    public ExtWrapTagged() {
    }

    @Override
    public ExternalizableWrapper clone(Object val) {
        return new ExtWrapTagged(val);
    }

    @Override
    public void readExternal(DataInputStream in, PrototypeFactory pf) throws IOException, DeserializationException {
        ExternalizableWrapper type = ExtWrapTagged.readTag(in, pf);
        this.val = ExtUtil.read(in, type, pf);
    }

    @Override
    public void writeExternal(DataOutputStream out) throws IOException {
        ExtWrapTagged.writeTag(out, this.val);
        ExtUtil.write(out, this.val);
    }

    public static ExternalizableWrapper readTag(DataInputStream in, PrototypeFactory pf) throws IOException, DeserializationException {
        byte[] tag = new byte[4];
        in.read(tag, 0, tag.length);
        if (PrototypeFactory.compareHash(tag, WRAPPER_TAG)) {
            int wrapperCode = ExtUtil.readInt(in);
            ExternalizableWrapper type = null;
            for (Class key : WRAPPER_CODES.keySet()) {
                Class t = key;
                if (WRAPPER_CODES.get(t) != wrapperCode) continue;
                try {
                    type = (ExternalizableWrapper)PrototypeFactory.getInstance(t);
                }
                catch (CannotCreateObjectException ccoe) {
                    throw new CannotCreateObjectException("Serious problem: cannot create built-in ExternalizableWrapper [" + t.getName() + "]");
                }
            }
            if (type == null) {
                throw new DeserializationException("Unrecognized ExternalizableWrapper type [" + wrapperCode + "]");
            }
            type.metaReadExternal(in, pf);
            return type;
        }
        Class type = pf.getClass(tag);
        if (type == null) {
            throw new DeserializationException("No datatype registered to serialization code " + ExtUtil.printBytes(tag));
        }
        return new ExtWrapBase(type);
    }

    public static void writeTag(DataOutputStream out, Object o) throws IOException {
        if (o instanceof ExternalizableWrapper && !(o instanceof ExtWrapBase)) {
            out.write(WRAPPER_TAG, 0, 4);
            ExtUtil.writeNumeric(out, WRAPPER_CODES.get(o.getClass()).intValue());
            ((ExternalizableWrapper)o).metaWriteExternal(out);
        } else {
            Class type = null;
            if (o instanceof ExtWrapBase) {
                ExtWrapBase extType = (ExtWrapBase)o;
                if (extType.val != null) {
                    o = extType.val;
                } else {
                    type = extType.type;
                }
            }
            if (type == null) {
                type = o.getClass();
            }
            byte[] tag = PrototypeFactory.getClassHash(type);
            out.write(tag, 0, tag.length);
        }
    }

    @Override
    public void metaReadExternal(DataInputStream in, PrototypeFactory pf) {
        throw new RuntimeException("Tagged wrapper should never be tagged");
    }

    @Override
    public void metaWriteExternal(DataOutputStream out) {
        throw new RuntimeException("Tagged wrapper should never be tagged");
    }

    static {
        WRAPPER_CODES.put(ExtWrapNullable.class, 0);
        WRAPPER_CODES.put(ExtWrapList.class, 32);
        WRAPPER_CODES.put(ExtWrapListPoly.class, 33);
        WRAPPER_CODES.put(ExtWrapMap.class, 34);
        WRAPPER_CODES.put(ExtWrapMapPoly.class, 35);
        WRAPPER_CODES.put(ExtWrapIntEncodingUniform.class, 64);
        WRAPPER_CODES.put(ExtWrapIntEncodingSmall.class, 65);
    }
}

