/*
 * Copyright 2017 Nafundi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.javarosa.core.util;

/**
 * Helps with timing an operation and logging the time
 */
public class StopWatch {
    private final long startTime;

    private StopWatch(long startTime) {
        this.startTime = startTime;
    }

    public static StopWatch start() {
        return new StopWatch(System.nanoTime());
    }

    /**
     * Builds a timer log line and returns it
     *
     * @param operation
     * @return a string containing the log line
     */
    public String logLine(String operation) {
        return String.format("%s finished in %.3f ms", operation, (System.nanoTime() - startTime) / 1e6);
    }
}
