/*
 * Copyright (C) 2009 JavaRosa
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package org.javarosa.core.util;

import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;

public class OrderedMap<K,V> extends LinkedHashMap<K,V> {

    public String toString () {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (Enumeration e = Collections.enumeration(keySet()); e.hasMoreElements(); ) {
            Object key = e.nextElement();
            sb.append(key.toString());
            sb.append(" => ");
            sb.append(get(key).toString());
            if (e.hasMoreElements())
                sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }
}
