/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model.instance.utils;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.javarosa.core.model.instance.FormInstance;
import org.javarosa.core.model.utils.IInstanceSerializingVisitor;
import org.javarosa.core.services.storage.IStorageUtility;
import org.javarosa.core.services.storage.StorageManager;
import org.javarosa.core.services.transport.payload.IDataPayload;
import org.javarosa.core.services.transport.payload.IDataPayloadVisitor;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.Externalizable;
import org.javarosa.core.util.externalizable.PrototypeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelReferencePayload
implements IDataPayload {
    private static final Logger logger = LoggerFactory.getLogger(ModelReferencePayload.class);
    int recordId;
    IDataPayload payload;
    String destination = null;
    IInstanceSerializingVisitor serializer;

    public ModelReferencePayload() {
    }

    public ModelReferencePayload(int modelRecordId) {
        this.recordId = modelRecordId;
    }

    public void setSerializer(IInstanceSerializingVisitor serializer) {
        this.serializer = serializer;
    }

    @Override
    public <T> T accept(IDataPayloadVisitor<T> visitor) {
        this.memoize();
        return this.payload.accept(visitor);
    }

    @Override
    public long getLength() {
        this.memoize();
        return this.payload.getLength();
    }

    @Override
    public String getPayloadId() {
        this.memoize();
        return this.payload.getPayloadId();
    }

    @Override
    public InputStream getPayloadStream() throws IOException {
        this.memoize();
        return this.payload.getPayloadStream();
    }

    @Override
    public int getPayloadType() {
        this.memoize();
        return this.payload.getPayloadType();
    }

    @Override
    public void readExternal(DataInputStream in, PrototypeFactory pf) throws IOException, DeserializationException {
        this.recordId = in.readInt();
    }

    @Override
    public void writeExternal(DataOutputStream out) throws IOException {
        out.writeInt(this.recordId);
    }

    private void memoize() {
        if (this.payload == null) {
            IStorageUtility<? extends Externalizable> instances = StorageManager.getStorage("FORMDATA");
            try {
                FormInstance tree = (FormInstance)instances.read(this.recordId);
                this.payload = this.serializer.createSerializedPayload(tree);
            }
            catch (IOException e) {
                logger.error("Error", (Throwable)e);
                throw new RuntimeException("ModelReferencePayload failed to retrieve its model from rms [" + e.getMessage() + "]");
            }
        }
    }

    @Override
    public int getTransportId() {
        return this.recordId;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public String getDestination() {
        return this.destination;
    }
}

