/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.xpath.expr;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.javarosa.xpath.XPathUnsupportedException;

enum Encoding {
    HEX("hex"){

        @Override
        String encode(byte[] bytes) {
            StringBuilder sb = new StringBuilder(bytes.length * 2);
            for (byte b : bytes) {
                sb.append(HEX_TBL[b >> 4 & 0xF]);
                sb.append(HEX_TBL[b & 0xF]);
            }
            return sb.toString();
        }

        @Override
        byte[] decode(byte[] bytes) {
            int len = bytes.length;
            byte[] data = new byte[len / 2];
            for (int i = 0; i < len; i += 2) {
                data[i / 2] = (byte)((Character.digit(bytes[i], 16) << 4) + Character.digit(bytes[i + 1], 16));
            }
            return data;
        }
    }
    ,
    BASE64("base64"){

        @Override
        String encode(byte[] sArr) {
            int sLen = sArr.length;
            int sOff = 0;
            if (sLen == 0) {
                return "";
            }
            int eLen = sLen / 3 * 3;
            int dLen = (sLen - 1) / 3 + 1 << 2;
            byte[] dArr = new byte[dLen];
            int s = sOff;
            int d = 0;
            while (s < sOff + eLen) {
                int i = (sArr[s++] & 0xFF) << 16 | (sArr[s++] & 0xFF) << 8 | sArr[s++] & 0xFF;
                dArr[d++] = (byte)BASE_64_TBL[i >>> 18 & 0x3F];
                dArr[d++] = (byte)BASE_64_TBL[i >>> 12 & 0x3F];
                dArr[d++] = (byte)BASE_64_TBL[i >>> 6 & 0x3F];
                dArr[d++] = (byte)BASE_64_TBL[i & 0x3F];
            }
            int left = sLen - eLen;
            if (left > 0) {
                int i = (sArr[sOff + eLen] & 0xFF) << 10 | (left == 2 ? (sArr[sOff + sLen - 1] & 0xFF) << 2 : 0);
                dArr[dLen - 4] = (byte)BASE_64_TBL[i >> 12];
                dArr[dLen - 3] = (byte)BASE_64_TBL[i >>> 6 & 0x3F];
                dArr[dLen - 2] = left == 2 ? (int)BASE_64_TBL[i & 0x3F] : 61;
                dArr[dLen - 1] = 61;
            }
            return new String(dArr, StandardCharsets.UTF_8);
        }

        @Override
        public byte[] decode(byte[] sArr) {
            int sepCnt = 0;
            for (byte b : sArr) {
                if (IA[b & 0xFF] >= 0) continue;
                ++sepCnt;
            }
            if ((sArr.length - sepCnt) % 4 != 0) {
                return new byte[0];
            }
            int pad = 0;
            int i = sArr.length;
            while (i > 1 && IA[sArr[--i] & 0xFF] <= 0) {
                if (sArr[i] != 61) continue;
                ++pad;
            }
            int len = ((sArr.length - sepCnt) * 6 >> 3) - pad;
            byte[] dArr = new byte[len];
            int s = 0;
            int d = 0;
            while (d < len) {
                int i2 = 0;
                for (int j = 0; j < 4; ++j) {
                    int c = IA[sArr[s++] & 0xFF];
                    if (c >= 0) {
                        i2 |= c << 18 - j * 6;
                        continue;
                    }
                    --j;
                }
                dArr[d++] = (byte)(i2 >> 16);
                if (d >= len) continue;
                dArr[d++] = (byte)(i2 >> 8);
                if (d >= len) continue;
                dArr[d++] = (byte)i2;
            }
            return dArr;
        }
    };

    private final String name;
    private static final char[] HEX_TBL;
    private static final char[] BASE_64_TBL;
    private static final int[] IA;

    private Encoding(String name) {
        this.name = name;
    }

    static Encoding from(String name) {
        try {
            return Encoding.valueOf(name.toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            throw new XPathUnsupportedException("digest(..., ..., '" + name + "')");
        }
    }

    abstract String encode(byte[] var1);

    abstract byte[] decode(byte[] var1);

    static {
        HEX_TBL = "0123456789abcdef".toCharArray();
        BASE_64_TBL = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
        IA = new int[256];
        Arrays.fill(IA, -1);
        int iS = BASE_64_TBL.length;
        for (int i = 0; i < iS; ++i) {
            Encoding.IA[Encoding.BASE_64_TBL[i]] = i;
        }
        Encoding.IA[61] = 0;
    }
}

