/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.xpath.parser.ast;

import java.util.Vector;
import org.javarosa.xpath.expr.XPathArithExpr;
import org.javarosa.xpath.expr.XPathBinaryOpExpr;
import org.javarosa.xpath.expr.XPathBoolExpr;
import org.javarosa.xpath.expr.XPathCmpExpr;
import org.javarosa.xpath.expr.XPathEqExpr;
import org.javarosa.xpath.expr.XPathExpression;
import org.javarosa.xpath.expr.XPathUnionExpr;
import org.javarosa.xpath.parser.Parser;
import org.javarosa.xpath.parser.XPathSyntaxException;
import org.javarosa.xpath.parser.ast.ASTNode;

public class ASTNodeBinaryOp
extends ASTNode {
    public static final int ASSOC_LEFT = 1;
    public static final int ASSOC_RIGHT = 2;
    public int associativity;
    public Vector<ASTNode> exprs = new Vector();
    public Vector<Integer> ops = new Vector();

    @Override
    public Vector<ASTNode> getChildren() {
        return this.exprs;
    }

    @Override
    public XPathExpression build() throws XPathSyntaxException {
        XPathExpression x;
        if (this.associativity == 1) {
            x = this.exprs.elementAt(0).build();
            for (int i = 1; i < this.exprs.size(); ++i) {
                x = this.getBinOpExpr(Parser.vectInt(this.ops, i - 1), x, this.exprs.elementAt(i).build());
            }
        } else {
            x = this.exprs.elementAt(this.exprs.size() - 1).build();
            for (int i = this.exprs.size() - 2; i >= 0; --i) {
                x = this.getBinOpExpr(Parser.vectInt(this.ops, i), this.exprs.elementAt(i).build(), x);
            }
        }
        return x;
    }

    private XPathBinaryOpExpr getBinOpExpr(int op, XPathExpression a, XPathExpression b) throws XPathSyntaxException {
        switch (op) {
            case 22: {
                return new XPathBoolExpr(1, a, b);
            }
            case 1: {
                return new XPathBoolExpr(0, a, b);
            }
            case 9: {
                return new XPathEqExpr(true, a, b);
            }
            case 19: {
                return new XPathEqExpr(false, a, b);
            }
            case 14: {
                return new XPathCmpExpr(0, a, b);
            }
            case 15: {
                return new XPathCmpExpr(2, a, b);
            }
            case 10: {
                return new XPathCmpExpr(1, a, b);
            }
            case 11: {
                return new XPathCmpExpr(3, a, b);
            }
            case 23: {
                return new XPathArithExpr(0, a, b);
            }
            case 16: {
                return new XPathArithExpr(1, a, b);
            }
            case 18: {
                return new XPathArithExpr(2, a, b);
            }
            case 7: {
                return new XPathArithExpr(3, a, b);
            }
            case 17: {
                return new XPathArithExpr(4, a, b);
            }
            case 30: {
                return new XPathUnionExpr(a, b);
            }
        }
        throw new XPathSyntaxException();
    }
}

