/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model;

import java.util.Arrays;
import java.util.LinkedList;
import kotlin.Pair;
import org.javarosa.core.model.condition.EvaluationContext;
import org.javarosa.core.model.instance.DataInstance;
import org.javarosa.core.model.instance.TreeReference;
import org.javarosa.xpath.expr.XPathCmpExpr;
import org.javarosa.xpath.expr.XPathEqExpr;
import org.javarosa.xpath.expr.XPathExpression;
import org.javarosa.xpath.expr.XPathNumericLiteral;
import org.javarosa.xpath.expr.XPathPathExpr;
import org.javarosa.xpath.expr.XPathStringLiteral;
import org.jetbrains.annotations.Nullable;

public class CompareChildToAbsoluteExpression {
    private final XPathPathExpr relativeSide;
    private final XPathExpression absoluteSide;
    private final XPathExpression original;

    public CompareChildToAbsoluteExpression(XPathPathExpr relativeSide, XPathExpression absoluteSide, XPathExpression original) {
        this.relativeSide = relativeSide;
        this.absoluteSide = absoluteSide;
        this.original = original;
    }

    public Object evalRelative(DataInstance sourceInstance, EvaluationContext evaluationContext, TreeReference child, int childIndex) {
        EvaluationContext rescopedContext = evaluationContext.rescope(child, childIndex);
        return this.getRelativeSide().eval(sourceInstance, rescopedContext).unpack();
    }

    public Object evalAbsolute(DataInstance sourceInstance, EvaluationContext evaluationContext) {
        if (this.absoluteSide instanceof XPathPathExpr) {
            return ((XPathPathExpr)this.getAbsoluteSide()).eval(sourceInstance, evaluationContext).unpack();
        }
        return this.absoluteSide.eval(sourceInstance, evaluationContext);
    }

    public XPathPathExpr getRelativeSide() {
        return this.relativeSide;
    }

    public XPathExpression getAbsoluteSide() {
        return this.absoluteSide;
    }

    public XPathExpression getOriginal() {
        return this.original;
    }

    @Nullable
    public static CompareChildToAbsoluteExpression parse(XPathExpression expression) {
        XPathExpression a = null;
        XPathExpression b = null;
        if (expression instanceof XPathCmpExpr) {
            a = ((XPathCmpExpr)expression).a;
            b = ((XPathCmpExpr)expression).b;
        } else if (expression instanceof XPathEqExpr) {
            a = ((XPathEqExpr)expression).a;
            b = ((XPathEqExpr)expression).b;
        }
        Pair<XPathPathExpr, XPathExpression> relativeAndAbsolute = CompareChildToAbsoluteExpression.getRelativeAndAbsolute(a, b);
        if (relativeAndAbsolute != null) {
            return new CompareChildToAbsoluteExpression((XPathPathExpr)relativeAndAbsolute.getFirst(), (XPathExpression)relativeAndAbsolute.getSecond(), expression);
        }
        return null;
    }

    private static Pair<XPathPathExpr, XPathExpression> getRelativeAndAbsolute(XPathExpression a, XPathExpression b) {
        XPathPathExpr relative = null;
        XPathExpression absolute = null;
        LinkedList<XPathExpression> subExpressions = new LinkedList<XPathExpression>(Arrays.asList(a, b));
        while (!subExpressions.isEmpty()) {
            XPathExpression subExpression = (XPathExpression)subExpressions.poll();
            if (subExpression instanceof XPathPathExpr && ((XPathPathExpr)subExpression).init_context == 1) {
                relative = (XPathPathExpr)subExpression;
                continue;
            }
            if (subExpression instanceof XPathPathExpr && ((XPathPathExpr)subExpression).init_context == 0) {
                absolute = subExpression;
                continue;
            }
            if (!(subExpression instanceof XPathNumericLiteral) && !(subExpression instanceof XPathStringLiteral)) continue;
            absolute = subExpression;
        }
        if (relative != null && absolute != null) {
            return new Pair(relative, absolute);
        }
        return null;
    }
}

