/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.javarosa.core.model.CompareChildToAbsoluteExpression;
import org.javarosa.core.model.condition.EvaluationContext;
import org.javarosa.core.model.condition.FilterStrategy;
import org.javarosa.core.model.instance.DataInstance;
import org.javarosa.core.model.instance.TreeReference;
import org.javarosa.measure.Measure;
import org.javarosa.xpath.expr.XPathEqExpr;
import org.javarosa.xpath.expr.XPathExpression;
import org.jetbrains.annotations.NotNull;

public class EqualityExpressionIndexFilterStrategy
implements FilterStrategy {
    private final InMemTreeReferenceIndex index = new InMemTreeReferenceIndex();

    @Override
    @NotNull
    public List<TreeReference> filter(@NotNull DataInstance sourceInstance, @NotNull TreeReference nodeSet, @NotNull XPathExpression predicate, @NotNull List<TreeReference> children, @NotNull EvaluationContext evaluationContext, @NotNull Supplier<List<TreeReference>> next) {
        if (sourceInstance.getInstanceId() == null || !(predicate instanceof XPathEqExpr)) {
            return next.get();
        }
        CompareChildToAbsoluteExpression candidate = CompareChildToAbsoluteExpression.parse(predicate);
        if (candidate != null) {
            XPathEqExpr original = (XPathEqExpr)candidate.getOriginal();
            if (original.isEqual()) {
                String section = sourceInstance.getInstanceId() + nodeSet + candidate.getRelativeSide().toString();
                if (!this.index.contains(section)) {
                    this.buildIndex(sourceInstance, candidate, children, evaluationContext, section);
                }
                Object absoluteValue = candidate.evalAbsolute(sourceInstance, evaluationContext);
                return this.index.lookup(section, absoluteValue.toString());
            }
            return next.get();
        }
        return next.get();
    }

    private void buildIndex(DataInstance sourceInstance, CompareChildToAbsoluteExpression predicate, List<TreeReference> children, EvaluationContext evaluationContext, String section) {
        for (int i = 0; i < children.size(); ++i) {
            TreeReference child = children.get(i);
            Measure.log("IndexEvaluation");
            String relativeValue = predicate.evalRelative(sourceInstance, evaluationContext, child, i).toString();
            this.index.add(section, relativeValue, child);
        }
    }

    private static class InMemTreeReferenceIndex {
        private final Map<String, Map<String, List<TreeReference>>> map = new HashMap<String, Map<String, List<TreeReference>>>();

        private InMemTreeReferenceIndex() {
        }

        public boolean contains(String section) {
            return this.map.containsKey(section);
        }

        public void add(String section, String key, TreeReference reference) {
            Map<String, List<TreeReference>> sectionMap;
            if (!this.map.containsKey(section)) {
                this.map.put(section, new HashMap());
            }
            if (!(sectionMap = this.map.get(section)).containsKey(key)) {
                sectionMap.put(key, new ArrayList());
            }
            sectionMap.get(key).add(reference);
        }

        public List<TreeReference> lookup(String section, String key) {
            if (this.map.containsKey(section) && this.map.get(section).containsKey(key)) {
                return this.map.get(section).get(key);
            }
            return Collections.emptyList();
        }
    }
}

