/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.xform.parse;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kotlin.Pair;
import org.javarosa.core.model.DataBinding;
import org.javarosa.core.model.FormDef;
import org.javarosa.core.model.IDataReference;
import org.javarosa.core.model.condition.ConditionAction;
import org.javarosa.core.model.condition.Triggerable;
import org.javarosa.core.model.instance.FormInstance;
import org.javarosa.model.xform.XPathReference;
import org.javarosa.xform.parse.IXFormParserFunctions;
import org.javarosa.xform.parse.XFormParseException;
import org.javarosa.xform.parse.XFormParser;
import org.javarosa.xpath.XPathConditional;
import org.javarosa.xpath.XPathException;
import org.javarosa.xpath.parser.XPathSyntaxException;
import org.kxml2.kdom.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StandardBindAttributesProcessor {
    private static final Logger logger = LoggerFactory.getLogger(StandardBindAttributesProcessor.class);
    private Map<String, Integer> typeMappings;

    StandardBindAttributesProcessor(Map<String, Integer> typeMappings) {
        this.typeMappings = typeMappings;
    }

    DataBinding createBinding(IXFormParserFunctions parserFunctions, FormDef formDef, Collection<String> usedAttributes, Collection<String> passedThroughAttributes, Element element, List<XFormParser.BindAttributeProcessor> bindAttributeProcessors) {
        String xpathCalc;
        String xpathConstr;
        String xpathRO;
        String xpathReq;
        IDataReference ref;
        DataBinding binding = new DataBinding();
        binding.setId(element.getAttributeValue("", "id"));
        String nodeset = element.getAttributeValue(null, "nodeset");
        if (nodeset == null) {
            throw new XFormParseException("XForm Parse: <bind> without nodeset", element);
        }
        try {
            ref = new XPathReference(nodeset);
        }
        catch (XPathException xpe) {
            throw new XFormParseException(xpe.getMessage());
        }
        ref = parserFunctions.getAbsRef(ref, formDef);
        binding.setReference(ref);
        binding.setDataType(this.getDataType(element.getAttributeValue(null, "type")));
        String xpathRel = element.getAttributeValue(null, "relevant");
        if (xpathRel != null) {
            if ("true()".equals(xpathRel)) {
                binding.relevantAbsolute = true;
            } else if ("false()".equals(xpathRel)) {
                binding.relevantAbsolute = false;
            } else {
                binding.relevancyCondition = formDef.addTriggerable(this.buildCondition(xpathRel, "relevant", ref));
            }
        }
        if ((xpathReq = element.getAttributeValue(null, "required")) != null) {
            if ("true()".equals(xpathReq)) {
                binding.requiredAbsolute = true;
            } else if ("false()".equals(xpathReq)) {
                binding.requiredAbsolute = false;
            } else {
                binding.requiredCondition = formDef.addTriggerable(this.buildCondition(xpathReq, "required", ref));
            }
        }
        if ((xpathRO = element.getAttributeValue(null, "readonly")) != null) {
            if ("true()".equals(xpathRO)) {
                binding.readonlyAbsolute = true;
            } else if ("false()".equals(xpathRO)) {
                binding.readonlyAbsolute = false;
            } else {
                binding.readonlyCondition = formDef.addTriggerable(this.buildCondition(xpathRO, "readonly", ref));
            }
        }
        if ((xpathConstr = element.getAttributeValue(null, "constraint")) != null) {
            try {
                binding.constraint = new XPathConditional(xpathConstr);
            }
            catch (XPathSyntaxException xse) {
                throw new XFormParseException("bind for " + nodeset + " contains invalid constraint expression [" + xpathConstr + "] " + xse.getMessage());
            }
            binding.constraintMessage = element.getAttributeValue("http://openrosa.org/javarosa", "constraintMsg");
        }
        if ((xpathCalc = element.getAttributeValue(null, "calculate")) != null) {
            try {
                binding.calculate = formDef.addTriggerable(this.buildCalculate(xpathCalc, ref));
            }
            catch (XPathSyntaxException xpse) {
                throw new XFormParseException("Invalid calculate for the bind attached to \"" + nodeset + "\" : " + xpse.getMessage() + " in expression " + xpathCalc);
            }
        }
        binding.setPreload(element.getAttributeValue("http://openrosa.org/javarosa", "preload"));
        binding.setPreloadParams(element.getAttributeValue("http://openrosa.org/javarosa", "preloadParams"));
        bindAttributeProcessors.stream().forEach(bindAttributeProcessor -> {
            for (int i = 0; i < element.getAttributeCount(); ++i) {
                String namespace = element.getAttributeNamespace(i);
                String name = element.getAttributeName(i);
                if (!bindAttributeProcessor.getBindAttributes().contains(new Pair((Object)namespace, (Object)name))) continue;
                bindAttributeProcessor.processBindAttribute(name, element.getAttributeValue(i), binding);
            }
        });
        List processorAttributes = bindAttributeProcessors.stream().flatMap(bindAttributeProcessor -> bindAttributeProcessor.getBindAttributes().stream()).collect(Collectors.toList());
        for (int i = 0; i < element.getAttributeCount(); ++i) {
            boolean usedAttribute;
            String namespace = element.getAttributeNamespace(i);
            String name = element.getAttributeName(i);
            boolean bl = usedAttribute = usedAttributes.contains(name) || processorAttributes.contains(new Pair((Object)namespace, (Object)name));
            if (usedAttribute && !passedThroughAttributes.contains(name)) continue;
            binding.setAdditionalAttribute(element.getAttributeNamespace(i), name, element.getAttributeValue(i));
        }
        return binding;
    }

    private Triggerable buildCondition(String xpath, String type, IDataReference contextRef) {
        XPathConditional xPathConditional;
        ConditionAction falseAction;
        ConditionAction trueAction;
        String prettyType;
        switch (type) {
            case "relevant": {
                prettyType = "display";
                trueAction = ConditionAction.RELEVANT;
                falseAction = ConditionAction.NOT_RELEVANT;
                break;
            }
            case "required": {
                prettyType = "require";
                trueAction = ConditionAction.REQUIRE;
                falseAction = ConditionAction.DONT_REQUIRE;
                break;
            }
            case "readonly": {
                prettyType = "readonly";
                trueAction = ConditionAction.READ_ONLY;
                falseAction = ConditionAction.ENABLE;
                break;
            }
            default: {
                throw new XFormParseException("Unsupported type " + type + " passed to buildCondition");
            }
        }
        try {
            xPathConditional = new XPathConditional(xpath);
        }
        catch (XPathSyntaxException xse) {
            logger.error("XForm Parse Error: Encountered a problem with {} condition for node [{}] at line: {}{}", new Object[]{prettyType, contextRef.getReference().toString(), xpath, xse.getMessage()});
            throw new XFormParseException("Encountered a problem with " + prettyType + " condition for node [" + contextRef.getReference().toString() + "] at line: " + xpath + ", " + xse.getMessage());
        }
        return Triggerable.condition(xPathConditional, trueAction, falseAction, FormInstance.unpackReference(contextRef));
    }

    private Triggerable buildCalculate(String xpath, IDataReference contextRef) throws XPathSyntaxException {
        return Triggerable.recalculate(new XPathConditional(xpath), FormInstance.unpackReference(contextRef));
    }

    private int getDataType(String type) {
        int dataType = 0;
        if (type != null) {
            if (type.contains(":")) {
                type = type.substring(type.indexOf(":") + 1);
            }
            if (this.typeMappings.containsKey(type)) {
                dataType = this.typeMappings.get(type);
            } else {
                dataType = -1;
                logger.warn("XForm Parse Warning: unrecognized data type [{}]", (Object)type);
            }
        }
        return dataType;
    }
}

