/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.xpath;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.javarosa.core.log.FatalException;
import org.javarosa.core.model.condition.EvaluationContext;
import org.javarosa.core.model.condition.IConditionExpr;
import org.javarosa.core.model.condition.pivot.UnpivotableExpressionException;
import org.javarosa.core.model.instance.DataInstance;
import org.javarosa.core.model.instance.TreeReference;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.ExtWrapTagged;
import org.javarosa.core.util.externalizable.PrototypeFactory;
import org.javarosa.xpath.XPathParseTool;
import org.javarosa.xpath.XPathUnsupportedException;
import org.javarosa.xpath.expr.XPathBinaryOpExpr;
import org.javarosa.xpath.expr.XPathExpression;
import org.javarosa.xpath.expr.XPathFuncExpr;
import org.javarosa.xpath.expr.XPathPathExpr;
import org.javarosa.xpath.expr.XPathUnaryOpExpr;
import org.javarosa.xpath.parser.XPathSyntaxException;

public class XPathConditional
implements IConditionExpr {
    private XPathExpression expr;
    public String xpath;
    public boolean hasNow;

    public XPathConditional(String xpath) throws XPathSyntaxException {
        this.hasNow = false;
        if (xpath.indexOf("now()") > -1) {
            this.hasNow = true;
        }
        this.expr = XPathParseTool.parseXPath(xpath);
        this.xpath = xpath;
    }

    public XPathConditional(XPathExpression expr) {
        this.expr = expr;
    }

    public XPathConditional() {
    }

    public XPathExpression getExpr() {
        return this.expr;
    }

    @Override
    public Object evalRaw(DataInstance model, EvaluationContext evalContext) {
        try {
            return XPathFuncExpr.unpack(this.expr.eval(model, evalContext));
        }
        catch (XPathUnsupportedException e) {
            if (this.xpath != null) {
                throw new XPathUnsupportedException(this.xpath);
            }
            throw e;
        }
    }

    @Override
    public boolean eval(DataInstance model, EvaluationContext evalContext) {
        return XPathFuncExpr.toBoolean(this.evalRaw(model, evalContext));
    }

    @Override
    public String evalReadable(DataInstance model, EvaluationContext evalContext) {
        return XPathFuncExpr.toString(this.evalRaw(model, evalContext));
    }

    @Override
    public List<TreeReference> evalNodeset(DataInstance model, EvaluationContext evalContext) {
        if (this.expr instanceof XPathPathExpr) {
            return ((XPathPathExpr)this.expr).eval(model, evalContext).getReferences();
        }
        throw new FatalException("evalNodeset: must be path expression");
    }

    @Override
    public Set<TreeReference> getTriggers(TreeReference contextRef) {
        HashSet<TreeReference> triggers = new HashSet<TreeReference>();
        XPathConditional.getTriggers(this.expr, contextRef, contextRef, triggers);
        return triggers;
    }

    private static void getTriggers(XPathExpression x, TreeReference contextRef, TreeReference originalContext, Set<TreeReference> triggersSoFar) {
        block6: {
            block8: {
                block7: {
                    block5: {
                        TreeReference ref;
                        if (!(x instanceof XPathPathExpr)) break block5;
                        TreeReference contextualized = ref = ((XPathPathExpr)x).getReference();
                        if (contextRef != null || ref.getContextType() == 2 && originalContext != null) {
                            contextualized = ref.contextualize(ref.getContextType() == 2 ? originalContext : contextRef);
                        }
                        triggersSoFar.add(contextualized.removePredicates());
                        for (int i = 0; i < contextualized.size(); ++i) {
                            List<XPathExpression> predicates = contextualized.getPredicate(i);
                            if (predicates == null) continue;
                            if (!contextualized.isAbsolute()) {
                                throw new IllegalArgumentException("can't get triggers for relative references");
                            }
                            TreeReference predicateContext = contextualized.getSubReference(i).removePredicates();
                            for (XPathExpression predicate : predicates) {
                                XPathConditional.getTriggers(predicate, predicateContext, originalContext, triggersSoFar);
                            }
                        }
                        break block6;
                    }
                    if (!(x instanceof XPathBinaryOpExpr)) break block7;
                    XPathConditional.getTriggers(((XPathBinaryOpExpr)x).a, contextRef, originalContext, triggersSoFar);
                    XPathConditional.getTriggers(((XPathBinaryOpExpr)x).b, contextRef, originalContext, triggersSoFar);
                    break block6;
                }
                if (!(x instanceof XPathUnaryOpExpr)) break block8;
                XPathConditional.getTriggers(((XPathUnaryOpExpr)x).a, contextRef, originalContext, triggersSoFar);
                break block6;
            }
            if (!(x instanceof XPathFuncExpr)) break block6;
            XPathFuncExpr fx = (XPathFuncExpr)x;
            for (int i = 0; i < fx.args.length; ++i) {
                XPathConditional.getTriggers(fx.args[i], contextRef, originalContext, triggersSoFar);
            }
        }
    }

    public boolean equals(Object o) {
        if (o instanceof XPathConditional) {
            XPathConditional cond = (XPathConditional)o;
            return this.expr.equals(cond.expr);
        }
        return false;
    }

    @Override
    public void readExternal(DataInputStream in, PrototypeFactory pf) throws IOException, DeserializationException {
        this.expr = (XPathExpression)ExtUtil.read(in, new ExtWrapTagged(), pf);
        this.hasNow = ExtUtil.readBool(in);
    }

    @Override
    public void writeExternal(DataOutputStream out) throws IOException {
        ExtUtil.write(out, new ExtWrapTagged(this.expr));
        ExtUtil.writeBool(out, this.hasNow);
    }

    public String toString() {
        return "xpath[" + this.expr.toString() + "]";
    }

    @Override
    public List<Object> pivot(DataInstance model, EvaluationContext evalContext) throws UnpivotableExpressionException {
        return this.expr.pivot(model, evalContext);
    }
}

