/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.xpath;

import java.util.List;
import org.javarosa.core.model.condition.EvaluationContext;
import org.javarosa.core.model.instance.DataInstance;
import org.javarosa.core.model.instance.TreeReference;
import org.javarosa.xpath.XPathException;
import org.javarosa.xpath.XPathNodeset;
import org.javarosa.xpath.expr.XPathPathExpr;

public class XPathLazyNodeset
extends XPathNodeset {
    Boolean evaluated = Boolean.FALSE;
    TreeReference unExpandedRef;

    public XPathLazyNodeset(TreeReference unExpandedRef, DataInstance instance, EvaluationContext ec) {
        super(instance, ec);
        this.unExpandedRef = unExpandedRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performEvaluation() {
        Boolean bl = this.evaluated;
        synchronized (bl) {
            if (this.evaluated.booleanValue()) {
                return;
            }
            List<TreeReference> nodes = this.ec.expandReference(this.unExpandedRef);
            for (int i = 0; i < nodes.size(); ++i) {
                if (this.instance.resolveReference(nodes.get(i)).isRelevant()) continue;
                nodes.remove(i);
                --i;
            }
            this.setReferences(nodes);
            this.evaluated = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object unpack() {
        Boolean bl = this.evaluated;
        synchronized (bl) {
            if (this.evaluated.booleanValue()) {
                return super.unpack();
            }
            int size = this.unExpandedRef.size();
            boolean safe = true;
            for (int i = 0; i < size; ++i) {
                if (this.unExpandedRef.getPredicate(i) != null) {
                    safe = false;
                    break;
                }
                int mult = this.unExpandedRef.getMultiplicity(i);
                if (mult >= 0 || mult == -1) continue;
                safe = false;
                break;
            }
            if (!safe) {
                this.performEvaluation();
                return super.unpack();
            }
            try {
                return XPathPathExpr.getRefValue(this.instance, this.ec, this.unExpandedRef);
            }
            catch (XPathException xpe) {
                this.performEvaluation();
                return super.unpack();
            }
        }
    }

    @Override
    public Object[] toArgList() {
        this.performEvaluation();
        return super.toArgList();
    }

    @Override
    public List<TreeReference> getReferences() {
        this.performEvaluation();
        return super.getReferences();
    }

    @Override
    public int size() {
        this.performEvaluation();
        return super.size();
    }

    @Override
    public TreeReference getRefAt(int i) {
        this.performEvaluation();
        return super.getRefAt(i);
    }

    @Override
    public Object getValAt(int i) {
        this.performEvaluation();
        return super.getValAt(i);
    }

    @Override
    protected String nodeContents() {
        this.performEvaluation();
        return super.nodeContents();
    }
}

