/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.xpath.expr;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.javarosa.core.model.condition.EvaluationContext;
import org.javarosa.core.model.instance.DataInstance;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.PrototypeFactory;
import org.javarosa.xpath.expr.XPathBinaryOpExpr;
import org.javarosa.xpath.expr.XPathExpression;
import org.javarosa.xpath.expr.XPathFuncExpr;

public class XPathArithExpr
extends XPathBinaryOpExpr {
    public static final int ADD = 0;
    public static final int SUBTRACT = 1;
    public static final int MULTIPLY = 2;
    public static final int DIVIDE = 3;
    public static final int MODULO = 4;
    public int op;

    public XPathArithExpr() {
    }

    public XPathArithExpr(int op, XPathExpression a, XPathExpression b) {
        super(a, b);
        this.op = op;
    }

    @Override
    public Object eval(DataInstance model, EvaluationContext evalContext) {
        double aval = XPathFuncExpr.toNumeric(this.a.eval(model, evalContext));
        double bval = XPathFuncExpr.toNumeric(this.b.eval(model, evalContext));
        double result = 0.0;
        switch (this.op) {
            case 0: {
                result = aval + bval;
                break;
            }
            case 1: {
                result = aval - bval;
                break;
            }
            case 2: {
                result = aval * bval;
                break;
            }
            case 3: {
                result = aval / bval;
                break;
            }
            case 4: {
                result = aval % bval;
            }
        }
        return new Double(result);
    }

    @Override
    public boolean isIdempotent() {
        return this.a.isIdempotent() && this.b.isIdempotent();
    }

    public String toString() {
        String sOp = null;
        switch (this.op) {
            case 0: {
                sOp = "+";
                break;
            }
            case 1: {
                sOp = "-";
                break;
            }
            case 2: {
                sOp = "*";
                break;
            }
            case 3: {
                sOp = "/";
                break;
            }
            case 4: {
                sOp = "%";
            }
        }
        return super.toString(sOp);
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof XPathArithExpr) {
            XPathArithExpr x = (XPathArithExpr)o;
            return super.equals(o) && this.op == x.op;
        }
        return false;
    }

    @Override
    public void readExternal(DataInputStream in, PrototypeFactory pf) throws IOException, DeserializationException {
        this.op = ExtUtil.readInt(in);
        super.readExternal(in, pf);
    }

    @Override
    public void writeExternal(DataOutputStream out) throws IOException {
        ExtUtil.writeNumeric(out, this.op);
        super.writeExternal(out);
    }
}

