/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.javarosa.core.model.CompareChildToAbsoluteExpression;
import org.javarosa.core.model.condition.EvaluationContext;
import org.javarosa.core.model.condition.FilterStrategy;
import org.javarosa.core.model.instance.DataInstance;
import org.javarosa.core.model.instance.TreeReference;
import org.javarosa.xpath.expr.XPathExpression;
import org.jetbrains.annotations.NotNull;

public class ComparisonExpressionCacheFilterStrategy
implements FilterStrategy {
    private final Map<String, List<TreeReference>> cachedEvaluations = new HashMap<String, List<TreeReference>>();

    @Override
    @NotNull
    public List<TreeReference> filter(@NotNull DataInstance sourceInstance, @NotNull TreeReference nodeSet, @NotNull XPathExpression predicate, @NotNull List<TreeReference> children, @NotNull EvaluationContext evaluationContext, @NotNull Supplier<List<TreeReference>> next) {
        if (sourceInstance.getInstanceId() == null) {
            return next.get();
        }
        CompareChildToAbsoluteExpression candidate = CompareChildToAbsoluteExpression.parse(predicate);
        if (candidate != null) {
            Object absoluteValue = candidate.evalAbsolute(sourceInstance, evaluationContext);
            String key = nodeSet.toString() + predicate + candidate.getRelativeSide() + absoluteValue.toString();
            if (this.cachedEvaluations.containsKey(key)) {
                return this.cachedEvaluations.get(key);
            }
            List<TreeReference> filtered = next.get();
            this.cachedEvaluations.put(key, filtered);
            return filtered;
        }
        return next.get();
    }
}

