/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.model.xform;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.javarosa.core.data.IDataPointer;
import org.javarosa.core.model.FormDef;
import org.javarosa.core.model.IAnswerDataSerializer;
import org.javarosa.core.model.IDataReference;
import org.javarosa.core.model.instance.FormInstance;
import org.javarosa.core.model.instance.TreeElement;
import org.javarosa.core.model.instance.TreeReference;
import org.javarosa.core.model.utils.IInstanceSerializingVisitor;
import org.javarosa.core.services.transport.payload.ByteArrayPayload;
import org.javarosa.core.services.transport.payload.IDataPayload;
import org.javarosa.model.xform.XFormSerializingVisitor;
import org.javarosa.model.xform.XPathReference;
import org.javarosa.xform.util.XFormAnswerDataSerializer;
import org.kxml2.kdom.Element;

@Deprecated
public class SMSSerializingVisitor
implements IInstanceSerializingVisitor {
    private String theSmsStr = null;
    private String nodeSet = null;
    private String xmlns = null;
    private String delimiter = null;
    private String prefix = null;
    private String method = null;
    private TreeReference rootRef;
    IAnswerDataSerializer serializer;
    FormDef schema;
    private List<IDataPointer> dataPointers;

    private void init() {
        this.theSmsStr = null;
        this.schema = null;
        this.dataPointers = new ArrayList<IDataPointer>(0);
        this.theSmsStr = "";
    }

    @Override
    public byte[] serializeInstance(FormInstance model, FormDef formDef) throws IOException {
        this.init();
        this.schema = formDef;
        return this.serializeInstance(model);
    }

    @Override
    public byte[] serializeInstance(FormInstance model) throws IOException {
        return this.serializeInstance(model, new XPathReference("/"));
    }

    @Override
    public byte[] serializeInstance(FormInstance model, IDataReference ref) throws IOException {
        this.init();
        this.rootRef = FormInstance.unpackReference(ref);
        if (this.serializer == null) {
            this.setAnswerDataSerializer(new XFormAnswerDataSerializer());
        }
        model.accept(this);
        if (this.theSmsStr != null) {
            return this.theSmsStr.getBytes("UTF-16BE");
        }
        return null;
    }

    @Override
    public IDataPayload createSerializedPayload(FormInstance model) throws IOException {
        return this.createSerializedPayload(model, new XPathReference("/"));
    }

    @Override
    public IDataPayload createSerializedPayload(FormInstance model, IDataReference ref) throws IOException {
        this.init();
        this.rootRef = FormInstance.unpackReference(ref);
        if (this.serializer == null) {
            this.setAnswerDataSerializer(new XFormAnswerDataSerializer());
        }
        model.accept(this);
        if (this.theSmsStr != null) {
            byte[] form = this.theSmsStr.getBytes("UTF-16");
            return new ByteArrayPayload(form, null, 5);
        }
        return null;
    }

    @Override
    public void visit(FormInstance tree) {
        this.nodeSet = new String();
        TreeElement root = (TreeElement)tree.resolveReference(this.rootRef);
        this.xmlns = root.getAttributeValue("", "xmlns");
        this.delimiter = root.getAttributeValue("", "delimiter");
        if (this.delimiter == null) {
            this.delimiter = root.getAttributeValue("", "delimeter");
        }
        this.prefix = root.getAttributeValue("", "prefix");
        this.xmlns = this.xmlns != null ? this.xmlns : " ";
        this.delimiter = this.delimiter != null ? this.delimiter : " ";
        this.theSmsStr = this.prefix = this.prefix != null ? this.prefix : " ";
        for (int j = 0; j < root.getNumChildren(); ++j) {
            TreeElement tee = root.getChildAt(j);
            String e = this.serializeNode(tee);
            if (e == null) continue;
            this.theSmsStr = this.theSmsStr + e;
        }
        this.theSmsStr = this.theSmsStr.trim();
    }

    public String serializeNode(TreeElement instanceNode) {
        StringBuilder b = new StringBuilder();
        if (!instanceNode.isRelevant() || instanceNode.getMult() == -2) {
            return null;
        }
        if (instanceNode.getValue() != null) {
            Object serializedAnswer = this.serializer.serializeAnswerData(instanceNode.getValue(), instanceNode.getDataType());
            if (serializedAnswer instanceof Element) {
                throw new RuntimeException("Can't handle serialized output for " + instanceNode.getValue().toString() + ", " + serializedAnswer);
            }
            if (serializedAnswer instanceof String) {
                Element e = new Element();
                e.addChild(4, (Object)((String)serializedAnswer));
                String tag = instanceNode.getAttributeValue("", "tag");
                if (tag != null) {
                    b.append(tag);
                }
                b.append(this.delimiter);
                for (int k = 0; k < e.getChildCount(); ++k) {
                    b.append(e.getChild(k).toString());
                    b.append(this.delimiter);
                }
            } else {
                throw new RuntimeException("Can't handle serialized output for " + instanceNode.getValue().toString() + ", " + serializedAnswer);
            }
            if (this.serializer.containsExternalData(instanceNode.getValue()).booleanValue()) {
                IDataPointer[] pointer = this.serializer.retrieveExternalDataPointer(instanceNode.getValue());
                for (int i = 0; i < pointer.length; ++i) {
                    this.dataPointers.add(pointer[i]);
                }
            }
        }
        return b.toString();
    }

    @Override
    public void setAnswerDataSerializer(IAnswerDataSerializer ads) {
        this.serializer = ads;
    }

    @Override
    public IInstanceSerializingVisitor newInstance() {
        XFormSerializingVisitor modelSerializer = new XFormSerializingVisitor();
        modelSerializer.setAnswerDataSerializer(this.serializer);
        return modelSerializer;
    }
}

