/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model.condition;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Set;
import org.javarosa.core.model.QuickTriggerable;
import org.javarosa.core.model.condition.ConditionAction;
import org.javarosa.core.model.condition.EvaluationContext;
import org.javarosa.core.model.condition.Triggerable;
import org.javarosa.core.model.instance.FormInstance;
import org.javarosa.core.model.instance.TreeElement;
import org.javarosa.core.model.instance.TreeReference;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.PrototypeFactory;
import org.javarosa.xpath.XPathConditional;
import org.javarosa.xpath.XPathException;

public class Condition
extends Triggerable {
    private ConditionAction trueAction;
    private ConditionAction falseAction;

    public Condition() {
    }

    Condition(XPathConditional expr, TreeReference contextRef, TreeReference originalContextRef, Set<TreeReference> targets, Set<QuickTriggerable> immediateCascades, ConditionAction trueAction, ConditionAction falseAction) {
        super(expr, contextRef, originalContextRef, targets, immediateCascades);
        this.trueAction = trueAction;
        this.falseAction = falseAction;
    }

    @Override
    public Object eval(FormInstance model, EvaluationContext evalContext) {
        try {
            return this.expr.eval(model, evalContext);
        }
        catch (XPathException e) {
            e.setSource("Condition expression for " + this.getContext().toString(true));
            throw e;
        }
    }

    @Override
    public void apply(TreeReference ref, Object result, FormInstance mainInstance) {
        TreeElement element = (TreeElement)mainInstance.resolveReference(ref);
        switch ((Boolean)result != false ? this.trueAction : this.falseAction) {
            case RELEVANT: {
                element.setRelevant(true);
                break;
            }
            case NOT_RELEVANT: {
                element.setRelevant(false);
                break;
            }
            case ENABLE: {
                element.setEnabled(true);
                break;
            }
            case READ_ONLY: {
                element.setEnabled(false);
                break;
            }
            case REQUIRE: {
                element.setRequired(true);
                break;
            }
            case DONT_REQUIRE: {
                element.setRequired(false);
            }
        }
    }

    @Override
    public boolean canCascade() {
        return this.trueAction.isCascading();
    }

    @Override
    public boolean isCascadingToChildren() {
        return this.trueAction.isCascading();
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof Condition && super.equals(o) && this.trueAction == ((Condition)o).trueAction && this.falseAction == ((Condition)o).falseAction;
    }

    public String toString() {
        return String.format("%s %s if (%s)", this.trueAction.getVerb(), this.buildHumanReadableTargetList(), this.expr.xpath);
    }

    @Override
    public void readExternal(DataInputStream in, PrototypeFactory pf) throws IOException, DeserializationException {
        super.readExternal(in, pf);
        this.trueAction = ConditionAction.from(ExtUtil.readInt(in));
        this.falseAction = ConditionAction.from(ExtUtil.readInt(in));
    }

    @Override
    public void writeExternal(DataOutputStream out) throws IOException {
        super.writeExternal(out);
        ExtUtil.writeNumeric(out, this.trueAction.getCode());
        ExtUtil.writeNumeric(out, this.falseAction.getCode());
    }
}

