/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.reference;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.javarosa.core.reference.Reference;

public class ResourceReference
implements Reference {
    String URI;

    public ResourceReference(String URI) {
        this.URI = URI;
    }

    @Override
    public boolean doesBinaryExist() throws IOException {
        InputStream is = System.class.getResourceAsStream(this.URI);
        if (is == null) {
            return false;
        }
        is.close();
        return true;
    }

    @Override
    public InputStream getStream() throws IOException {
        return System.class.getResourceAsStream(this.URI);
    }

    @Override
    public String getURI() {
        return "jr://resource" + this.URI;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    public boolean equals(Object o) {
        if (o instanceof ResourceReference) {
            return this.URI.equals(((ResourceReference)o).URI);
        }
        return false;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        throw new IOException("Resource references are read-only URI's");
    }

    @Override
    public void remove() throws IOException {
        throw new IOException("Resource references are read-only URI's");
    }

    @Override
    public String getLocalURI() {
        return this.URI;
    }

    @Override
    public Reference[] probeAlternativeReferences() {
        return new Reference[0];
    }
}

