/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.services.locale;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.javarosa.core.services.locale.LocaleDataSource;
import org.javarosa.core.util.OrderedMap;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.PrototypeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceFileDataSource
implements LocaleDataSource {
    private static final Logger logger = LoggerFactory.getLogger(ResourceFileDataSource.class);
    String resourceURI;

    public ResourceFileDataSource() {
    }

    public ResourceFileDataSource(String resourceURI) {
        if (resourceURI == null) {
            throw new NullPointerException("Resource URI cannot be null when creating a Resource File Data Source");
        }
        this.resourceURI = resourceURI;
    }

    @Override
    public OrderedMap<String, String> getLocalizedText() {
        return this.loadLocaleResource(this.resourceURI);
    }

    @Override
    public void readExternal(DataInputStream in, PrototypeFactory pf) throws IOException, DeserializationException {
        this.resourceURI = in.readUTF();
    }

    @Override
    public void writeExternal(DataOutputStream out) throws IOException {
        out.writeUTF(this.resourceURI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OrderedMap<String, String> loadLocaleResource(String resourceName) {
        InputStreamReader isr;
        InputStream is = System.class.getResourceAsStream(resourceName);
        OrderedMap<String, String> locale = new OrderedMap<String, String>();
        int chunk = 100;
        try {
            isr = new InputStreamReader(is, "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load locale resource " + resourceName + ". Is it in the jar?");
        }
        boolean done = false;
        char[] cbuf = new char[chunk];
        int offset = 0;
        int curline = 0;
        try {
            String line = "";
            block13: while (!done) {
                int read = isr.read(cbuf, offset, chunk - offset);
                if (read == -1) {
                    done = true;
                    if (line.length() != 0) {
                        this.parseAndAdd(locale, line, curline);
                    }
                    break;
                }
                String stringchunk = String.valueOf(cbuf, offset, read);
                int index = 0;
                while (index != -1) {
                    int nindex = stringchunk.indexOf(10, index);
                    if (nindex == -1) {
                        nindex = stringchunk.indexOf(13, index);
                    }
                    if (nindex == -1) {
                        line = line + stringchunk.substring(index);
                        continue block13;
                    }
                    line = line + stringchunk.substring(index, nindex);
                    this.parseAndAdd(locale, line, ++curline);
                    line = "";
                    index = nindex + 1;
                }
            }
        }
        catch (IOException e) {
            logger.error("Error", (Throwable)e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                logger.info("Input Stream for resource file {} failed to close. This will eat up your memory! Fix Problem! [{}]", (Object)this.resourceURI, (Object)e.getMessage());
                logger.error("Error", (Throwable)e);
            }
        }
        return locale;
    }

    private void parseAndAdd(OrderedMap<String, String> locale, String line, int curline) {
        line = line.trim();
        while (line.indexOf("#") != -1) {
            line = line.substring(0, line.indexOf("#"));
        }
        if (line.indexOf(61) == -1) {
            if (!line.trim().equals("")) {
                logger.info("Invalid line (#{}) read: {}", (Object)curline, (Object)line);
            }
        } else if (line.indexOf(61) != line.length() - 1) {
            String value = line.substring(line.indexOf(61) + 1, line.length());
            locale.put(line.substring(0, line.indexOf(61)), value);
        } else {
            logger.info("Invalid line (#{}) read: '{}'. No value follows the '='.", (Object)curline, (Object)line);
        }
    }
}

