/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.util;

import org.javarosa.core.model.instance.TreeReferenceLevel;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.xpath.expr.XPathStep;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryUtils {
    private static final Logger logger = LoggerFactory.getLogger(MemoryUtils.class);
    private static long[] memoryProfile;
    private static byte[][] memoryHolders;
    static int currentCount;
    static boolean oldterning;
    static boolean otrt;
    static boolean oldxpath;
    private static final int MEMORY_PROFILE_SIZE = 5000;
    private static boolean MEMORY_PRINT_ENABLED;

    public static void stopTerning() {
        oldterning = ExtUtil.interning;
        otrt = TreeReferenceLevel.treeRefLevelInterningEnabled;
        oldxpath = XPathStep.XPathStepInterningEnabled;
        ExtUtil.interning = false;
        TreeReferenceLevel.treeRefLevelInterningEnabled = false;
        XPathStep.XPathStepInterningEnabled = false;
    }

    public static void revertTerning() {
        ExtUtil.interning = oldterning;
        TreeReferenceLevel.treeRefLevelInterningEnabled = otrt;
        XPathStep.XPathStepInterningEnabled = oldxpath;
    }

    public static void enableMemoryProfile() {
        memoryProfile = new long[10000];
        memoryHolders = new byte[5000][];
    }

    public static void printMemoryTest() {
        MemoryUtils.printMemoryTest(null);
    }

    public static void printMemoryTest(String tag) {
        MemoryUtils.printMemoryTest(tag, -1);
    }

    /*
     * Unable to fully structure code
     */
    public static void printMemoryTest(String tag, int pause) {
        if (!MemoryUtils.MEMORY_PRINT_ENABLED) {
            return;
        }
        System.gc();
        r = Runtime.getRuntime();
        free = r.freeMemory();
        total = r.totalMemory();
        if (tag != null) {
            MemoryUtils.logger.info("=== Memory Evaluation: {} ===", (Object)tag);
        }
        MemoryUtils.logger.info("Total: {}", (Object)total);
        MemoryUtils.logger.info("Free: {}", (Object)free);
        chunk = 100;
        lastSuccess = 100;
        resolution = 10000;
        while (true) {
            System.gc();
            try {
                newAmount = lastSuccess + chunk;
                allocated = new byte[newAmount];
                lastSuccess = newAmount;
                chunk *= 10;
                continue;
            }
            catch (OutOfMemoryError oom) {
                if ((chunk /= 2) < resolution) ** break;
                continue;
                availPercent = (int)Math.floor((double)lastSuccess * 1.0 / (double)total * 100.0);
                fragmentation = (int)Math.floor((double)lastSuccess * 1.0 / (double)free * 100.0);
                MemoryUtils.logger.info("Usable Memory: {}", (Object)lastSuccess);
                MemoryUtils.logger.info("{}% of available memory", (Object)availPercent);
                MemoryUtils.logger.info("Fragmentation: {}%", (Object)fragmentation);
                if (pause != -1) {
                    try {
                        Thread.sleep(pause);
                    }
                    catch (InterruptedException e) {
                        MemoryUtils.logger.error("Error", (Throwable)e);
                    }
                }
                return;
            }
            break;
        }
    }

    public static void profileMemory() {
        int i;
        if (memoryProfile == null) {
            logger.info("You must initialize the memory profiler before it can be used!");
            return;
        }
        currentCount = 0;
        int chunkSize = 100000;
        long memoryAccountedFor = 0L;
        boolean succeeded = false;
        int threshold = 4;
        Runtime r = Runtime.getRuntime();
        System.gc();
        long memory = r.freeMemory();
        while (true) {
            if (currentCount >= 5000) {
                logger.info("Memory profile is too small for this device's usage!");
                break;
            }
            if (chunkSize < threshold) {
                succeeded = true;
                break;
            }
            try {
                MemoryUtils.memoryHolders[MemoryUtils.currentCount] = new byte[chunkSize];
                MemoryUtils.memoryProfile[MemoryUtils.currentCount * 2] = (long)memoryHolders[currentCount].hashCode() & 0xFFFFFFFFL;
                MemoryUtils.memoryProfile[MemoryUtils.currentCount * 2 + 1] = chunkSize;
                ++currentCount;
                memoryAccountedFor += (long)chunkSize;
            }
            catch (OutOfMemoryError oom) {
                chunkSize -= chunkSize < 100 ? 1 : 50;
            }
        }
        for (i = 0; i < currentCount; ++i) {
            MemoryUtils.memoryHolders[i] = null;
        }
        System.gc();
        if (succeeded) {
            logger.info("Acquired memory profile for {} of the {} available bytes, with {} traces", new Object[]{memoryAccountedFor, memory, currentCount});
            for (i = 0; i < currentCount * 2; i += 2) {
                logger.info("Address: {} -> {}", (Object)memoryProfile[i], (Object)memoryProfile[i + 1]);
            }
        }
    }

    static {
        currentCount = 0;
        MEMORY_PRINT_ENABLED = false;
    }
}

