/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.form.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.javarosa.core.model.FormDef;
import org.javarosa.core.model.FormElementStateListener;
import org.javarosa.core.model.FormIndex;
import org.javarosa.core.model.GroupDef;
import org.javarosa.core.model.IFormElement;
import org.javarosa.core.model.instance.TreeElement;
import org.javarosa.core.services.locale.Localizer;
import org.javarosa.formmanager.view.IQuestionWidget;

public class FormEntryCaption
implements FormElementStateListener {
    FormDef form;
    FormIndex index;
    protected IFormElement element;
    private String textID;
    public static final String TEXT_FORM_LONG = "long";
    public static final String TEXT_FORM_SHORT = "short";
    public static final String TEXT_FORM_AUDIO = "audio";
    public static final String TEXT_FORM_IMAGE = "image";
    public static final String TEXT_FORM_VIDEO = "video";
    protected IQuestionWidget viewWidget;

    public FormEntryCaption() {
    }

    public FormEntryCaption(FormDef form, FormIndex index) {
        this.form = form;
        this.index = index;
        this.element = form.getChild(index);
        this.viewWidget = null;
        this.textID = this.element.getTextID();
    }

    public String getLongText() {
        return this.getQuestionText(this.getTextID());
    }

    public String getShortText() {
        String returnText = this.getSpecialFormQuestionText(this.getTextID(), TEXT_FORM_SHORT);
        if (returnText == null) {
            returnText = this.getLongText();
        }
        return returnText;
    }

    public String getAudioText() {
        return this.getSpecialFormQuestionText(this.getTextID(), TEXT_FORM_AUDIO);
    }

    public String getImageText() {
        return this.getSpecialFormQuestionText(this.getTextID(), TEXT_FORM_IMAGE);
    }

    public String getQuestionText(String textID) {
        String tid = textID;
        if (tid != null && tid.length() == 0) {
            tid = null;
        }
        if (tid == null) {
            return this.substituteStringArgs(this.element.getLabelInnerText());
        }
        String returnText = this.getIText(tid, TEXT_FORM_LONG);
        if (returnText == null) {
            returnText = this.getIText(tid, null);
        }
        return this.substituteStringArgs(returnText);
    }

    public String getQuestionText() {
        return this.getQuestionText(this.getTextID());
    }

    public String getSpecialFormQuestionText(String textID, String form) {
        if (textID == null || textID.length() == 0) {
            return null;
        }
        String returnText = this.getIText(textID, form);
        return this.substituteStringArgs(returnText);
    }

    public String getSpecialFormQuestionText(String form) {
        return this.getSpecialFormQuestionText(this.getTextID(), form);
    }

    protected String getIText(String textID, String form) {
        String returnText = null;
        if (textID == null || textID.length() == 0) {
            return null;
        }
        if (form != null && form.length() > 0) {
            try {
                returnText = this.localizer().getRawText(this.localizer().getLocale(), textID + ";" + form);
            }
            catch (NullPointerException nullPointerException) {}
        } else {
            try {
                returnText = this.localizer().getRawText(this.localizer().getLocale(), textID);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return returnText;
    }

    public String getRepeatText(String typeKey) {
        GroupDef g = (GroupDef)this.element;
        if (!g.getRepeat()) {
            throw new RuntimeException("not a repeat");
        }
        String title = this.getLongText();
        int count = this.getNumRepetitions();
        String caption = null;
        if ("mainheader".equals(typeKey)) {
            caption = g.mainHeader;
            if (caption == null) {
                return title;
            }
        } else if ("add".equals(typeKey)) {
            caption = g.addCaption;
            if (caption == null) {
                return "Add another " + title;
            }
        } else if ("add-empty".equals(typeKey)) {
            caption = g.addEmptyCaption;
            if (caption == null) {
                caption = g.addCaption;
            }
            if (caption == null) {
                return "None - Add " + title;
            }
        } else if ("del".equals(typeKey)) {
            caption = g.delCaption;
            if (caption == null) {
                return "Delete " + title;
            }
        } else if ("done".equals(typeKey)) {
            caption = g.doneCaption;
            if (caption == null) {
                return "Done";
            }
        } else if ("done-empty".equals(typeKey)) {
            caption = g.doneEmptyCaption;
            if (caption == null) {
                caption = g.doneCaption;
            }
            if (caption == null) {
                return "Skip";
            }
        } else if ("delheader".equals(typeKey) && (caption = g.delHeader) == null) {
            return "Delete which " + title + "?";
        }
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("name", title);
        vars.put("n", count);
        return this.form.fillTemplateString(caption, this.index.getReference(), vars);
    }

    public int getNumRepetitions() {
        return this.form.getNumRepetitions(this.index);
    }

    public String getRepetitionText(boolean newrep) {
        return this.getRepetitionText("header", this.index, newrep);
    }

    private String getRepetitionText(String type, FormIndex index, boolean newrep) {
        if (this.element instanceof GroupDef && ((GroupDef)this.element).getRepeat() && index.getElementMultiplicity() >= 0) {
            GroupDef g = (GroupDef)this.element;
            String title = this.getLongText();
            int ix = index.getElementMultiplicity() + 1;
            int count = this.getNumRepetitions();
            String caption = null;
            if ("header".equals(type)) {
                caption = g.entryHeader;
            } else if ("choose".equals(type) && (caption = g.chooseCaption) == null) {
                caption = g.entryHeader;
            }
            if (caption == null) {
                return title + " " + ix + "/" + count;
            }
            HashMap<String, Object> vars = new HashMap<String, Object>();
            vars.put("name", title);
            vars.put("i", ix);
            vars.put("n", count);
            vars.put("new", new Boolean(newrep));
            return this.form.fillTemplateString(caption, index.getReference(), vars);
        }
        return null;
    }

    public List<String> getRepetitionsText() {
        GroupDef g = (GroupDef)this.element;
        if (!g.getRepeat()) {
            throw new RuntimeException("not a repeat");
        }
        int numRepetitions = this.getNumRepetitions();
        ArrayList<String> reps = new ArrayList<String>(numRepetitions);
        for (int i = 0; i < numRepetitions; ++i) {
            reps.add(this.getRepetitionText("choose", this.form.descendIntoRepeat(this.index, i), false));
        }
        return reps;
    }

    public String getAppearanceHint() {
        return this.element.getAppearanceAttr();
    }

    protected String substituteStringArgs(String templateStr) {
        if (templateStr == null) {
            return null;
        }
        return this.form.fillTemplateString(templateStr, this.index.getReference());
    }

    public int getMultiplicity() {
        return this.index.getElementMultiplicity();
    }

    public IFormElement getFormElement() {
        return this.element;
    }

    public boolean repeats() {
        if (this.element instanceof GroupDef) {
            return ((GroupDef)this.element).getRepeat();
        }
        return false;
    }

    public FormIndex getIndex() {
        return this.index;
    }

    protected Localizer localizer() {
        return this.form.getLocalizer();
    }

    public void register(IQuestionWidget viewWidget) {
        this.viewWidget = viewWidget;
        this.element.registerStateObserver(this);
    }

    public void unregister() {
        this.viewWidget = null;
        this.element.unregisterStateObserver(this);
    }

    @Override
    public void formElementStateChanged(IFormElement element, int changeFlags) {
        if (this.element != element) {
            throw new IllegalStateException("Widget received event from foreign question");
        }
        if (this.viewWidget != null) {
            this.viewWidget.refreshWidget(changeFlags);
        }
    }

    @Override
    public void formElementStateChanged(TreeElement instanceNode, int changeFlags) {
        throw new RuntimeException("cannot happen");
    }

    protected String getTextID() {
        return this.textID;
    }
}

