/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.xform.util;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import org.kxml2.io.KXmlSerializer;
import org.kxml2.kdom.Document;
import org.kxml2.kdom.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.XmlSerializer;

public class XFormSerializer {
    private static final Logger logger = LoggerFactory.getLogger(XFormSerializer.class);

    public static ByteArrayOutputStream getStream(Document doc) {
        KXmlSerializer serializer = new KXmlSerializer();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            serializer.setOutput((OutputStream)dos, null);
            doc.write((XmlSerializer)serializer);
            serializer.flush();
            return bos;
        }
        catch (Exception e) {
            logger.error("Error", (Throwable)e);
            return null;
        }
    }

    public static String elementToString(Element e) {
        KXmlSerializer serializer = new KXmlSerializer();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        String s = null;
        try {
            serializer.setOutput((OutputStream)dos, null);
            e.write((XmlSerializer)serializer);
            serializer.flush();
            s = new String(bos.toByteArray(), "UTF-8");
            return s;
        }
        catch (UnsupportedEncodingException uce) {
            logger.error("Error", (Throwable)uce);
        }
        catch (Exception ex) {
            logger.error("Error", (Throwable)ex);
            return null;
        }
        return null;
    }

    public static String getString(Document doc) {
        ByteArrayOutputStream bos = XFormSerializer.getStream(doc);
        byte[] byteArr = bos.toByteArray();
        char[] charArray = new char[byteArr.length];
        for (int i = 0; i < byteArr.length; ++i) {
            charArray[i] = (char)byteArr[i];
        }
        return String.valueOf(charArray);
    }

    public static byte[] getUtfBytes(Document doc) {
        KXmlSerializer serializer = new KXmlSerializer();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            serializer.setOutput((OutputStream)bos, StandardCharsets.UTF_8.name());
            doc.write((XmlSerializer)serializer);
            serializer.flush();
            return bos.toByteArray();
        }
        catch (Exception e) {
            logger.error("Error", (Throwable)e);
            return null;
        }
    }
}

