/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.xpath.expr;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import org.javarosa.core.model.condition.EvaluationContext;
import org.javarosa.core.model.condition.pivot.UnpivotableExpressionException;
import org.javarosa.core.model.instance.DataInstance;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.ExtWrapTagged;
import org.javarosa.core.util.externalizable.PrototypeFactory;
import org.javarosa.xpath.expr.XPathExpression;
import org.javarosa.xpath.expr.XPathOpExpr;
import org.jetbrains.annotations.NotNull;

public abstract class XPathBinaryOpExpr
extends XPathOpExpr {
    public XPathExpression a;
    public XPathExpression b;

    public XPathBinaryOpExpr() {
    }

    public XPathBinaryOpExpr(XPathExpression a, XPathExpression b) {
        this.a = a;
        this.b = b;
    }

    @Override
    public boolean containsFunc(@NotNull String name) {
        return this.a.containsFunc(name) || this.b.containsFunc(name);
    }

    public String toString(String op) {
        return "{binop-expr:" + op + "," + this.a.toString() + "," + this.b.toString() + "}";
    }

    public boolean equals(Object o) {
        if (o instanceof XPathBinaryOpExpr) {
            XPathBinaryOpExpr x = (XPathBinaryOpExpr)o;
            return this.a.equals(x.a) && this.b.equals(x.b);
        }
        return false;
    }

    @Override
    public void readExternal(DataInputStream in, PrototypeFactory pf) throws IOException, DeserializationException {
        this.a = (XPathExpression)ExtUtil.read(in, new ExtWrapTagged(), pf);
        this.b = (XPathExpression)ExtUtil.read(in, new ExtWrapTagged(), pf);
    }

    @Override
    public void writeExternal(DataOutputStream out) throws IOException {
        ExtUtil.write(out, new ExtWrapTagged(this.a));
        ExtUtil.write(out, new ExtWrapTagged(this.b));
    }

    @Override
    public Object pivot(DataInstance model, EvaluationContext evalContext, List<Object> pivots, Object sentinal) throws UnpivotableExpressionException {
        Object aval = this.a.pivot(model, evalContext, pivots, sentinal);
        Object bval = this.b.pivot(model, evalContext, pivots, sentinal);
        if (aval == sentinal || bval == sentinal) {
            throw new UnpivotableExpressionException();
        }
        if (aval == null || bval == null) {
            return null;
        }
        return this.eval(model, evalContext);
    }
}

