/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.xpath.expr;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import org.javarosa.core.model.condition.EvaluationContext;
import org.javarosa.core.model.condition.pivot.CmpPivot;
import org.javarosa.core.model.condition.pivot.UnpivotableExpressionException;
import org.javarosa.core.model.data.DecimalData;
import org.javarosa.core.model.data.UncastData;
import org.javarosa.core.model.instance.DataInstance;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.PrototypeFactory;
import org.javarosa.xpath.XPathNodeset;
import org.javarosa.xpath.expr.XPathBinaryOpExpr;
import org.javarosa.xpath.expr.XPathExpression;
import org.javarosa.xpath.expr.XPathFuncExpr;

public class XPathCmpExpr
extends XPathBinaryOpExpr {
    public static final int LT = 0;
    public static final int GT = 1;
    public static final int LTE = 2;
    public static final int GTE = 3;
    public int op;

    public XPathCmpExpr() {
    }

    public XPathCmpExpr(int op, XPathExpression a, XPathExpression b) {
        super(a, b);
        this.op = op;
    }

    @Override
    public Object eval(DataInstance model, EvaluationContext evalContext) {
        Object aval = this.a.eval(model, evalContext);
        Object bval = this.b.eval(model, evalContext);
        boolean result = false;
        aval = XPathFuncExpr.toNumeric(aval);
        bval = XPathFuncExpr.toNumeric(bval);
        double fa = (Double)aval;
        double fb = (Double)bval;
        switch (this.op) {
            case 0: {
                result = fa < fb;
                break;
            }
            case 1: {
                result = fa > fb;
                break;
            }
            case 2: {
                result = fa <= fb;
                break;
            }
            case 3: {
                result = fa >= fb;
            }
        }
        return new Boolean(result);
    }

    public String toString() {
        String sOp = null;
        switch (this.op) {
            case 0: {
                sOp = "<";
                break;
            }
            case 1: {
                sOp = ">";
                break;
            }
            case 2: {
                sOp = "<=";
                break;
            }
            case 3: {
                sOp = ">=";
            }
        }
        return super.toString(sOp);
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof XPathCmpExpr) {
            XPathCmpExpr x = (XPathCmpExpr)o;
            return super.equals(o) && this.op == x.op;
        }
        return false;
    }

    @Override
    public void readExternal(DataInputStream in, PrototypeFactory pf) throws IOException, DeserializationException {
        this.op = ExtUtil.readInt(in);
        super.readExternal(in, pf);
    }

    @Override
    public void writeExternal(DataOutputStream out) throws IOException {
        ExtUtil.writeNumeric(out, this.op);
        super.writeExternal(out);
    }

    @Override
    public Object pivot(DataInstance model, EvaluationContext evalContext, List<Object> pivots, Object sentinal) throws UnpivotableExpressionException {
        Object aval = this.a.pivot(model, evalContext, pivots, sentinal);
        Object bval = this.b.pivot(model, evalContext, pivots, sentinal);
        if (bval instanceof XPathNodeset) {
            bval = ((XPathNodeset)bval).unpack();
        }
        if (this.handled(aval, bval, sentinal, pivots) || this.handled(bval, aval, sentinal, pivots)) {
            return null;
        }
        return this.eval(model, evalContext);
    }

    @Override
    public boolean isIdempotent() {
        return this.a.isIdempotent() && this.b.isIdempotent();
    }

    private boolean handled(Object a, Object b, Object sentinal, List<Object> pivots) throws UnpivotableExpressionException {
        if (sentinal == a) {
            if (b == null) {
                throw new UnpivotableExpressionException();
            }
            if (sentinal == b) {
                throw new UnpivotableExpressionException();
            }
            Double val = null;
            if (b instanceof Double) {
                val = (Double)b;
            } else if (b instanceof Integer) {
                val = new Double(((Integer)b).doubleValue());
            } else if (b instanceof Long) {
                val = new Double(((Long)b).doubleValue());
            } else if (b instanceof Float) {
                val = new Double(((Float)b).doubleValue());
            } else if (b instanceof Short) {
                val = new Double(((Short)b).shortValue());
            } else if (b instanceof Byte) {
                val = new Double(((Byte)b).byteValue());
            } else if (b instanceof String) {
                try {
                    val = (Double)new DecimalData().cast(new UncastData((String)b)).getValue();
                }
                catch (Exception e) {
                    throw new UnpivotableExpressionException("Unrecognized numeric data in cmp expression: " + b);
                }
            } else {
                throw new UnpivotableExpressionException("Unrecognized numeric data in cmp expression: " + b);
            }
            pivots.add(new CmpPivot(val, this.op));
            return true;
        }
        return false;
    }
}

