/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.xpath.expr;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.javarosa.core.model.condition.EvaluationContext;
import org.javarosa.core.model.condition.pivot.UnpivotableExpressionException;
import org.javarosa.core.model.instance.DataInstance;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.ExtWrapListPoly;
import org.javarosa.core.util.externalizable.ExtWrapTagged;
import org.javarosa.core.util.externalizable.PrototypeFactory;
import org.javarosa.xpath.XPathUnsupportedException;
import org.javarosa.xpath.expr.XPathExpression;
import org.jetbrains.annotations.NotNull;

public class XPathFilterExpr
extends XPathExpression {
    public XPathExpression x;
    public XPathExpression[] predicates;

    public XPathFilterExpr() {
    }

    public XPathFilterExpr(XPathExpression x, XPathExpression[] predicates) {
        this.x = x;
        this.predicates = predicates;
    }

    @Override
    public Object eval(DataInstance model, EvaluationContext evalContext) {
        throw new XPathUnsupportedException("filter expression");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{filt-expr:");
        sb.append(this.x.toString());
        sb.append(",{");
        for (int i = 0; i < this.predicates.length; ++i) {
            sb.append(this.predicates[i].toString());
            if (i >= this.predicates.length - 1) continue;
            sb.append(",");
        }
        sb.append("}}");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (o instanceof XPathFilterExpr) {
            XPathFilterExpr fe = (XPathFilterExpr)o;
            ArrayList<XPathExpression> a = new ArrayList<XPathExpression>(this.predicates.length);
            for (int i = 0; i < this.predicates.length; ++i) {
                a.add(this.predicates[i]);
            }
            ArrayList<XPathExpression> b = new ArrayList<XPathExpression>(fe.predicates.length);
            for (int i = 0; i < fe.predicates.length; ++i) {
                b.add(fe.predicates[i]);
            }
            return this.x.equals(fe.x) && ExtUtil.listEquals(a, b);
        }
        return false;
    }

    @Override
    public void readExternal(DataInputStream in, PrototypeFactory pf) throws IOException, DeserializationException {
        this.x = (XPathExpression)ExtUtil.read(in, new ExtWrapTagged(), pf);
        List v = (List)ExtUtil.read(in, new ExtWrapListPoly(), pf);
        this.predicates = new XPathExpression[v.size()];
        for (int i = 0; i < this.predicates.length; ++i) {
            this.predicates[i] = (XPathExpression)v.get(i);
        }
    }

    @Override
    public void writeExternal(DataOutputStream out) throws IOException {
        List<XPathExpression> v = Arrays.asList(this.predicates);
        ExtUtil.write(out, new ExtWrapTagged(this.x));
        ExtUtil.write(out, new ExtWrapListPoly(v));
    }

    @Override
    public Object pivot(DataInstance model, EvaluationContext evalContext, List<Object> pivots, Object sentinal) throws UnpivotableExpressionException {
        throw new UnpivotableExpressionException();
    }

    @Override
    public boolean isIdempotent() {
        return this.x.isIdempotent() && Arrays.stream(this.predicates).allMatch(XPathExpression::isIdempotent);
    }

    @Override
    public boolean containsFunc(@NotNull String name) {
        return this.x.containsFunc(name) || Arrays.stream(this.predicates).anyMatch(expression -> expression.containsFunc(name));
    }
}

