/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.xpath.expr;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.javarosa.core.model.condition.EvaluationContext;
import org.javarosa.core.model.condition.IFallbackFunctionHandler;
import org.javarosa.core.model.condition.IFunctionHandler;
import org.javarosa.core.model.condition.pivot.UnpivotableExpressionException;
import org.javarosa.core.model.instance.DataInstance;
import org.javarosa.core.model.instance.FormInstance;
import org.javarosa.core.model.instance.TreeReference;
import org.javarosa.core.model.utils.DateUtils;
import org.javarosa.core.services.PropertyManager;
import org.javarosa.core.util.Base64;
import org.javarosa.core.util.Ed25519;
import org.javarosa.core.util.GeoUtils;
import org.javarosa.core.util.MathUtils;
import org.javarosa.core.util.PropertyUtils;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.ExtWrapListPoly;
import org.javarosa.core.util.externalizable.PrototypeFactory;
import org.javarosa.xform.parse.XFormParser;
import org.javarosa.xpath.IExprDataType;
import org.javarosa.xpath.XPathArityException;
import org.javarosa.xpath.XPathNodeset;
import org.javarosa.xpath.XPathTypeMismatchException;
import org.javarosa.xpath.XPathUnhandledException;
import org.javarosa.xpath.expr.DigestAlgorithm;
import org.javarosa.xpath.expr.Encoding;
import org.javarosa.xpath.expr.XPathExpression;
import org.javarosa.xpath.expr.XPathFuncExprGeo;
import org.javarosa.xpath.expr.XPathPathExpr;
import org.javarosa.xpath.expr.XPathQName;
import org.javarosa.xpath.expr.XPathStringLiteral;
import org.jetbrains.annotations.NotNull;
import org.joda.time.DateTime;

public class XPathFuncExpr
extends XPathExpression {
    public XPathQName id;
    public XPathExpression[] args;
    public static final String[] IDEMPOTENT_FUNCTIONS = new String[]{"regex", "starts-with", "ends-with", "contains", "substr", "substring-before", "substring-after", "translate", "string-length", "normalize-space", "concat", "join", "boolean-from-string", "string"};

    public XPathFuncExpr() {
    }

    public XPathFuncExpr(XPathQName id, XPathExpression[] args) {
        this.id = id;
        this.args = args;
        if (id.name.equals("instance") && args[0] instanceof XPathStringLiteral) {
            XFormParser.recordInstanceFunctionCall(((XPathStringLiteral)args[0]).s);
        }
    }

    public XPathFuncExpr(XPathQName id) {
        this(id, new XPathExpression[0]);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{func-expr:");
        sb.append(this.id.toString());
        sb.append(",{");
        for (int i = 0; i < this.args.length; ++i) {
            sb.append(this.args[i].toString());
            if (i >= this.args.length - 1) continue;
            sb.append(",");
        }
        sb.append("}}");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (o instanceof XPathFuncExpr) {
            XPathFuncExpr x = (XPathFuncExpr)o;
            if (!this.id.equals(x.id) || this.args.length != x.args.length || this.id.toString().equals("uuid") || this.id.toString().equals("random") || this.id.toString().equals("once") || this.id.toString().equals("now") || this.id.toString().equals("today")) {
                return false;
            }
            return ExtUtil.arrayEquals(this.args, x.args);
        }
        return false;
    }

    @Override
    public void readExternal(DataInputStream in, PrototypeFactory pf) throws IOException, DeserializationException {
        this.id = (XPathQName)ExtUtil.read(in, XPathQName.class);
        List v = (List)ExtUtil.read(in, new ExtWrapListPoly(), pf);
        this.args = new XPathExpression[v.size()];
        for (int i = 0; i < this.args.length; ++i) {
            this.args[i] = (XPathExpression)v.get(i);
        }
    }

    @Override
    public void writeExternal(DataOutputStream out) throws IOException {
        List<XPathExpression> v = Arrays.asList(this.args);
        ExtUtil.write(out, this.id);
        ExtUtil.write(out, new ExtWrapListPoly(v));
    }

    @Override
    public Object eval(DataInstance model, EvaluationContext evalContext) {
        String name = this.id.toString();
        Object[] argVals = new Object[this.args.length];
        HashMap<String, IFunctionHandler> funcHandlers = evalContext.getFunctionHandlers();
        if (name.equals("if")) {
            XPathFuncExpr.assertArgsCount(name, this.args, 3);
            return XPathFuncExpr.ifThenElse(model, evalContext, this.args, argVals);
        }
        if (name.equals("coalesce")) {
            XPathFuncExpr.assertArgsCount(name, this.args, 2);
            argVals[0] = this.args[0].eval(model, evalContext);
            if (!XPathFuncExpr.isNull(argVals[0])) {
                return argVals[0];
            }
            argVals[1] = this.args[1].eval(model, evalContext);
            return argVals[1];
        }
        if (name.equals("indexed-repeat")) {
            if (this.args.length == 3 || this.args.length == 5 || this.args.length == 7 || this.args.length == 9 || this.args.length == 11) {
                return XPathFuncExpr.indexedRepeat(model, evalContext, this.args, argVals);
            }
            throw new XPathUnhandledException("function '" + name + "' requires 3, 5, 7, 9 or 11 arguments. Only " + this.args.length + " provided.");
        }
        for (int i = 0; i < this.args.length; ++i) {
            argVals[i] = this.args[i].eval(model, evalContext);
        }
        if (name.equals("true")) {
            XPathFuncExpr.assertArgsCount(name, this.args, 0);
            return Boolean.TRUE;
        }
        if (name.equals("false")) {
            XPathFuncExpr.assertArgsCount(name, this.args, 0);
            return Boolean.FALSE;
        }
        if (name.equals("boolean")) {
            XPathFuncExpr.assertArgsCount(name, this.args, 1);
            return XPathFuncExpr.toBoolean(argVals[0]);
        }
        if (name.equals("number")) {
            XPathFuncExpr.assertArgsCount(name, this.args, 1);
            return XPathFuncExpr.toNumeric(argVals[0]);
        }
        if (name.equals("int")) {
            XPathFuncExpr.assertArgsCount(name, this.args, 1);
            return XPathFuncExpr.toInt(argVals[0]);
        }
        if (name.equals("round")) {
            int places;
            if (this.args.length == 1) {
                places = 0;
            } else {
                XPathFuncExpr.assertArgsCount(name, this.args, 2);
                places = XPathFuncExpr.toNumeric(argVals[1]).intValue();
            }
            return XPathFuncExpr.round(XPathFuncExpr.toNumeric(argVals[0]), places);
        }
        if (name.equals("string")) {
            XPathFuncExpr.assertArgsCount(name, this.args, 1);
            return XPathFuncExpr.toString(argVals[0]);
        }
        if (name.equals("date")) {
            XPathFuncExpr.assertArgsCount(name, this.args, 1);
            return XPathFuncExpr.toDate(argVals[0], false);
        }
        if (name.equals("date-time")) {
            XPathFuncExpr.assertArgsCount(name, this.args, 1);
            return XPathFuncExpr.toDate(argVals[0], true);
        }
        if (name.equals("decimal-date-time")) {
            XPathFuncExpr.assertArgsCount(name, this.args, 1);
            return XPathFuncExpr.toDecimalDateTime(argVals[0], true);
        }
        if (name.equals("decimal-time")) {
            XPathFuncExpr.assertArgsCount(name, this.args, 1);
            return XPathFuncExpr.toDecimalDateTime(argVals[0], false);
        }
        if (name.equals("not")) {
            XPathFuncExpr.assertArgsCount(name, this.args, 1);
            return XPathFuncExpr.boolNot(argVals[0]);
        }
        if (name.equals("boolean-from-string")) {
            XPathFuncExpr.assertArgsCount(name, this.args, 1);
            return XPathFuncExpr.boolStr(argVals[0]);
        }
        if (name.equals("format-date")) {
            XPathFuncExpr.assertArgsCount(name, this.args, 2);
            return XPathFuncExpr.formatDateTime(argVals[0], argVals[1]);
        }
        if (name.equals("abs")) {
            XPathFuncExpr.checkArity(name, 1, this.args.length);
            return Math.abs(XPathFuncExpr.toDouble(argVals[0]));
        }
        if (name.equals("acos")) {
            XPathFuncExpr.checkArity(name, 1, this.args.length);
            return Math.acos(XPathFuncExpr.toDouble(argVals[0]));
        }
        if (name.equals("asin")) {
            XPathFuncExpr.checkArity(name, 1, this.args.length);
            return Math.asin(XPathFuncExpr.toDouble(argVals[0]));
        }
        if (name.equals("atan")) {
            XPathFuncExpr.checkArity(name, 1, this.args.length);
            return Math.atan(XPathFuncExpr.toDouble(argVals[0]));
        }
        if (name.equals("atan2")) {
            XPathFuncExpr.checkArity(name, 2, this.args.length);
            return Math.atan2(XPathFuncExpr.toDouble(argVals[0]), XPathFuncExpr.toDouble(argVals[1]));
        }
        if (name.equals("cos")) {
            XPathFuncExpr.checkArity(name, 1, this.args.length);
            return Math.cos(XPathFuncExpr.toDouble(argVals[0]));
        }
        if (name.equals("exp")) {
            XPathFuncExpr.checkArity(name, 1, this.args.length);
            return Math.exp(XPathFuncExpr.toDouble(argVals[0]));
        }
        if (name.equals("exp10")) {
            XPathFuncExpr.checkArity(name, 1, this.args.length);
            return Math.pow(10.0, XPathFuncExpr.toDouble(argVals[0]));
        }
        if (name.equals("log")) {
            XPathFuncExpr.checkArity(name, 1, this.args.length);
            return Math.log(XPathFuncExpr.toDouble(argVals[0]));
        }
        if (name.equals("log10")) {
            XPathFuncExpr.checkArity(name, 1, this.args.length);
            return Math.log10(XPathFuncExpr.toDouble(argVals[0]));
        }
        if (name.equals("pi")) {
            XPathFuncExpr.checkArity(name, 0, this.args.length);
            return Math.PI;
        }
        if (name.equals("sin")) {
            XPathFuncExpr.checkArity(name, 1, this.args.length);
            return Math.sin(XPathFuncExpr.toDouble(argVals[0]));
        }
        if (name.equals("sqrt")) {
            XPathFuncExpr.checkArity(name, 1, this.args.length);
            return Math.sqrt(XPathFuncExpr.toDouble(argVals[0]));
        }
        if (name.equals("tan")) {
            XPathFuncExpr.checkArity(name, 1, this.args.length);
            return Math.tan(XPathFuncExpr.toDouble(argVals[0]));
        }
        if (name.equals("format-date-time")) {
            XPathFuncExpr.assertArgsCount(name, this.args, 2);
            return XPathFuncExpr.formatDateTime(argVals[0], argVals[1]);
        }
        if (name.equals("selected") || name.equals("is-selected")) {
            XPathFuncExpr.assertArgsCount(name, this.args, 2);
            return XPathFuncExpr.multiSelected(argVals[0], argVals[1], name);
        }
        if (name.equals("count-selected")) {
            XPathFuncExpr.assertArgsCount(name, this.args, 1);
            return XPathFuncExpr.countSelected(argVals[0]);
        }
        if (name.equals("selected-at")) {
            XPathFuncExpr.assertArgsCount(name, this.args, 2);
            return XPathFuncExpr.selectedAt(argVals[0], argVals[1]);
        }
        if (name.equals("position")) {
            if (this.args.length == 1) {
                XPathNodeset nodes = (XPathNodeset)argVals[0];
                if (nodes.size() == 0) {
                    return 0.0;
                }
                return this.position(nodes.getRefAt(0));
            }
            if (this.args.length == 0) {
                if (evalContext.getContextPosition() != -1) {
                    return (double)(1 + evalContext.getContextPosition());
                }
                return this.position(evalContext.getContextRef());
            }
            throw new XPathUnhandledException("function '" + name + "' requires either exactly one argument or no arguments. Only " + this.args.length + " provided.");
        }
        if (name.equals("count")) {
            XPathFuncExpr.assertArgsCount(name, this.args, 1);
            return XPathFuncExpr.count(argVals[0]);
        }
        if (name.equals("count-non-empty")) {
            XPathFuncExpr.assertArgsCount(name, this.args, 1);
            return XPathFuncExpr.countNonEmpty(argVals[0]);
        }
        if (name.equals("sum")) {
            XPathFuncExpr.assertArgsCount(name, this.args, 1);
            if (argVals[0] instanceof XPathNodeset) {
                return XPathFuncExpr.sum(((XPathNodeset)argVals[0]).toArgList());
            }
            throw new XPathTypeMismatchException("not a nodeset");
        }
        if (name.equals("max")) {
            if (this.args.length == 1 && argVals[0] instanceof XPathNodeset) {
                return XPathFuncExpr.max(((XPathNodeset)argVals[0]).toArgList());
            }
            return XPathFuncExpr.max(argVals);
        }
        if (name.equals("min")) {
            if (this.args.length == 1 && argVals[0] instanceof XPathNodeset) {
                return XPathFuncExpr.min(((XPathNodeset)argVals[0]).toArgList());
            }
            return XPathFuncExpr.min(argVals);
        }
        if (name.equals("today")) {
            XPathFuncExpr.assertArgsCount(name, this.args, 0);
            return DateUtils.roundDate(new Date());
        }
        if (name.equals("now")) {
            XPathFuncExpr.assertArgsCount(name, this.args, 0);
            return new DateTime().toDate();
        }
        if (name.equals("concat")) {
            if (this.args.length == 1 && argVals[0] instanceof XPathNodeset) {
                return XPathFuncExpr.join("", ((XPathNodeset)argVals[0]).toArgList());
            }
            return XPathFuncExpr.join("", argVals);
        }
        if (name.equals("join") && this.args.length >= 1) {
            if (this.args.length == 2 && argVals[1] instanceof XPathNodeset) {
                return XPathFuncExpr.join(argVals[0], ((XPathNodeset)argVals[1]).toArgList());
            }
            return XPathFuncExpr.join(argVals[0], XPathFuncExpr.subsetArgList(argVals, 1));
        }
        if (name.equals("substr") && (this.args.length == 2 || this.args.length == 3)) {
            return XPathFuncExpr.substring(argVals[0], argVals[1], this.args.length == 3 ? argVals[2] : null);
        }
        if (name.equals("substring-before") && this.args.length == 2) {
            String substr;
            String str = XPathFuncExpr.toString(argVals[0]);
            int pos = str.indexOf(substr = XPathFuncExpr.toString(argVals[1]));
            return pos >= 0 ? str.substring(0, pos) : "";
        }
        if (name.equals("substring-after") && this.args.length == 2) {
            String substr;
            String str = XPathFuncExpr.toString(argVals[0]);
            int pos = str.indexOf(substr = XPathFuncExpr.toString(argVals[1]));
            return pos >= 0 ? str.substring(pos + substr.length()) : "";
        }
        if (name.equals("translate") && this.args.length == 3) {
            String str = XPathFuncExpr.toString(argVals[0]);
            String fromChars = XPathFuncExpr.toString(argVals[1]);
            String toChars = XPathFuncExpr.toString(argVals[2]);
            int toNumChars = toChars.length();
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < str.length(); ++i) {
                char from = str.charAt(i);
                int fromPos = fromChars.indexOf(from);
                if (fromPos == -1) {
                    result.append(from);
                    continue;
                }
                if (fromPos >= toNumChars) continue;
                result.append(toChars.charAt(fromPos));
            }
            return result.toString();
        }
        if (name.equals("contains") && this.args.length == 2) {
            return XPathFuncExpr.toString(argVals[0]).contains(XPathFuncExpr.toString(argVals[1]));
        }
        if (name.equals("starts-with") && this.args.length == 2) {
            return XPathFuncExpr.toString(argVals[0]).startsWith(XPathFuncExpr.toString(argVals[1]));
        }
        if (name.equals("ends-with") && this.args.length == 2) {
            return XPathFuncExpr.toString(argVals[0]).endsWith(XPathFuncExpr.toString(argVals[1]));
        }
        if (name.equals("string-length") && this.args.length <= 1) {
            Object arg = this.args.length == 1 ? argVals[0] : XPathPathExpr.fromRef(evalContext.getContextRef()).eval(model, evalContext).unpack();
            return XPathFuncExpr.stringLength(arg);
        }
        if (name.equals("normalize-space") && this.args.length <= 1) {
            Object arg = this.args.length == 1 ? argVals[0] : XPathPathExpr.fromRef(evalContext.getContextRef()).eval(model, evalContext).unpack();
            return XPathFuncExpr.normalizeSpace(arg);
        }
        if (name.equals("checklist") && this.args.length >= 2) {
            if (this.args.length == 3 && argVals[2] instanceof XPathNodeset) {
                return XPathFuncExpr.checklist(argVals[0], argVals[1], ((XPathNodeset)argVals[2]).toArgList());
            }
            return XPathFuncExpr.checklist(argVals[0], argVals[1], XPathFuncExpr.subsetArgList(argVals, 2));
        }
        if (name.equals("weighted-checklist") && this.args.length >= 2 && this.args.length % 2 == 0) {
            if (this.args.length == 4 && argVals[2] instanceof XPathNodeset && argVals[3] instanceof XPathNodeset) {
                Object[] weights;
                Object[] factors = ((XPathNodeset)argVals[2]).toArgList();
                if (factors.length != (weights = ((XPathNodeset)argVals[3]).toArgList()).length) {
                    throw new XPathTypeMismatchException("weighted-checklist: nodesets not same length");
                }
                return XPathFuncExpr.checklistWeighted(argVals[0], argVals[1], factors, weights);
            }
            return XPathFuncExpr.checklistWeighted(argVals[0], argVals[1], XPathFuncExpr.subsetArgList(argVals, 2, 2), XPathFuncExpr.subsetArgList(argVals, 3, 2));
        }
        if (name.equals("regex")) {
            XPathFuncExpr.assertArgsCount(name, this.args, 2);
            return XPathFuncExpr.regex(argVals[0], argVals[1]);
        }
        if (name.equals("depend") && this.args.length >= 1) {
            return argVals[0];
        }
        if (name.equals("random")) {
            XPathFuncExpr.assertArgsCount(name, this.args, 0);
            return MathUtils.getRand().nextDouble();
        }
        if (name.equals("once")) {
            XPathFuncExpr.assertArgsCount(name, this.args, 1);
            XPathPathExpr currentFieldPathExpr = XPathPathExpr.fromRef(evalContext.getContextRef());
            Object currValue = currentFieldPathExpr.eval(model, evalContext).unpack();
            if (currValue == null || XPathFuncExpr.toString(currValue).length() == 0) {
                return argVals[0];
            }
            return currValue;
        }
        if (name.equals("uuid") && (this.args.length == 0 || this.args.length == 1)) {
            if (this.args.length == 0) {
                return PropertyUtils.genUUID();
            }
            int len = XPathFuncExpr.toInt(argVals[0]).intValue();
            return PropertyUtils.genGUID(len);
        }
        if (name.equals("version")) {
            XPathFuncExpr.assertArgsCount(name, this.args, 0);
            String formVersion = model instanceof FormInstance ? ((FormInstance)model).formVersion : "";
            return formVersion == null ? "" : formVersion;
        }
        if (name.equals("property")) {
            XPathFuncExpr.assertArgsCount(name, this.args, 1);
            String s = XPathFuncExpr.toString(argVals[0]);
            return PropertyManager.__().getSingularProperty(s);
        }
        if (name.equals("pow") && this.args.length == 2) {
            double a = XPathFuncExpr.toDouble(argVals[0]);
            double b = XPathFuncExpr.toDouble(argVals[1]);
            return Math.pow(a, b);
        }
        if (name.equals("enclosed-area") || name.equals("area")) {
            XPathFuncExpr.assertArgsCount(name, this.args, 1);
            List<GeoUtils.LatLong> latLongs = new XPathFuncExprGeo().getGpsCoordinatesFromNodeset(name, argVals[0]);
            return GeoUtils.calculateAreaOfGPSPolygonOnEarthInSquareMeters(latLongs);
        }
        if (name.equals("distance")) {
            XPathFuncExpr.assertArgsCount(name, this.args, 1);
            List<GeoUtils.LatLong> latLongs = new XPathFuncExprGeo().getGpsCoordinatesFromNodeset(name, argVals[0]);
            return GeoUtils.calculateDistance(latLongs);
        }
        if (name.equals("digest") && (this.args.length == 2 || this.args.length == 3)) {
            return DigestAlgorithm.from(XPathFuncExpr.toString(argVals[1])).digest(XPathFuncExpr.toString(argVals[0]), this.args.length == 3 ? Encoding.from(XPathFuncExpr.toString(argVals[2])) : Encoding.BASE64);
        }
        if (name.equals("randomize")) {
            if (!(argVals[0] instanceof XPathNodeset)) {
                throw new XPathTypeMismatchException("First argument to randomize must be a nodeset");
            }
            if (this.args.length == 1) {
                return XPathNodeset.shuffle((XPathNodeset)argVals[0]);
            }
            if (this.args.length == 2) {
                return XPathNodeset.shuffle((XPathNodeset)argVals[0], XPathFuncExpr.toNumeric(argVals[1]).longValue());
            }
            throw new XPathUnhandledException("function 'randomize' requires 1 or 2 arguments. " + this.args.length + " provided.");
        }
        if (name.equals("base64-decode")) {
            XPathFuncExpr.assertArgsCount(name, this.args, 1);
            return XPathFuncExpr.base64Decode(argVals[0]);
        }
        if (name.equals("extract-signed")) {
            XPathFuncExpr.assertArgsCount(name, this.args, 2);
            return XPathFuncExpr.extractSigned(argVals[0], argVals[1]);
        }
        IFunctionHandler handler = funcHandlers.get(name);
        if (handler != null) {
            return XPathFuncExpr.evalCustomFunction(handler, argVals, evalContext);
        }
        IFallbackFunctionHandler fallbackHandler = evalContext.getFallbackFunctionHandler();
        if (fallbackHandler != null) {
            return XPathFuncExpr.evalCustomFunction(fallbackHandler, name, argVals, evalContext);
        }
        throw new XPathUnhandledException("function '" + name + "'");
    }

    private static void assertArgsCount(String name, Object[] args, int count) {
        if (args.length != count) {
            throw new XPathUnhandledException("function '" + name + "'. Requires " + count + " arguments but " + args.length + " provided.");
        }
    }

    private static Object evalCustomFunction(IFunctionHandler handler, Object[] args, EvaluationContext ec) {
        List<Class[]> prototypes = handler.getPrototypes();
        Object[] typedArgs = null;
        int i = 0;
        while (typedArgs == null && prototypes.size() > i) {
            typedArgs = XPathFuncExpr.matchPrototype(args, prototypes.get(i++));
        }
        if (typedArgs != null) {
            return handler.eval(typedArgs, ec);
        }
        if (handler.rawArgs()) {
            return handler.eval(args, ec);
        }
        throw new XPathTypeMismatchException("for function '" + handler.getName() + "'");
    }

    private static Object evalCustomFunction(IFallbackFunctionHandler handler, String name, Object[] args, EvaluationContext ec) {
        return handler.eval(name, args, ec);
    }

    private static Object[] matchPrototype(Object[] args, Class[] prototype) {
        Object[] typed = null;
        if (prototype.length == args.length) {
            typed = new Object[args.length];
            for (int i = 0; i < prototype.length; ++i) {
                typed[i] = null;
                if (prototype[i].isAssignableFrom(args[i].getClass())) {
                    typed[i] = args[i];
                } else {
                    try {
                        if (prototype[i] == Boolean.class) {
                            typed[i] = XPathFuncExpr.toBoolean(args[i]);
                        } else if (prototype[i] == Double.class) {
                            typed[i] = XPathFuncExpr.toNumeric(args[i]);
                        } else if (prototype[i] == String.class) {
                            typed[i] = XPathFuncExpr.toString(args[i]);
                        } else if (prototype[i] == Date.class) {
                            typed[i] = XPathFuncExpr.toDate(args[i], false);
                        }
                    }
                    catch (XPathTypeMismatchException xPathTypeMismatchException) {
                        // empty catch block
                    }
                }
                if (typed[i] != null) continue;
                return null;
            }
        }
        return typed;
    }

    public static boolean isNull(Object o) {
        if (o == null) {
            return true;
        }
        if ((o = XPathFuncExpr.unpack(o)) instanceof String && ((String)o).length() == 0) {
            return true;
        }
        return o instanceof Double && ((Double)o).isNaN();
    }

    public static Double stringLength(Object o) {
        String s = XPathFuncExpr.toString(o);
        if (s == null) {
            return 0.0;
        }
        return s.length();
    }

    public static String normalizeSpace(Object o) {
        String s = XPathFuncExpr.toString(o);
        String normalized = s.trim().replaceAll("\\s+", " ");
        return normalized;
    }

    public static Boolean toBoolean(Object o) {
        Boolean val = null;
        if ((o = XPathFuncExpr.unpack(o)) instanceof Boolean) {
            val = (Boolean)o;
        } else if (o instanceof Double) {
            double d = (Double)o;
            val = Math.abs(d) > 1.0E-12 && !Double.isNaN(d);
        } else if (o instanceof String) {
            String s = (String)o;
            val = s.length() > 0;
        } else if (o instanceof Date) {
            val = Boolean.TRUE;
        } else if (o instanceof IExprDataType) {
            val = ((IExprDataType)o).toBoolean();
        }
        if (val != null) {
            return val;
        }
        throw new XPathTypeMismatchException("converting to boolean");
    }

    public static Double toDouble(Object o) {
        if (o instanceof Date) {
            return DateUtils.fractionalDaysSinceEpoch((Date)o);
        }
        return XPathFuncExpr.toNumeric(o);
    }

    public static Double toNumeric(Object o) {
        Double val = null;
        if ((o = XPathFuncExpr.unpack(o)) instanceof Boolean) {
            val = (Boolean)o != false ? 1 : 0;
        } else if (o instanceof Double) {
            val = (Double)o;
        } else if (o instanceof String) {
            String s = ((String)o).replace(',', '.').trim();
            try {
                for (int i = 0; i < s.length(); ++i) {
                    char c = s.charAt(i);
                    if (c == '-' || c == '.' || c >= '0' && c <= '9') continue;
                    throw new NumberFormatException();
                }
                val = Double.parseDouble(s);
            }
            catch (NumberFormatException nfe) {
                val = Double.NaN;
            }
        } else if (o instanceof Date) {
            val = DateUtils.daysSinceEpoch((Date)o);
        } else if (o instanceof IExprDataType) {
            val = ((IExprDataType)o).toNumeric();
        }
        if (val != null) {
            return val;
        }
        throw new XPathTypeMismatchException("converting to numeric");
    }

    public static Double toInt(Object o) {
        Double val = XPathFuncExpr.toNumeric(o);
        if (val.isInfinite() || val.isNaN()) {
            return val;
        }
        if (val >= 9.223372036854776E18 || val <= -9.223372036854776E18) {
            return val;
        }
        long l = val.longValue();
        Double dbl = l;
        if (l == 0L && (val < 0.0 || val.equals(-0.0))) {
            dbl = -0.0;
        }
        return dbl;
    }

    public static String toString(Object o) {
        String val = null;
        if ((o = XPathFuncExpr.unpack(o)) instanceof Boolean) {
            val = (Boolean)o != false ? "true" : "false";
        } else if (o instanceof Double) {
            double d = (Double)o;
            val = Double.isNaN(d) ? "NaN" : (Math.abs(d) < 1.0E-12 ? "0" : (Double.isInfinite(d) ? (d < 0.0 ? "-" : "") + "Infinity" : (Math.abs(d - (double)((int)d)) < 1.0E-12 ? String.valueOf((int)d) : String.valueOf(d))));
        } else if (o instanceof String) {
            val = (String)o;
        } else if (o instanceof Date) {
            val = DateUtils.formatDate((Date)o, 1);
        } else if (o instanceof IExprDataType) {
            val = ((IExprDataType)o).toString();
        }
        if (val != null) {
            return val;
        }
        throw new XPathTypeMismatchException("converting to string");
    }

    public static Object toDate(Object input, boolean preserveTime) {
        if ((input = XPathFuncExpr.unpack(input)) instanceof Double) {
            if (preserveTime) {
                Double n = (Double)input;
                if (n.isNaN()) {
                    return n;
                }
                if (n.isInfinite() || n > 2.147483647E9 || n < -2.147483648E9) {
                    throw new XPathTypeMismatchException("The value \"" + n + "\" is out of range for representing a date.");
                }
                long timeMillis = (long)(n * 8.64E7);
                Date d = new Date(timeMillis);
                return d;
            }
            Double n = XPathFuncExpr.toInt(input);
            if (n.isNaN()) {
                return n;
            }
            if (n.isInfinite() || n > 2.147483647E9 || n < -2.147483648E9) {
                throw new XPathTypeMismatchException("The value \"" + n + "\" is out of range for representing a date.");
            }
            return DateUtils.dateAdd(DateUtils.getDate(1970, 1, 1), n.intValue());
        }
        if (input instanceof String) {
            String s = (String)input;
            if (s.length() == 0) {
                return s;
            }
            Date d = DateUtils.parseDateTime(s);
            if (d == null) {
                throw new XPathTypeMismatchException("The value \"" + s + "\" can't be converted to a date.");
            }
            return d;
        }
        if (input instanceof Date) {
            if (preserveTime) {
                return (Date)input;
            }
            return DateUtils.roundDate((Date)input);
        }
        throw new XPathTypeMismatchException("The value \"" + input.toString() + "\" can't be converted to a date.");
    }

    public static Object toDecimalDateTime(Object o, boolean keepDate) {
        if ((o = XPathFuncExpr.unpack(o)) instanceof Double) {
            Double n = (Double)o;
            if (n.isNaN()) {
                return n;
            }
            if (n.isInfinite() || n > 2.147483647E9 || n < -2.147483648E9) {
                throw new XPathTypeMismatchException("The value \"" + n + "\" is out of range for representing a date.");
            }
            if (keepDate) {
                return n;
            }
            return n - Math.floor(n);
        }
        if (o instanceof String) {
            String s = (String)o;
            if (s.length() == 0) {
                return s;
            }
            Date d = DateUtils.parseDateTime(s);
            if (d == null) {
                throw new XPathTypeMismatchException("The value \"" + s + "\" can't be converted to a date.");
            }
            if (keepDate) {
                long milli = d.getTime();
                Double v = (double)milli / 8.64E7;
                return v;
            }
            return DateUtils.decimalTimeOfLocalDay(d);
        }
        if (o instanceof Date) {
            Date d = (Date)o;
            if (keepDate) {
                long milli = d.getTime();
                Double v = (double)milli / 8.64E7;
                return v;
            }
            return DateUtils.decimalTimeOfLocalDay(d);
        }
        throw new XPathTypeMismatchException("The value \"" + o.toString() + "\" can't be converted to a date.");
    }

    public static Boolean boolNot(Object o) {
        boolean b = XPathFuncExpr.toBoolean(o);
        return !b;
    }

    public static Boolean boolStr(Object o) {
        String s = XPathFuncExpr.toString(o);
        if (s.equalsIgnoreCase("true") || s.equals("1")) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static String formatDateTime(Object inputValue, Object format) {
        Object parseResult = XPathFuncExpr.toDate(inputValue, true);
        return parseResult instanceof Date ? DateUtils.format((Date)parseResult, XPathFuncExpr.toString(format)) : "";
    }

    private Double position(TreeReference refAt) {
        return 1 + refAt.getMultLast();
    }

    public static Object ifThenElse(DataInstance model, EvaluationContext ec, XPathExpression[] args, Object[] argVals) {
        argVals[0] = args[0].eval(model, ec);
        boolean b = XPathFuncExpr.toBoolean(argVals[0]);
        return b ? args[1].eval(model, ec) : args[2].eval(model, ec);
    }

    public static Object indexedRepeat(DataInstance model, EvaluationContext ec, XPathExpression[] args, Object[] argVals) throws XPathTypeMismatchException {
        if (!(args[0] instanceof XPathPathExpr)) {
            throw new XPathTypeMismatchException("indexed-repeat(): first parameter must be XPath field reference");
        }
        XPathPathExpr targetPath = (XPathPathExpr)args[0];
        TreeReference targetRef = targetPath.getReference().contextualize(ec.getContextRef());
        TreeReference contextRef = targetRef.clone();
        int pathargi = 1;
        for (int idxargi = 2; idxargi < args.length; idxargi += 2) {
            if (!(args[pathargi] instanceof XPathPathExpr)) {
                throw new XPathTypeMismatchException("indexed-repeat(): parameter " + (pathargi + 1) + " must be XPath repeat-group reference");
            }
            TreeReference groupRef = ((XPathPathExpr)args[pathargi]).getReference().contextualize(ec.getContextRef());
            if (!groupRef.isAncestorOf(targetRef, true)) {
                throw new XPathTypeMismatchException("indexed-repeat(): parameter " + (pathargi + 1) + " must be a parent of the field in parameter 1");
            }
            int groupIdx = XPathFuncExpr.toInt(args[idxargi].eval(model, ec)).intValue();
            if (groupIdx <= 0) {
                groupIdx = 1;
            }
            contextRef.setMultiplicity(groupRef.size() - 1, groupIdx - 1);
            pathargi += 2;
        }
        EvaluationContext revisedec = new EvaluationContext(ec, contextRef);
        return XPathPathExpr.fromRef(targetRef).eval(revisedec);
    }

    public static Boolean multiSelected(Object o1, Object o2, String functionName) {
        Object indexObject = XPathFuncExpr.unpack(o2);
        if (!(indexObject instanceof String)) {
            throw new XPathTypeMismatchException("The second parameter to the " + functionName + "() function must be in quotes (like '1').");
        }
        String s1 = (String)XPathFuncExpr.unpack(o1);
        String s2 = ((String)indexObject).trim();
        return (" " + s1 + " ").contains(" " + s2 + " ");
    }

    public static Double countSelected(Object o) {
        String s = (String)XPathFuncExpr.unpack(o);
        return DateUtils.split(s, " ", true).size();
    }

    public static String selectedAt(Object o1, Object o2) {
        String selection = (String)XPathFuncExpr.unpack(o1);
        int index = XPathFuncExpr.toInt(o2).intValue();
        List<String> stringVector = DateUtils.split(selection, " ", true);
        if (stringVector.size() > index && index >= 0) {
            return stringVector.get(index);
        }
        return "";
    }

    public static Double count(Object o) {
        if (o instanceof XPathNodeset) {
            return ((XPathNodeset)o).size();
        }
        throw new XPathTypeMismatchException("not a nodeset");
    }

    private static Double countNonEmpty(Object o) {
        if (o instanceof XPathNodeset) {
            return ((XPathNodeset)o).getNonEmptySize();
        }
        throw new XPathTypeMismatchException("not a nodeset");
    }

    public static Double sum(Object[] argVals) {
        double sum = 0.0;
        for (Object argVal : argVals) {
            Double dargVal = XPathFuncExpr.toNumeric(argVal);
            if (dargVal.isNaN()) continue;
            sum += dargVal.doubleValue();
        }
        return sum;
    }

    private static Double round(double number, int numDecimals) {
        if (Double.isNaN(number) || Double.isInfinite(number)) {
            return number;
        }
        if (numDecimals > 30 || numDecimals < -30) {
            return Double.NaN;
        }
        if (numDecimals >= 0) {
            try {
                int method = number < 0.0 ? 5 : 4;
                return new BigDecimal(Double.toString(number)).setScale(numDecimals, method).doubleValue();
            }
            catch (NumberFormatException ex) {
                if (Double.isInfinite(number)) {
                    return number;
                }
                return Double.NaN;
            }
        }
        BigDecimal numScaled = BigDecimal.valueOf(number).scaleByPowerOfTen(numDecimals);
        BigDecimal numRounded = BigDecimal.valueOf((double)((long)(numScaled.doubleValue() + 0.5)));
        return numRounded.scaleByPowerOfTen(-numDecimals).doubleValue();
    }

    private static Object max(Object[] argVals) {
        double max = Double.MIN_VALUE;
        boolean returnNaN = true;
        for (Object argVal : argVals) {
            Double dargVal = XPathFuncExpr.toNumeric(argVal);
            if (dargVal.isNaN()) continue;
            max = Math.max(max, dargVal);
            returnNaN = false;
        }
        return returnNaN ? Double.NaN : max;
    }

    private static Object min(Object[] argVals) {
        double min = Double.MAX_VALUE;
        boolean returnNaN = true;
        for (Object argVal : argVals) {
            Double dargVal = XPathFuncExpr.toNumeric(argVal);
            if (dargVal.isNaN()) continue;
            min = Math.min(min, dargVal);
            returnNaN = false;
        }
        return returnNaN ? Double.NaN : min;
    }

    public static String join(Object oSep, Object[] argVals) {
        String sep = XPathFuncExpr.toString(oSep);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < argVals.length; ++i) {
            sb.append(XPathFuncExpr.toString(argVals[i]));
            if (i >= argVals.length - 1) continue;
            sb.append(sep);
        }
        return sb.toString();
    }

    public static String substring(Object o1, Object o2, Object o3) {
        int end;
        String s = XPathFuncExpr.toString(o1);
        int start = XPathFuncExpr.toInt(o2).intValue();
        int len = s.length();
        int n = end = o3 != null ? XPathFuncExpr.toInt(o3).intValue() : len;
        if (start < 0) {
            start = len + start;
        }
        if (end < 0) {
            end = len + end;
        }
        end = Math.min(Math.max(0, end), len);
        return (start = Math.min(Math.max(0, start), len)) <= end ? s.substring(start, end) : "";
    }

    public static Boolean checklist(Object oMin, Object oMax, Object[] factors) {
        int min = XPathFuncExpr.toNumeric(oMin).intValue();
        int max = XPathFuncExpr.toNumeric(oMax).intValue();
        int count = 0;
        for (Object factor : factors) {
            if (!XPathFuncExpr.toBoolean(factor).booleanValue()) continue;
            ++count;
        }
        return !(min >= 0 && count < min || max >= 0 && count > max);
    }

    public static Boolean checklistWeighted(Object oMin, Object oMax, Object[] flags, Object[] weights) {
        double min = XPathFuncExpr.toNumeric(oMin);
        double max = XPathFuncExpr.toNumeric(oMax);
        double sum = 0.0;
        for (int i = 0; i < flags.length; ++i) {
            boolean flag = XPathFuncExpr.toBoolean(flags[i]);
            double weight = XPathFuncExpr.toNumeric(weights[i]);
            if (!flag) continue;
            sum += weight;
        }
        return sum >= min && sum <= max;
    }

    public static Boolean regex(Object o1, Object o2) {
        String str = XPathFuncExpr.toString(o1);
        String re = XPathFuncExpr.toString(o2);
        return Pattern.matches(re, str);
    }

    private static String base64Decode(Object o1) {
        String base64String = XPathFuncExpr.toString(o1);
        byte[] decoded = Encoding.BASE64.decode(base64String.getBytes(StandardCharsets.UTF_8));
        return new String(decoded, StandardCharsets.UTF_8);
    }

    private static String extractSigned(Object o1, Object o2) {
        byte[] decodedPublicKey;
        byte[] decodedContents = Base64.decode(XPathFuncExpr.toString(o1).getBytes());
        String extracted = Ed25519.extractSigned(decodedContents, decodedPublicKey = Base64.decode(XPathFuncExpr.toString(o2).getBytes()));
        if (extracted != null) {
            return extracted;
        }
        return "";
    }

    private static Object[] subsetArgList(Object[] args, int start) {
        return XPathFuncExpr.subsetArgList(args, start, 1);
    }

    private static Object[] subsetArgList(Object[] args, int start, int skip) {
        if (start > args.length || skip < 1) {
            throw new RuntimeException("error in subsetting arglist");
        }
        Object[] subargs = new Object[(int)MathUtils.divLongNotSuck(args.length - start - 1, skip) + 1];
        int i = start;
        int j = 0;
        while (i < args.length) {
            subargs[j] = args[i];
            i += skip;
            ++j;
        }
        return subargs;
    }

    public static Object unpack(Object o) {
        if (o instanceof XPathNodeset) {
            return ((XPathNodeset)o).unpack();
        }
        return o;
    }

    private static void checkArity(String name, int expectedArity, int providedArity) throws XPathArityException {
        if (expectedArity != providedArity) {
            throw new XPathArityException(name, expectedArity, providedArity);
        }
    }

    @Override
    public Object pivot(DataInstance model, EvaluationContext evalContext, List<Object> pivots, Object sentinal) throws UnpivotableExpressionException {
        String name = this.id.toString();
        Object[] argVals = new Object[this.args.length];
        String[] identities = new String[]{"string-length"};
        boolean id = false;
        for (String identity : identities) {
            if (!identity.equals(name)) continue;
            id = true;
        }
        for (int i = 0; i < this.args.length; ++i) {
            argVals[i] = this.args[i].pivot(model, evalContext, pivots, sentinal);
        }
        boolean pivoted = false;
        for (Object argVal : argVals) {
            if (argVal == null) {
                pivoted = true;
                continue;
            }
            if (!sentinal.equals(argVal)) continue;
            if (id) {
                return sentinal;
            }
            throw new UnpivotableExpressionException();
        }
        if (pivoted) {
            if (id) {
                return null;
            }
            throw new UnpivotableExpressionException();
        }
        return this.eval(model, evalContext);
    }

    @Override
    public boolean isIdempotent() {
        return Arrays.asList(IDEMPOTENT_FUNCTIONS).contains(this.id.toString()) && Arrays.stream(this.args).allMatch(XPathExpression::isIdempotent);
    }

    @Override
    public boolean containsFunc(@NotNull String name) {
        return name.equals(this.id.name) || Arrays.stream(this.args).anyMatch(expression -> expression.containsFunc(name));
    }
}

