/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.javarosa.core.model.CompareToNodeExpression;
import org.javarosa.core.model.condition.EvaluationContext;
import org.javarosa.core.model.condition.FilterStrategy;
import org.javarosa.core.model.instance.DataInstance;
import org.javarosa.core.model.instance.TreeReference;
import org.javarosa.measure.Measure;
import org.javarosa.xpath.expr.XPathEqExpr;
import org.javarosa.xpath.expr.XPathExpression;
import org.jetbrains.annotations.NotNull;

public class EqualityExpressionIndexFilterStrategy
implements FilterStrategy {
    private final InMemTreeReferenceIndex index = new InMemTreeReferenceIndex();

    @Override
    @NotNull
    public List<TreeReference> filter(@NotNull DataInstance sourceInstance, @NotNull TreeReference nodeSet, @NotNull XPathExpression predicate, @NotNull List<TreeReference> children, @NotNull EvaluationContext evaluationContext, @NotNull Supplier<List<TreeReference>> next) {
        if (sourceInstance.getInstanceId() == null || !(predicate instanceof XPathEqExpr)) {
            return next.get();
        }
        CompareToNodeExpression candidate = CompareToNodeExpression.parse(predicate);
        if (candidate != null) {
            XPathEqExpr original = (XPathEqExpr)candidate.getOriginal();
            if (original.isEqual()) {
                String section = nodeSet + candidate.getNodeSide().toString();
                this.buildIndexIfNeeded(sourceInstance, candidate, children, evaluationContext, section);
                Object absoluteValue = candidate.evalContextSide(sourceInstance, evaluationContext);
                if (absoluteValue instanceof String) {
                    return this.index.lookup(section, (String)absoluteValue);
                }
                return next.get();
            }
            return next.get();
        }
        return next.get();
    }

    private synchronized void buildIndexIfNeeded(DataInstance sourceInstance, CompareToNodeExpression predicate, List<TreeReference> children, EvaluationContext evaluationContext, String section) {
        if (!this.index.contains(section)) {
            for (int i = 0; i < children.size(); ++i) {
                TreeReference child = children.get(i);
                Measure.log("IndexEvaluation");
                String relativeValue = predicate.evalNodeSide(sourceInstance, evaluationContext, child, i).toString();
                this.index.add(section, relativeValue, child);
            }
        }
    }

    private static class InMemTreeReferenceIndex {
        private final Map<String, Map<String, List<TreeReference>>> map = new HashMap<String, Map<String, List<TreeReference>>>();

        private InMemTreeReferenceIndex() {
        }

        public boolean contains(String section) {
            return this.map.containsKey(section);
        }

        public void add(String section, String item, TreeReference reference) {
            Map<String, List<TreeReference>> sectionMap;
            if (!this.map.containsKey(section)) {
                this.map.put(section, new HashMap());
            }
            if (!(sectionMap = this.map.get(section)).containsKey(item)) {
                sectionMap.put(item, new ArrayList());
            }
            sectionMap.get(item).add(reference);
        }

        public List<TreeReference> lookup(String section, String item) {
            if (this.map.containsKey(section) && this.map.get(section).containsKey(item)) {
                return this.map.get(section).get(item);
            }
            return Collections.emptyList();
        }
    }
}

