/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model.instance.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.javarosa.core.model.instance.TreeElement;
import org.javarosa.core.model.instance.utils.TreeElementNameComparator;
import org.jetbrains.annotations.Nullable;

public class TreeElementChildrenList
implements Iterable<TreeElement> {
    private final List<TreeElement> children = new ArrayList<TreeElement>();
    private boolean allHaveSameNameAndNormalMult = true;

    public int size() {
        return this.children.size();
    }

    @Override
    public Iterator<TreeElement> iterator() {
        return this.children.iterator();
    }

    public void add(int index, TreeElement child) {
        this.checkAndSetSameNameAndNormalMult(child.getName(), child.getMultiplicity());
        this.children.add(index, child);
    }

    public void addAll(Iterable<TreeElement> childIterable) {
        for (TreeElement child : childIterable) {
            this.checkAndSetSameNameAndNormalMult(child.getName(), child.getMultiplicity());
            this.children.add(child);
        }
    }

    public void addInOrder(TreeElement child) {
        int newIndexAdjustment;
        int searchMultiplicity;
        int childMultiplicity = child.getMultiplicity();
        if (childMultiplicity == -2) {
            searchMultiplicity = 0;
            newIndexAdjustment = 0;
        } else {
            searchMultiplicity = childMultiplicity == 0 ? -2 : childMultiplicity - 1;
            newIndexAdjustment = 1;
        }
        ElementAndLoc el = this.getChildAndLoc(child.getName(), searchMultiplicity);
        int newIndex = el == null ? this.children.size() : el.index + newIndexAdjustment;
        this.checkAndSetSameNameAndNormalMult(child.getName(), child.getMultiplicity());
        this.children.add(newIndex, child);
    }

    public TreeElement get(int index) {
        return this.children.get(index);
    }

    public List<TreeElement> get(String name) {
        ArrayList<TreeElement> children = new ArrayList<TreeElement>();
        this.findChildrenWithName(name, children);
        return children;
    }

    @Nullable
    public TreeElement get(String name, int multiplicity) {
        ElementAndLoc el = this.getChildAndLoc(name, multiplicity);
        if (el == null) {
            return null;
        }
        return el.treeElement;
    }

    public int getCount(String name) {
        return this.findChildrenWithName(name, null);
    }

    private void checkAndSetSameNameAndNormalMult(String name, int mult) {
        this.allHaveSameNameAndNormalMult = this.sameNameAndNormalMult(name, mult);
    }

    private boolean sameNameAndNormalMult(String name, int mult) {
        return this.allHaveSameNameAndNormalMult && mult >= 0 && (this.children.isEmpty() || name.equals(this.children.get(0).getName()));
    }

    private int findChildrenWithName(String name, List<TreeElement> results) {
        if (this.sameNameAndNormalMult(name, 0)) {
            if (results != null) {
                results.addAll(this.children);
            }
            return this.children.size();
        }
        int count = 0;
        for (TreeElement child : this.children) {
            if (child.getMultiplicity() == -2 || !TreeElementNameComparator.elementMatchesName(child, name)) continue;
            ++count;
            if (results == null) continue;
            results.add(child);
        }
        return count;
    }

    public TreeElement remove(int index) {
        return this.children.remove(index);
    }

    public boolean remove(TreeElement treeElement) {
        return this.children.remove(treeElement);
    }

    public void remove(String name, int multiplicity) {
        TreeElement child = this.get(name, multiplicity);
        if (child != null) {
            this.remove(child);
        }
    }

    public void removeAll(String name) {
        for (TreeElement child : this.get(name)) {
            this.remove(child);
        }
    }

    public void clear() {
        this.children.clear();
    }

    public boolean isEmpty() {
        return this.children.isEmpty();
    }

    private ElementAndLoc getChildAndLoc(String name, int multiplicity) {
        TreeElement childAtMultPos;
        if (name.equals("*")) {
            if (multiplicity == -2 || this.children.size() < multiplicity + 1) {
                return null;
            }
            return new ElementAndLoc(this.children.get(multiplicity), multiplicity);
        }
        if (this.sameNameAndNormalMult(name, multiplicity) && multiplicity < this.children.size() && (childAtMultPos = this.children.get(multiplicity)).getMultiplicity() == multiplicity) {
            return new ElementAndLoc(childAtMultPos, multiplicity);
        }
        for (int i = 0; i < this.children.size(); ++i) {
            TreeElement child = this.children.get(i);
            if (!name.equals(child.getName()) || child.getMult() != multiplicity) continue;
            return new ElementAndLoc(child, i);
        }
        return null;
    }

    private class ElementAndLoc {
        final TreeElement treeElement;
        final int index;

        ElementAndLoc(TreeElement treeElement, int index) {
            this.treeElement = treeElement;
            this.index = index;
        }
    }
}

