/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.xform.parse;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.javarosa.core.model.instance.CsvExternalInstance;
import org.javarosa.core.model.instance.TreeElement;
import org.javarosa.core.model.instance.XmlExternalInstance;
import org.javarosa.core.model.instance.geojson.GeoJsonExternalInstance;
import org.javarosa.core.reference.InvalidReferenceException;
import org.javarosa.core.reference.ReferenceManager;
import org.javarosa.xml.util.InvalidStructureException;
import org.javarosa.xml.util.UnfullfilledRequirementsException;
import org.jetbrains.annotations.NotNull;
import org.xmlpull.v1.XmlPullParserException;

public class ExternalInstanceParser {
    private List<ExternalDataInstanceProcessor> externalDataInstanceProcessors = new ArrayList<ExternalDataInstanceProcessor>();
    private List<FileInstanceParser> fileInstanceParsers = Arrays.asList(new CsvExternalInstance(), new GeoJsonExternalInstance());

    public TreeElement parse(ReferenceManager referenceManager, String instanceId, String instanceSrc) throws IOException, UnfullfilledRequirementsException, InvalidStructureException, XmlPullParserException, InvalidReferenceException {
        String path = ExternalInstanceParser.getPath(referenceManager, instanceSrc);
        Optional<FileInstanceParser> fileParser = this.fileInstanceParsers.stream().filter(fileInstanceParser -> fileInstanceParser.isSupported(instanceId, instanceSrc)).findFirst();
        TreeElement root = fileParser.isPresent() ? fileParser.get().parse(instanceId, path) : XmlExternalInstance.parse(instanceId, path);
        for (ExternalDataInstanceProcessor processor : this.externalDataInstanceProcessors) {
            processor.processInstance(instanceId, root);
        }
        return root;
    }

    public void addProcessor(Processor processor) {
        this.externalDataInstanceProcessors.add((ExternalDataInstanceProcessor)processor);
    }

    public void addFileInstanceParser(FileInstanceParser fileInstanceParser) {
        this.fileInstanceParsers = Stream.concat(Stream.of(fileInstanceParser), this.fileInstanceParsers.stream()).collect(Collectors.toList());
    }

    private static String getPath(ReferenceManager referenceManager, String srcLocation) throws InvalidReferenceException {
        String uri = referenceManager.deriveReference(srcLocation).getLocalURI();
        return uri.startsWith("//") ? uri.substring(1) : uri;
    }

    public static interface FileInstanceParser {
        public TreeElement parse(String var1, String var2) throws IOException;

        public boolean isSupported(String var1, String var2);
    }

    public static interface ExternalDataInstanceProcessor
    extends Processor {
        public void processInstance(@NotNull String var1, @NotNull TreeElement var2);
    }

    public static interface Processor {
    }
}

