/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model;

import java.util.Arrays;
import java.util.LinkedList;
import kotlin.Pair;
import org.javarosa.core.model.condition.EvaluationContext;
import org.javarosa.core.model.instance.DataInstance;
import org.javarosa.core.model.instance.TreeReference;
import org.javarosa.xpath.expr.XPathCmpExpr;
import org.javarosa.xpath.expr.XPathEqExpr;
import org.javarosa.xpath.expr.XPathExpression;
import org.javarosa.xpath.expr.XPathFuncExpr;
import org.javarosa.xpath.expr.XPathNumericLiteral;
import org.javarosa.xpath.expr.XPathPathExpr;
import org.javarosa.xpath.expr.XPathStringLiteral;
import org.jetbrains.annotations.Nullable;

public class CompareToNodeExpression {
    private final XPathPathExpr nodeSide;
    private final XPathExpression contextSide;
    private final XPathExpression original;

    public CompareToNodeExpression(XPathPathExpr nodeSide, XPathExpression contextSide, XPathExpression original) {
        this.nodeSide = nodeSide;
        this.contextSide = contextSide;
        this.original = original;
    }

    public Object evalNodeSide(DataInstance sourceInstance, EvaluationContext evaluationContext, TreeReference child, int childIndex) {
        EvaluationContext rescopedContext = evaluationContext.rescope(child, childIndex);
        return this.getNodeSide().eval(sourceInstance, rescopedContext).unpack();
    }

    public Object evalContextSide(DataInstance sourceInstance, EvaluationContext evaluationContext) {
        if (this.contextSide instanceof XPathPathExpr) {
            return ((XPathPathExpr)this.getContextSide()).eval(sourceInstance, evaluationContext).unpack();
        }
        return this.contextSide.eval(sourceInstance, evaluationContext);
    }

    public XPathPathExpr getNodeSide() {
        return this.nodeSide;
    }

    public XPathExpression getContextSide() {
        return this.contextSide;
    }

    public XPathExpression getOriginal() {
        return this.original;
    }

    @Nullable
    public static CompareToNodeExpression parse(XPathExpression expression) {
        XPathExpression a = null;
        XPathExpression b = null;
        if (expression instanceof XPathCmpExpr) {
            a = ((XPathCmpExpr)expression).a;
            b = ((XPathCmpExpr)expression).b;
        } else if (expression instanceof XPathEqExpr) {
            a = ((XPathEqExpr)expression).a;
            b = ((XPathEqExpr)expression).b;
        } else if (expression instanceof XPathFuncExpr && expression.isIdempotent() && ((XPathFuncExpr)expression).args.length == 2) {
            a = ((XPathFuncExpr)expression).args[0];
            b = ((XPathFuncExpr)expression).args[1];
        }
        Pair<XPathPathExpr, XPathExpression> nodeAndContextSides = CompareToNodeExpression.getNodeAndContextSides(a, b);
        if (nodeAndContextSides != null) {
            return new CompareToNodeExpression((XPathPathExpr)nodeAndContextSides.getFirst(), (XPathExpression)nodeAndContextSides.getSecond(), expression);
        }
        return null;
    }

    private static Pair<XPathPathExpr, XPathExpression> getNodeAndContextSides(XPathExpression a, XPathExpression b) {
        XPathPathExpr node = null;
        XPathExpression context = null;
        LinkedList<XPathExpression> subExpressions = new LinkedList<XPathExpression>(Arrays.asList(a, b));
        while (!subExpressions.isEmpty()) {
            XPathExpression subExpression = (XPathExpression)subExpressions.poll();
            if (subExpression instanceof XPathPathExpr) {
                if (((XPathPathExpr)subExpression).init_context == 1) {
                    node = (XPathPathExpr)subExpression;
                    continue;
                }
                context = subExpression;
                continue;
            }
            if (!(subExpression instanceof XPathNumericLiteral) && !(subExpression instanceof XPathStringLiteral)) continue;
            context = subExpression;
        }
        if (node != null && context != null) {
            return new Pair(node, context);
        }
        return null;
    }
}

