/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model.instance.geojson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.javarosa.core.model.instance.TreeElement;
import org.javarosa.core.model.instance.geojson.GeojsonFeature;
import org.javarosa.xform.parse.ExternalInstanceParser;

public class GeoJsonExternalInstance
implements ExternalInstanceParser.FileInstanceParser {
    @Override
    public TreeElement parse(String instanceId, String path) throws IOException {
        TreeElement root = new TreeElement("root", 0);
        root.setInstanceName(instanceId);
        ObjectMapper objectMapper = new ObjectMapper();
        try (JsonParser jsonParser = objectMapper.getFactory().createParser((InputStream)new FileInputStream(path));){
            if (jsonParser.nextToken() != JsonToken.START_OBJECT) {
                throw new IOException("GeoJSON file must contain a top-level Object");
            }
            boolean typeValidated = false;
            boolean featuresIdentified = false;
            while (!(!jsonParser.hasCurrentToken() || typeValidated && featuresIdentified)) {
                String propertyName = jsonParser.nextFieldName();
                JsonToken propertyType = jsonParser.nextValue();
                if (Objects.equals(propertyName, "type") && propertyType == JsonToken.VALUE_STRING && Objects.equals(jsonParser.getValueAsString(), "FeatureCollection")) {
                    typeValidated = true;
                    continue;
                }
                if (Objects.equals(propertyName, "features") && propertyType.equals((Object)JsonToken.START_ARRAY)) {
                    int multiplicity = 0;
                    while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                        GeojsonFeature feature = (GeojsonFeature)objectMapper.readValue(jsonParser, GeojsonFeature.class);
                        root.addChild(feature.toTreeElement(multiplicity));
                        ++multiplicity;
                    }
                    featuresIdentified = true;
                    continue;
                }
                jsonParser.skipChildren();
            }
            if (!typeValidated) {
                throw new IOException("GeoJSON file must contain a top-level FeatureCollection");
            }
            if (!featuresIdentified) {
                throw new IOException("GeoJSON FeatureCollection must contain an array of features");
            }
        }
        return root;
    }

    @Override
    public boolean isSupported(String instanceId, String instanceSrc) {
        return instanceSrc.endsWith("geojson");
    }
}

