/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.util;

import java.nio.charset.StandardCharsets;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import org.bouncycastle.crypto.signers.Ed25519Signer;
import org.jetbrains.annotations.Nullable;

public class Ed25519 {
    private static final int SIGNATURE_LENGTH = 64;

    @Nullable
    public static String extractSigned(byte[] contents, byte[] publicKey) {
        if (contents.length < 64) {
            return null;
        }
        byte[] signature = new byte[64];
        System.arraycopy(contents, 0, signature, 0, 64);
        int messageLength = contents.length - 64;
        byte[] message = new byte[messageLength];
        System.arraycopy(contents, 64, message, 0, messageLength);
        if (Ed25519.verify(publicKey, signature, message)) {
            return new String(message, StandardCharsets.UTF_8);
        }
        return null;
    }

    private static boolean verify(byte[] publicKey, byte[] signature, byte[] message) {
        try {
            Ed25519PublicKeyParameters publicKeyParameters = new Ed25519PublicKeyParameters(publicKey, 0);
            Ed25519Signer signer = new Ed25519Signer();
            signer.init(false, (CipherParameters)publicKeyParameters);
            signer.update(message, 0, message.length);
            return signer.verifySignature(signature);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return false;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

