/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model.data;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.javarosa.core.model.data.IAnswerData;
import org.javarosa.core.model.data.UncastData;
import org.javarosa.core.util.externalizable.PrototypeFactory;
import org.jetbrains.annotations.NotNull;

public class BooleanData
implements IAnswerData {
    boolean data;

    public BooleanData() {
    }

    public BooleanData(boolean data) {
        this.data = data;
    }

    @Override
    public IAnswerData clone() {
        return new BooleanData(this.data);
    }

    @Override
    public String getDisplayText() {
        if (this.data) {
            return "True";
        }
        return "False";
    }

    @Override
    @NotNull
    public Object getValue() {
        return this.data;
    }

    @Override
    public void setValue(@NotNull Object o) {
        this.data = (Boolean)o;
    }

    @Override
    public void readExternal(DataInputStream in, PrototypeFactory pf) throws IOException {
        this.data = in.readBoolean();
    }

    @Override
    public void writeExternal(DataOutputStream out) throws IOException {
        out.writeBoolean(this.data);
    }

    @Override
    public UncastData uncast() {
        return new UncastData(this.data ? "1" : "0");
    }

    @Override
    public BooleanData cast(UncastData data) throws IllegalArgumentException {
        if ("1".equals(data)) {
            return new BooleanData(true);
        }
        if ("0".equals(data)) {
            return new BooleanData(false);
        }
        throw new IllegalArgumentException("Invalid cast of data [" + data.value + "] to type Boolean");
    }

    public String toString() {
        return "BooleanData{data=" + this.data + '}';
    }
}

