/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model.data;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.javarosa.core.data.IDataPointer;
import org.javarosa.core.model.data.IAnswerData;
import org.javarosa.core.model.data.UncastData;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.ExtWrapTagged;
import org.javarosa.core.util.externalizable.PrototypeFactory;
import org.jetbrains.annotations.NotNull;

public class MultiPointerAnswerData
implements IAnswerData {
    private IDataPointer[] data;

    public MultiPointerAnswerData() {
    }

    public MultiPointerAnswerData(IDataPointer[] values) {
        this.data = values;
    }

    @Override
    public String getDisplayText() {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < this.data.length; ++i) {
            if (i != 0) {
                b.append(", ");
            }
            b.append(this.data[i].getDisplayText());
        }
        return b.toString();
    }

    @Override
    @NotNull
    public Object getValue() {
        return this.data;
    }

    @Override
    public void setValue(@NotNull Object o) {
        if (o == null) {
            throw new NullPointerException("Attempt to set an IAnswerData class to null.");
        }
        this.data = (IDataPointer[])o;
    }

    @Override
    public IAnswerData clone() {
        return null;
    }

    @Override
    public void readExternal(DataInputStream in, PrototypeFactory pf) throws IOException, DeserializationException {
        int length = in.readInt();
        this.data = new IDataPointer[length];
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = (IDataPointer)ExtUtil.read(in, new ExtWrapTagged());
        }
    }

    @Override
    public void writeExternal(DataOutputStream out) throws IOException {
        out.writeInt(this.data.length);
        for (IDataPointer aData : this.data) {
            ExtUtil.write(out, new ExtWrapTagged(aData));
        }
    }

    @Override
    public UncastData uncast() {
        StringBuilder b = new StringBuilder();
        for (IDataPointer datum : this.data) {
            b.append(datum.getDisplayText());
            b.append(" ");
        }
        return new UncastData(b.toString().trim());
    }

    @Override
    public MultiPointerAnswerData cast(UncastData data) throws IllegalArgumentException {
        return null;
    }
}

