/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model.instance;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.javarosa.core.model.instance.AbstractTreeElement;
import org.javarosa.core.model.instance.DataInstance;
import org.javarosa.core.model.instance.InstanceInitializationFactory;
import org.javarosa.core.model.instance.TreeElement;
import org.javarosa.core.model.instance.TreeReference;
import org.javarosa.core.reference.InvalidReferenceException;
import org.javarosa.core.reference.ReferenceManager;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.PrototypeFactory;
import org.javarosa.xform.parse.XFormParser;
import org.javarosa.xform.util.XFormUtils;
import org.javarosa.xml.util.InvalidStructureException;
import org.javarosa.xml.util.UnfullfilledRequirementsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.XmlPullParserException;

public class ExternalDataInstance
extends DataInstance {
    public static final TreeElement PLACEHOLDER_ROOT = new TreeElement("missing file", 0);
    private static final Logger logger = LoggerFactory.getLogger((String)XFormParser.class.getSimpleName());
    private String path;
    private TreeElement root;

    public ExternalDataInstance() {
    }

    private ExternalDataInstance(TreeElement root, String instanceId, String path) {
        super(instanceId);
        this.path = path;
        this.setName(instanceId);
        this.setRoot(root);
    }

    public static ExternalDataInstance build(String instanceSrc, String instanceId) throws IOException, UnfullfilledRequirementsException, XmlPullParserException, InvalidStructureException {
        TreeElement root;
        try {
            root = XFormUtils.getExternalInstance(ReferenceManager.instance(), instanceId, instanceSrc, true);
            if (!root.hasChildren()) {
                root = PLACEHOLDER_ROOT;
            }
        }
        catch (FileNotFoundException | InvalidReferenceException e) {
            logger.info("External instance not found, falling back to placeholder");
            root = PLACEHOLDER_ROOT;
        }
        return new ExternalDataInstance(root, instanceId, instanceSrc);
    }

    public AbstractTreeElement resolveReference(TreeReference ref) {
        try {
            return super.resolveReference(ref);
        }
        catch (DataInstance.PartialElementEncounteredException e) {
            try {
                this.parseExternalFile(false);
            }
            catch (IOException | InvalidReferenceException | InvalidStructureException | UnfullfilledRequirementsException | XmlPullParserException exception) {
                throw new RuntimeException(new DeserializationException("Unable to parse external instance: " + exception));
            }
            return this.resolveReference(ref);
        }
    }

    public AbstractTreeElement getBase() {
        return this.root;
    }

    public AbstractTreeElement getRoot() {
        if (this.root.getNumChildren() == 0) {
            throw new RuntimeException("root node has no children");
        }
        return this.root.getChildAt(0);
    }

    public boolean isUsingPlaceholder() {
        return this.getRoot().equals(PLACEHOLDER_ROOT);
    }

    private void setRoot(TreeElement topLevel) {
        this.root = new TreeElement();
        this.root.setInstanceName(this.getName());
        this.root.addChild(topLevel);
    }

    @Override
    public void initialize(InstanceInitializationFactory initializer, String instanceId) {
    }

    @Override
    public void readExternal(DataInputStream in, PrototypeFactory pf) throws IOException, DeserializationException {
        super.readExternal(in, pf);
        this.path = ExtUtil.readString(in);
        try {
            this.parseExternalFile(true);
        }
        catch (InvalidReferenceException | InvalidStructureException | UnfullfilledRequirementsException | XmlPullParserException e) {
            throw new DeserializationException("Unable to parse external instance: " + e);
        }
    }

    @Override
    public void writeExternal(DataOutputStream out) throws IOException {
        super.writeExternal(out);
        ExtUtil.write(out, this.path);
    }

    private void parseExternalFile(boolean partial) throws UnfullfilledRequirementsException, InvalidStructureException, XmlPullParserException, IOException, InvalidReferenceException {
        String instanceId = this.getInstanceId();
        this.setRoot(XFormUtils.getExternalInstance(ReferenceManager.instance(), instanceId, this.path, partial));
    }
}

